/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.prosub.controller;

import com.ejianc.business.tender.prosub.bean.ProsubWinnoticeEntity;
import com.ejianc.business.tender.prosub.service.IProsubWinnoticeService;
import com.ejianc.business.tender.prosub.vo.ProsubWinnoticeVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"prosubWinnotice"})
@Api(value="\u4e2d\u6807\u516c\u544a\u8868", tags={"\u4e2d\u6807\u516c\u544a\u8868"})
public class ProsubWinnoticeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProsubWinnoticeService service;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "sub-winnotice-code";

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProsubWinnoticeVO> saveOrUpdates(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody ProsubWinnoticeVO saveorUpdateVO) {
        ProsubWinnoticeEntity entity = (ProsubWinnoticeEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, ProsubWinnoticeEntity.class));
        if (entity.getBillCode() == null) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        ProsubWinnoticeVO vo = this.service.saveOrUpdates(entity);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u53d1\u5e03\u63a5\u53e3")
    @RequestMapping(value={"/publishWinnotice"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProsubWinnoticeVO> publishWinnotice(@RequestParam Long id) throws Exception {
        return CommonResponse.success((String)"\u53d1\u5e03\u6210\u529f\uff01", (Object)this.service.publishWinnotice(id));
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProsubWinnoticeVO> queryDetail(@RequestParam Long id) {
        ProsubWinnoticeVO subWinnoticeVO = this.service.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)subWinnoticeVO);
    }

    @ApiOperation(value="\u751f\u6210\u4e2d\u516c\u544a\u63a5\u53e3")
    @RequestMapping(value={"/saveWinnotice"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProsubWinnoticeVO> saveWinnotice(@RequestParam Long picketageId) {
        ProsubWinnoticeVO subWinnoticeVO = this.service.saveWinnotice(picketageId);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)subWinnoticeVO);
    }
}

