/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.rent.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.common.vo.SupplyFileVo;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.rent.bean.RentDocumentDetailEntity;
import com.ejianc.business.tender.rent.bean.RentDocumentEntity;
import com.ejianc.business.tender.rent.bean.RentDocumentExpertEntity;
import com.ejianc.business.tender.rent.bean.RentDocumentRecordEntity;
import com.ejianc.business.tender.rent.bean.RentDocumentSchemeEntity;
import com.ejianc.business.tender.rent.bean.RentDocumentSellEntity;
import com.ejianc.business.tender.rent.bean.RentDocumentSupplierDetailEntity;
import com.ejianc.business.tender.rent.bean.RentDocumentSupplierEntity;
import com.ejianc.business.tender.rent.bean.RentInviteDetailEntity;
import com.ejianc.business.tender.rent.bean.RentInviteEntity;
import com.ejianc.business.tender.rent.bean.RentInviteSupplierEntity;
import com.ejianc.business.tender.rent.bean.RentNoticeEntity;
import com.ejianc.business.tender.rent.bean.RentNoticeSupplierEntity;
import com.ejianc.business.tender.rent.bean.RentTalkEntity;
import com.ejianc.business.tender.rent.bean.RentTalkRecordEntity;
import com.ejianc.business.tender.rent.mapper.RentDocumentMapper;
import com.ejianc.business.tender.rent.mapper.RentDocumentSellMapper;
import com.ejianc.business.tender.rent.mapper.RentDocumentSupplierDetailMapper;
import com.ejianc.business.tender.rent.mapper.RentDocumentSupplierMapper;
import com.ejianc.business.tender.rent.service.IRentDocumentDetailService;
import com.ejianc.business.tender.rent.service.IRentDocumentExpertService;
import com.ejianc.business.tender.rent.service.IRentDocumentRecordService;
import com.ejianc.business.tender.rent.service.IRentDocumentSchemeService;
import com.ejianc.business.tender.rent.service.IRentDocumentSellService;
import com.ejianc.business.tender.rent.service.IRentDocumentService;
import com.ejianc.business.tender.rent.service.IRentDocumentSupplierDetailService;
import com.ejianc.business.tender.rent.service.IRentDocumentSupplierService;
import com.ejianc.business.tender.rent.service.IRentInviteService;
import com.ejianc.business.tender.rent.service.IRentNoticeService;
import com.ejianc.business.tender.rent.service.IRentNoticeSupplierService;
import com.ejianc.business.tender.rent.service.IRentTalkRecordService;
import com.ejianc.business.tender.rent.service.IRentTalkService;
import com.ejianc.business.tender.rent.vo.RentDocumentDetailVO;
import com.ejianc.business.tender.rent.vo.RentDocumentRecordVO;
import com.ejianc.business.tender.rent.vo.RentDocumentSchemeVO;
import com.ejianc.business.tender.rent.vo.RentDocumentSellVO;
import com.ejianc.business.tender.rent.vo.RentDocumentSupplierSellVO;
import com.ejianc.business.tender.rent.vo.RentDocumentSupplierTbVO;
import com.ejianc.business.tender.rent.vo.RentDocumentSupplierVO;
import com.ejianc.business.tender.rent.vo.RentDocumentVO;
import com.ejianc.business.tender.rent.vo.RentInviteDetailRecordVO;
import com.ejianc.business.tender.rent.vo.RentNoticeDetailTbVO;
import com.ejianc.business.tender.rent.vo.RentNoticeSupplierDetailTbVO;
import com.ejianc.business.tender.rent.vo.RentNoticeSupplierTbVO;
import com.ejianc.business.tender.rent.vo.RentNoticeSupplierVO;
import com.ejianc.business.tender.rent.vo.RentSupplierSellSchemeDetailVO;
import com.ejianc.business.tender.rent.vo.RentSupplierSellSchemeVO;
import com.ejianc.business.tender.rent.vo.RentSupplierSellVO;
import com.ejianc.business.tender.rent.vo.RentTalkVO;
import com.ejianc.business.tender.util.SendMsgUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartFile;

@Service(value="rentDocumentService")
public class RentDocumentServiceImpl
extends BaseServiceImpl<RentDocumentMapper, RentDocumentEntity>
implements IRentDocumentService {
    @Autowired
    private IRentDocumentSupplierService rentDocumentSupplierService;
    @Autowired
    private RentDocumentSupplierDetailMapper supplierDetailMapper;
    @Autowired
    private RentDocumentSupplierMapper supplierMapper;
    @Autowired
    private IRentDocumentSchemeService rentDocumentSchemeService;
    @Autowired
    private IRentDocumentSellService rentDocumentSellService;
    @Autowired
    private RentDocumentSellMapper rentDocumentSellMapper;
    @Autowired
    private IRentDocumentRecordService rentDocumentRecordService;
    @Autowired
    private IRentDocumentDetailService rentDocumentDetailService;
    @Autowired
    private IRentTalkService rentTalkService;
    @Autowired
    private IRentTalkRecordService rentTalkRecordService;
    @Autowired
    private IRentInviteService rentInviteService;
    @Autowired
    private IRentDocumentExpertService documentExpertService;
    @Autowired
    private IRentDocumentSupplierDetailService supplierDetailService;
    @Autowired
    private IRentDocumentSupplierDetailService documentSupplierDetailService;
    @Autowired
    private IRentDocumentService service;
    @Autowired
    private IProcessService processService;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IRentNoticeService rentNoticeService;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Value(value="${gysUrl.delFileUrl}")
    private String delFileUrl;
    @Value(value="${gysUrl.appHost}")
    private String appHost;
    @Value(value="${gysUrl.saveWjUrl}")
    private String saveWjUrl;
    @Value(value="${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;
    @Value(value="${gysUrl.saveOrUpdateUrl}")
    private String saveOrUpdateUrl;
    @Value(value="${gysUrl.updateSupStatusUrl}")
    private String updateSupStatusUrl;
    @Value(value="${gysUrl.addFileUrl}")
    private String addFileUrl;
    @Value(value="${gysUrl.appId}")
    private String appId;
    @Value(value="${gysUrl.appSecret}")
    private String appSecret;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_SUPPLIER_TYPE = "BT202202000003";
    private static final String BILL_TYPE = "BT211119000000003";
    private static final String SOURCE_TYPE = "documentBill02";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "invite-document-code";
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IRentNoticeSupplierService rentNoticeSupplierService;

    @Override
    @Transactional
    public RentDocumentVO publishDocument(Long id) {
        CommonResponse stringCommonResponses;
        RentDocumentEntity rentDocumentEntity = (RentDocumentEntity)((Object)super.selectById((Serializable)id));
        rentDocumentEntity.setPublishFlag(0);
        super.updateById((Object)rentDocumentEntity);
        RentDocumentSupplierTbVO rentDocumentSupplierTbVO = new RentDocumentSupplierTbVO();
        rentDocumentSupplierTbVO.setSourceId(rentDocumentEntity.getInviteId().toString());
        rentDocumentSupplierTbVO.setSourceType("\u90d1\u5dde\u4e00\u5efa\u62db\u6807\u6587\u4ef6");
        rentDocumentSupplierTbVO.setNoticeType(Integer.valueOf(1));
        rentDocumentSupplierTbVO.setProjectLinkName(rentDocumentEntity.getProjectLinkName());
        rentDocumentSupplierTbVO.setProjectLinkPhone(rentDocumentEntity.getProjectLinkPhone());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formatStart = simpleDateFormat.format(rentDocumentEntity.getOfferStartTime());
        rentDocumentSupplierTbVO.setOfferStartTime(formatStart);
        String formatEnd = simpleDateFormat.format(rentDocumentEntity.getOfferEndTime());
        rentDocumentSupplierTbVO.setOfferEndTime(formatEnd);
        rentDocumentSupplierTbVO.setContent(rentDocumentEntity.getDocumentContent());
        rentDocumentSupplierTbVO.setBrandFlag(rentDocumentEntity.getBrandFlag());
        rentDocumentSupplierTbVO.setMemo(rentDocumentEntity.getMemo());
        rentDocumentSupplierTbVO.setTenderName(rentDocumentEntity.getDocumentName());
        CommonResponse stringCommonResponse = this.proSupplierApi.getEjcCloudSystemCode();
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u62db\u6807\u6587\u4ef6\u83b7\u53d6systemId\u5931\u8d25" + stringCommonResponse.getMsg());
        }
        rentDocumentSupplierTbVO.setSystemId((String)stringCommonResponse.getData());
        RentInviteEntity rentInviteEntity = (RentInviteEntity)((Object)this.rentInviteService.selectById(rentDocumentEntity.getInviteId()));
        rentDocumentSupplierTbVO.setRentType(rentInviteEntity.getRentType());
        CommonResponse zbwjFile = this.attachmentApi.queryListBySourceId(rentDocumentEntity.getId(), BILL_TYPE, SOURCE_TYPE, null);
        String zbwjIds = null;
        List<Object> zbwjAttachIdList = new ArrayList();
        if (zbwjFile.isSuccess()) {
            List data = (List)zbwjFile.getData();
            zbwjAttachIdList = data.stream().map(AttachmentVO::getId).collect(Collectors.toList());
            zbwjIds = zbwjAttachIdList.stream().map(p -> String.valueOf(p)).collect(Collectors.joining(","));
        }
        HashMap<String, String> fileMap = new HashMap<String, String>();
        fileMap.put("fileIds", zbwjIds);
        String zbwjFileByte = null;
        try {
            zbwjFileByte = ReferHttpClientUtils.getAndHeader((String)(this.BASE_HOST + "ejc-file-web/attachment/batchdownflow"), fileMap);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JSONObject jsonZbwj = JSON.parseObject(zbwjFileByte);
        Map zbwjParam = (Map)JSONObject.parseObject((String)jsonZbwj.toJSONString(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        String dataZbwj = (String)zbwjParam.get("data");
        JSONObject zbwListJson = JSON.parseObject((String)dataZbwj);
        Map zbwjMap = (Map)JSONObject.parseObject((String)zbwListJson.toJSONString(), (TypeReference)new TypeReference<Map<String, byte[]>>(){}, (Feature[])new Feature[0]);
        HashMap streamMap = new HashMap();
        zbwjMap.forEach((key, value) -> streamMap.put(key, new ByteArrayInputStream((byte[])value)));
        String stringFb = JSONObject.toJSONString((Object)rentDocumentSupplierTbVO);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("noticeEntity", stringFb);
        HashMap files = null;
        if (!streamMap.isEmpty()) {
            files = new HashMap();
            files.put("file", streamMap);
        }
        if (!(stringCommonResponses = this.systemDataPushService.exchangeDataAndFilesWithUniversal(this.saveWjUrl, params, files, this.appId, this.appSecret, this.appHost)).isSuccess()) {
            throw new BusinessException("\u62db\u6807\u6587\u4ef6\u53d1\u5e03\u63a8\u9001\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + stringCommonResponses.getMsg());
        }
        RentDocumentVO rentDocumentVO = this.queryDetail(id);
        return rentDocumentVO;
    }

    @Override
    public RentDocumentVO bidDocument(Long id) {
        RentDocumentEntity rentDocumentEntity = (RentDocumentEntity)((Object)super.selectById((Serializable)id));
        rentDocumentEntity.setBidFlag(0);
        rentDocumentEntity.setBidTime(new Date());
        super.updateById((Object)rentDocumentEntity);
        RentDocumentVO rentDocumentVO = this.queryDetail(id);
        List entityList = this.documentExpertService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"document_id", (Object)rentDocumentVO.getId())).eq((Object)"dr", (Object)0));
        for (RentDocumentExpertEntity entity : entityList) {
            ArrayList<String> messageType = new ArrayList<String>();
            messageType.add("sys");
            ArrayList<String> sender = new ArrayList<String>();
            sender.add(entity.getExpertId() + "");
            String name = rentDocumentVO.getPurchaseType() == 0 ? rentDocumentVO.getProjectName() : rentDocumentVO.getOrgName();
            this.logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u4e13\u5bb6:>----------" + sender);
            String subject = entity.getExpertName() + "\u4e13\u5bb6\u60a8\u597d\uff0c" + name + "\u5df2\u5f00\u6807\uff0c\u540e\u7eed\u7684\u8bc4\u6807\u5f00\u59cb\u65f6\u95f4\u6211\u4eec\u4f1a\u4ee5\u77ed\u4fe1+\u6d88\u606f\u7684\u5f62\u5f0f\u901a\u77e5\u60a8\uff0c\u8bf7\u6ce8\u610f\u67e5\u770b\uff0c\u907f\u514d\u9057\u5fd8";
            String content = entity.getExpertName() + "\u4e13\u5bb6\u60a8\u597d\uff0c" + name + "\u5df2\u5f00\u6807\uff0c\u540e\u7eed\u7684\u8bc4\u6807\u5f00\u59cb\u65f6\u95f4\u6211\u4eec\u4f1a\u4ee5\u77ed\u4fe1+\u6d88\u606f\u7684\u5f62\u5f0f\u901a\u77e5\u60a8\uff0c\u8bf7\u6ce8\u610f\u67e5\u770b\uff0c\u907f\u514d\u9057\u5fd8";
            this.logger.info("\u53d1\u9001\u4fe1\u606f\u7684\u5185\u5bb9:>----------" + content);
            new SendMsgUtils().sendSysMsg(sender, subject, content, this.pushMessageApi);
        }
        return rentDocumentVO;
    }

    @Override
    public RentDocumentVO queryDetail(Long id) {
        return this.queryDocDetail(id, 0);
    }

    @Override
    public RentDocumentVO queryDetail1(Long id, Integer num) {
        return this.queryDocDetail(id, num);
    }

    @Override
    public RentDocumentVO queryDetailNum(Long id) {
        RentDocumentSchemeEntity rentDocumentSchemeEntity = (RentDocumentSchemeEntity)((Object)this.rentDocumentSchemeService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"document_id", (Object)id)).orderByDesc((Object)"talk_num")).get(0));
        return this.queryDocDetail(id, rentDocumentSchemeEntity.getTalkNum());
    }

    @Override
    @Transactional
    public Boolean supplierPushSell(HttpServletRequest request, MultipartFile file) {
        this.logger.info("\u8fdb\u5165\u62a5\u4ef7\u63a5\u53e3request-{},file-{}", (Object)request, (Object)file);
        String notice = request.getParameter("bjNoticeVO");
        this.logger.info("\u5b9e\u4f53\u4fe1\u606f-{}", (Object)notice);
        RentSupplierSellVO pushVO = (RentSupplierSellVO)JSON.parseObject((String)notice, (TypeReference)new TypeReference<RentSupplierSellVO>(){}, (Feature[])new Feature[0]);
        RentInviteEntity rentInviteEntity = (RentInviteEntity)((Object)this.rentInviteService.selectById(Long.valueOf(Long.parseLong(pushVO.getSourceId()))));
        Integer tenderStage = rentInviteEntity.getTenderStage();
        Integer talkNum = null;
        if (tenderStage == 3 || tenderStage == 6 || tenderStage == 8 || tenderStage == 9 || tenderStage == 10) {
            talkNum = 0;
        }
        if (tenderStage == 7) {
            LambdaQueryWrapper lambdaTalk = Wrappers.lambdaQuery();
            lambdaTalk.eq(RentTalkEntity::getInviteId, (Object)Long.parseLong(pushVO.getSourceId()));
            RentTalkEntity rentTalkEntity = (RentTalkEntity)((Object)this.rentTalkService.getOne((Wrapper)lambdaTalk));
            talkNum = rentTalkEntity.getTalkNum();
        }
        long sourceSupplierId = Long.parseLong(pushVO.getSourceSupplierId());
        SupplierDTO supplierVO = (SupplierDTO)this.shareSupplierApi.queryById(Long.valueOf(sourceSupplierId)).getData();
        Long inviteId = Long.parseLong(pushVO.getSourceId());
        LambdaQueryWrapper lambdaDocument = Wrappers.lambdaQuery();
        lambdaDocument.eq(RentDocumentEntity::getInviteId, (Object)inviteId);
        RentDocumentEntity rentDocumentEntity = (RentDocumentEntity)((Object)((RentDocumentMapper)this.baseMapper).selectOne((Wrapper)lambdaDocument));
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(RentDocumentSupplierEntity::getSupplierId, (Object)sourceSupplierId);
        lambdaSupplier.eq(RentDocumentSupplierEntity::getDocumentId, (Object)rentDocumentEntity.getId());
        lambdaSupplier.eq(RentDocumentSupplierEntity::getTalkNum, (Object)talkNum);
        RentDocumentSupplierEntity rentDocumentSupplierEntity = (RentDocumentSupplierEntity)((Object)this.rentDocumentSupplierService.getOne((Wrapper)lambdaSupplier));
        Long documentSupplierId = null;
        if (rentDocumentSupplierEntity != null) {
            rentDocumentSupplierEntity.setOfferTime(new Date());
            rentDocumentSupplierEntity.setLinkName(pushVO.getEmployeeName());
            rentDocumentSupplierEntity.setLinkMobile(pushVO.getEmployeeMobile());
            rentDocumentSupplierEntity.setTaxMemo(pushVO.getInvoiceNote());
            this.rentDocumentSupplierService.updateById((Object)rentDocumentSupplierEntity);
            documentSupplierId = rentDocumentSupplierEntity.getId();
            LambdaQueryWrapper lambdaScheme = Wrappers.lambdaQuery();
            lambdaScheme.eq(RentDocumentSchemeEntity::getDocumentSupplierId, (Object)rentDocumentSupplierEntity.getId());
            this.rentDocumentSchemeService.remove((Wrapper)lambdaScheme);
        }
        if (rentDocumentSupplierEntity == null) {
            RentDocumentSupplierEntity rentDocumentSupplierEntityAdd = new RentDocumentSupplierEntity();
            rentDocumentSupplierEntityAdd.setSupplierName(supplierVO.getName());
            rentDocumentSupplierEntityAdd.setSupplierId(sourceSupplierId);
            rentDocumentSupplierEntityAdd.setSupplierTenantId(supplierVO.getTenant());
            rentDocumentSupplierEntityAdd.setLinkName(pushVO.getEmployeeName());
            rentDocumentSupplierEntityAdd.setLinkMobile(pushVO.getEmployeeMobile());
            rentDocumentSupplierEntityAdd.setTaxMemo(pushVO.getInvoiceNote());
            rentDocumentSupplierEntityAdd.setOfferTime(new Date());
            rentDocumentSupplierEntityAdd.setDocumentId(rentDocumentEntity.getId());
            rentDocumentSupplierEntityAdd.setTalkNum(talkNum);
            this.rentDocumentSupplierService.save((Object)rentDocumentSupplierEntityAdd);
            documentSupplierId = rentDocumentSupplierEntityAdd.getId();
        }
        List schemeList = pushVO.getRentSchemeList();
        ArrayList<RentDocumentSchemeEntity> rentDocumentSchemeEntityArrayList = new ArrayList<RentDocumentSchemeEntity>();
        ArrayList<RentDocumentSellVO> rentDocumentSellVOList = new ArrayList<RentDocumentSellVO>();
        for (RentSupplierSellSchemeVO supplierSellSchemeVO : schemeList) {
            RentDocumentSchemeEntity rentDocumentSchemeEntity = new RentDocumentSchemeEntity();
            rentDocumentSchemeEntity.setDocumentSupplierId(documentSupplierId);
            rentDocumentSchemeEntity.setDocumentId(rentDocumentEntity.getId());
            rentDocumentSchemeEntity.setSupplierId(sourceSupplierId);
            rentDocumentSchemeEntity.setSupplierTenantId(supplierVO.getTenant());
            rentDocumentSchemeEntity.setSupplierName(supplierVO.getName());
            rentDocumentSchemeEntity.setSchemeName(supplierSellSchemeVO.getSchemeName());
            rentDocumentSchemeEntity.setMoney(supplierSellSchemeVO.getMoney());
            rentDocumentSchemeEntity.setMoneyTax(supplierSellSchemeVO.getMoneyTax());
            rentDocumentSchemeEntity.setTalkNum(talkNum);
            rentDocumentSchemeEntity.setId(IdWorker.getId());
            rentDocumentSchemeEntity.setPassFlag(1);
            rentDocumentSchemeEntityArrayList.add(rentDocumentSchemeEntity);
            List schemeDetailList = supplierSellSchemeVO.getRentSchemeDetailList();
            for (RentSupplierSellSchemeDetailVO supplierSellSchemeDetailVO : schemeDetailList) {
                RentDocumentSellVO rentDocumentSellVO = new RentDocumentSellVO();
                rentDocumentSellVO.setSchemeId(rentDocumentSchemeEntity.getId());
                rentDocumentSellVO.setDocumentId(rentDocumentEntity.getId());
                rentDocumentSellVO.setSupplierId(Long.valueOf(sourceSupplierId));
                rentDocumentSellVO.setSupplierTenantId(supplierVO.getTenant());
                rentDocumentSellVO.setSupplierName(supplierVO.getName());
                rentDocumentSellVO.setMaterialId(Long.valueOf(Long.parseLong(supplierSellSchemeDetailVO.getSourceMaterialId())));
                rentDocumentSellVO.setMaterialName(supplierSellSchemeDetailVO.getMaterialName());
                rentDocumentSellVO.setMaterialCode(supplierSellSchemeDetailVO.getMaterialCode());
                rentDocumentSellVO.setMaterialTypeId(Long.valueOf(Long.parseLong(supplierSellSchemeDetailVO.getSourceMaterialTypeId())));
                rentDocumentSellVO.setMaterialTypeName(supplierSellSchemeDetailVO.getMaterialTypeName());
                rentDocumentSellVO.setUnit(supplierSellSchemeDetailVO.getUnit());
                rentDocumentSellVO.setSpec(supplierSellSchemeDetailVO.getSpec());
                rentDocumentSellVO.setRate(supplierSellSchemeDetailVO.getRate());
                rentDocumentSellVO.setDetailRate(supplierSellSchemeDetailVO.getDetailRate());
                rentDocumentSellVO.setPrice(supplierSellSchemeDetailVO.getPrice());
                rentDocumentSellVO.setPriceTax(supplierSellSchemeDetailVO.getPriceTax());
                rentDocumentSellVO.setSchemeName(supplierSellSchemeVO.getSchemeName());
                rentDocumentSellVO.setMaterialBrand(supplierSellSchemeDetailVO.getBrand());
                rentDocumentSellVO.setBrand(supplierSellSchemeDetailVO.getSupplierBrand());
                rentDocumentSellVO.setMemo(supplierSellSchemeDetailVO.getSupplierMemo());
                rentDocumentSellVO.setMaterialMemo(supplierSellSchemeDetailVO.getMemo());
                rentDocumentSellVO.setCalculateType(supplierSellSchemeDetailVO.getCalculateType());
                rentDocumentSellVO.setPlanDay(supplierSellSchemeDetailVO.getPlanDay());
                rentDocumentSellVO.setPlanEnterDate(supplierSellSchemeDetailVO.getPlanEnterDate());
                rentDocumentSellVO.setPlanLeaveDate(supplierSellSchemeDetailVO.getPlanLeaveDate());
                rentDocumentSellVO.setReferFlag(Integer.valueOf(2));
                rentDocumentSellVO.setPassFlag(Integer.valueOf(1));
                rentDocumentSellVO.setTalkNum(talkNum);
                rentDocumentSellVOList.add(rentDocumentSellVO);
            }
        }
        this.rentDocumentSchemeService.saveBatch(rentDocumentSchemeEntityArrayList);
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(RentDocumentSellEntity::getSupplierId, (Object)sourceSupplierId);
        lambdaSell.eq(RentDocumentSellEntity::getTalkNum, (Object)talkNum);
        lambdaSell.eq(RentDocumentSellEntity::getDocumentId, (Object)rentDocumentEntity.getId());
        this.rentDocumentSellService.remove((Wrapper)lambdaSell);
        LambdaQueryWrapper lambdaDetail = Wrappers.lambdaQuery();
        lambdaDetail.eq(RentDocumentDetailEntity::getDocumentId, (Object)rentDocumentEntity.getId());
        List rentDocumentDetailList = this.rentDocumentDetailService.list((Wrapper)lambdaDetail);
        ArrayList<RentDocumentSellEntity> rentDocumentSellEntityArrayList = new ArrayList<RentDocumentSellEntity>();
        for (RentDocumentDetailEntity rentDocumentDetailEntity : rentDocumentDetailList) {
            for (RentDocumentSellVO rentDocumentSellVO : rentDocumentSellVOList) {
                RentDocumentSellEntity rentDocumentSellEntity;
                if (rentDocumentDetailEntity.getMaterialId() != null && rentDocumentDetailEntity.getMaterialTypeId().equals(rentDocumentSellVO.getMaterialTypeId()) && rentDocumentDetailEntity.getMaterialId().equals(rentDocumentSellVO.getMaterialId()) && rentDocumentDetailEntity.getRate().equals(rentDocumentSellVO.getDetailRate()) && (rentDocumentDetailEntity.getPlanEnterDate() == null ? "1" : rentDocumentDetailEntity.getPlanEnterDate()).equals(rentDocumentSellVO.getPlanEnterDate() == null ? "1" : rentDocumentSellVO.getPlanEnterDate()) && (rentDocumentDetailEntity.getPlanLeaveDate() == null ? "1" : rentDocumentDetailEntity.getPlanLeaveDate()).equals(rentDocumentDetailEntity.getPlanLeaveDate() == null ? "1" : rentDocumentDetailEntity.getPlanLeaveDate())) {
                    rentDocumentSellEntity = (RentDocumentSellEntity)((Object)BeanMapper.map((Object)rentDocumentSellVO, RentDocumentSellEntity.class));
                    rentDocumentSellEntity.setDetailId(rentDocumentDetailEntity.getId());
                    rentDocumentSellEntity.setProjectId(rentDocumentDetailEntity.getDetailProjectId());
                    rentDocumentSellEntity.setProjectName(rentDocumentDetailEntity.getDetailProjectName());
                    rentDocumentSellEntity.setNum(rentDocumentDetailEntity.getNum());
                    if (rentInviteEntity.getRentType() == 0) {
                        rentDocumentSellEntity.setMoney(rentDocumentDetailEntity.getPlanDay().multiply(rentDocumentDetailEntity.getNum().multiply(rentDocumentSellEntity.getPrice())));
                        rentDocumentSellEntity.setMoneyTax(rentDocumentDetailEntity.getPlanDay().multiply(rentDocumentDetailEntity.getNum().multiply(rentDocumentSellEntity.getPriceTax())));
                    } else {
                        rentDocumentSellEntity.setMoney(rentDocumentDetailEntity.getNum().multiply(rentDocumentSellEntity.getPrice()));
                        rentDocumentSellEntity.setMoneyTax(rentDocumentDetailEntity.getNum().multiply(rentDocumentSellEntity.getPriceTax()));
                    }
                    rentDocumentSellEntity.setSellTax(rentDocumentSellEntity.getMoneyTax().subtract(rentDocumentSellEntity.getMoney()));
                    rentDocumentSellEntityArrayList.add(rentDocumentSellEntity);
                }
                if (rentDocumentDetailEntity.getMaterialId() != null || !rentDocumentDetailEntity.getMaterialTypeId().equals(rentDocumentSellVO.getMaterialTypeId()) || !rentDocumentDetailEntity.getRate().equals(rentDocumentSellVO.getDetailRate()) || !(rentDocumentDetailEntity.getPlanEnterDate() == null ? "1" : rentDocumentDetailEntity.getPlanEnterDate()).equals(rentDocumentSellVO.getPlanEnterDate() == null ? "1" : rentDocumentSellVO.getPlanEnterDate()) || !(rentDocumentDetailEntity.getPlanLeaveDate() == null ? "1" : rentDocumentDetailEntity.getPlanLeaveDate()).equals(rentDocumentDetailEntity.getPlanLeaveDate() == null ? "1" : rentDocumentDetailEntity.getPlanLeaveDate())) continue;
                rentDocumentSellEntity = (RentDocumentSellEntity)((Object)BeanMapper.map((Object)rentDocumentSellVO, RentDocumentSellEntity.class));
                rentDocumentSellEntity.setDetailId(rentDocumentDetailEntity.getId());
                rentDocumentSellEntity.setProjectId(rentDocumentDetailEntity.getDetailProjectId());
                rentDocumentSellEntity.setProjectName(rentDocumentDetailEntity.getDetailProjectName());
                rentDocumentSellEntity.setNum(rentDocumentDetailEntity.getNum());
                if (rentInviteEntity.getRentType() == 0) {
                    rentDocumentSellEntity.setMoney(rentDocumentDetailEntity.getPlanDay().multiply(rentDocumentDetailEntity.getNum().multiply(rentDocumentSellEntity.getPrice())));
                    rentDocumentSellEntity.setMoneyTax(rentDocumentDetailEntity.getPlanDay().multiply(rentDocumentDetailEntity.getNum().multiply(rentDocumentSellEntity.getPriceTax())));
                } else {
                    rentDocumentSellEntity.setMoney(rentDocumentDetailEntity.getNum().multiply(rentDocumentSellEntity.getPrice()));
                    rentDocumentSellEntity.setMoneyTax(rentDocumentDetailEntity.getNum().multiply(rentDocumentSellEntity.getPriceTax()));
                }
                rentDocumentSellEntity.setSellTax(rentDocumentSellEntity.getMoneyTax().subtract(rentDocumentSellEntity.getMoney()));
                rentDocumentSellEntityArrayList.add(rentDocumentSellEntity);
            }
        }
        this.rentDocumentSellService.saveBatch(rentDocumentSellEntityArrayList);
        if (documentSupplierId != null) {
            this.logger.info("\u5220\u9664\u4f9b\u5e94\u5546[{}]\u9644\u4ef6\u4fe1\u606f\uff0cbillType[{}]\uff0csourceType[supplierFileType]", (Object)documentSupplierId, (Object)BILL_SUPPLIER_TYPE);
            CommonResponse attachmentResponse = this.attachmentApi.queryListBySourceId(documentSupplierId, BILL_SUPPLIER_TYPE, "supplierFileType", null);
            List attachmentVOList = (List)attachmentResponse.getData();
            if (CollectionUtils.isNotEmpty((Collection)attachmentVOList)) {
                this.logger.info("\u5f00\u59cb\u5220\u9664\u9644\u4ef6\u4fe1\u606f-----");
                String ids = attachmentVOList.stream().map(AttachmentVO::getId).map(String::valueOf).collect(Collectors.joining(","));
                CommonResponse deleteResponse = this.attachmentApi.delete(ids);
                this.logger.info("\u5220\u9664\u6587\u4ef6\u7ed3\u675f\uff0c\u5220\u9664\u7ed3\u679c\uff1a{}", deleteResponse.getData());
            }
        }
        List pzList = pushVO.getSupplyFileList();
        this.logger.info("\u62a5\u540d\u6587\u4ef6:{}", (Object)JSONObject.toJSONString((Object)pzList));
        if (CollectionUtils.isNotEmpty((Collection)pzList)) {
            ArrayList<AttachmentVO> list = new ArrayList<AttachmentVO>();
            for (SupplyFileVo e : pzList) {
                AttachmentVO attachmentVO = new AttachmentVO();
                attachmentVO.setBillType(BILL_SUPPLIER_TYPE);
                attachmentVO.setSourceId(documentSupplierId);
                attachmentVO.setSourceType("supplierFileType");
                attachmentVO.setFilePath(e.getFilePath());
                attachmentVO.setOnlinePath(e.getFilePath());
                attachmentVO.setFileName(e.getFileName());
                attachmentVO.setId(e.getFileId());
                list.add(attachmentVO);
                this.logger.info("\u4fdd\u5b58\u6587\u4ef6\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)attachmentVO));
            }
            CommonResponse stringCommonResponse = this.attachmentApi.insertBatch(list);
            this.logger.info(request + "\u62a5\u540d\u6587\u4ef6\u4e0a\u4f20\u7ed3\u679c-{}", (Object)JSONObject.toJSONString((Object)stringCommonResponse));
        }
        return true;
    }

    @Override
    public String uploadById(Long attachId, Long inviteId) {
        HashMap<String, String> fileMap = new HashMap<String, String>();
        fileMap.put("fileIds", Long.toString(attachId));
        String wjFileByte = null;
        try {
            wjFileByte = ReferHttpClientUtils.getAndHeader((String)(this.BASE_HOST + "ejc-file-web/attachment/batchdownflow"), fileMap);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JSONObject jsonwj = JSON.parseObject(wjFileByte);
        Map zbwjParam = (Map)JSONObject.parseObject((String)jsonwj.toJSONString(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        String datawj = (String)zbwjParam.get("data");
        JSONObject wListJson = JSON.parseObject((String)datawj);
        Map wjMap = (Map)JSONObject.parseObject((String)wListJson.toJSONString(), (TypeReference)new TypeReference<Map<String, byte[]>>(){}, (Feature[])new Feature[0]);
        HashMap streamMap = new HashMap();
        wjMap.forEach((key, value) -> streamMap.put(key, new ByteArrayInputStream((byte[])value)));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sourceId", Long.toString(inviteId));
        HashMap headers = new HashMap();
        HashMap files = new HashMap();
        files.put("file", streamMap);
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataAndFilesWithUniversal(this.addFileUrl, params, files, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u9644\u4ef6\u6279\u91cf\u4fee\u6539\u540c\u6b65\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + stringCommonResponse.getMsg());
        }
        return null;
    }

    @Override
    public String deleteFileById(Long sourceId, List<String> fileNames) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sourceId", sourceId);
        map.put("fileNames", fileNames);
        String stringInfo = JSONObject.toJSONString(map);
        Object response = null;
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataWithUniversal(this.delFileUrl, RequestMethod.POST, stringInfo, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u9644\u52a0\u6279\u91cf\u5220\u9664\u540c\u6b65\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + response.getMsg());
        }
        return "\u540c\u6b65\u6210\u529f";
    }

    @Override
    public RentDocumentSupplierSellVO getSupplierSchemeDetailDb(Long schemeId, Long documentId) {
        RentDocumentEntity rentDocumentEntity = (RentDocumentEntity)((Object)super.selectById((Serializable)documentId));
        RentDocumentSupplierSellVO rentDocumentSupplierSellVO = new RentDocumentSupplierSellVO();
        RentDocumentSchemeEntity rentDocumentSchemeEntity = (RentDocumentSchemeEntity)((Object)this.rentDocumentSchemeService.selectById(schemeId));
        RentDocumentSupplierEntity rentDocumentSupplierEntity = (RentDocumentSupplierEntity)((Object)this.rentDocumentSupplierService.selectById(rentDocumentSchemeEntity.getDocumentSupplierId()));
        Long supplierDetailId = rentDocumentSupplierEntity.getId();
        rentDocumentSupplierSellVO.setLinkName(rentDocumentSupplierEntity.getLinkName());
        rentDocumentSupplierSellVO.setSupplierName(rentDocumentSupplierEntity.getSupplierName());
        rentDocumentSupplierSellVO.setLinkMobile(rentDocumentSupplierEntity.getLinkMobile());
        rentDocumentSupplierSellVO.setOfferTime(rentDocumentSupplierEntity.getOfferTime());
        rentDocumentSupplierSellVO.setTaxMemo(rentDocumentSupplierEntity.getTaxMemo());
        rentDocumentSupplierSellVO.setPurchaseType(rentDocumentEntity.getPurchaseType());
        LambdaQueryWrapper lambdaScheme = Wrappers.lambdaQuery();
        lambdaScheme.eq(RentDocumentSchemeEntity::getDocumentSupplierId, (Object)supplierDetailId);
        List rentDocumentSchemeEntityList = this.rentDocumentSchemeService.list((Wrapper)lambdaScheme);
        List rentDocumentSchemeVOList = BeanMapper.mapList((Iterable)rentDocumentSchemeEntityList, RentDocumentSchemeVO.class);
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(RentDocumentSellEntity::getDocumentId, (Object)rentDocumentSupplierEntity.getDocumentId());
        List rentDocumentSellEntityList = this.rentDocumentSellService.list((Wrapper)lambdaSell);
        List rentDocumentSellVOList = BeanMapper.mapList((Iterable)rentDocumentSellEntityList, RentDocumentSellVO.class);
        Map<Long, List<RentDocumentSellVO>> sellMap = rentDocumentSellVOList.stream().collect(Collectors.groupingBy(RentDocumentSellVO::getSchemeId));
        for (RentDocumentSchemeVO rentDocumentSchemeVO : rentDocumentSchemeVOList) {
            List<RentDocumentSellVO> rentDocumentSellVOS = sellMap.get(rentDocumentSchemeVO.getId());
            rentDocumentSchemeVO.setRentDocumentSellList(rentDocumentSellVOS);
        }
        rentDocumentSupplierSellVO.setRentDocumentSchemeList(rentDocumentSchemeVOList);
        Map<String, Object> fileInfo = this.getFileInfo(supplierDetailId);
        if (fileInfo != null) {
            if (fileInfo.containsKey("attachId")) {
                Long attachId = Long.valueOf(String.valueOf(fileInfo.get("attachId")));
                rentDocumentSupplierSellVO.setAttachId(attachId);
            }
            if (fileInfo.containsKey("fileName")) {
                rentDocumentSupplierSellVO.setFileName(fileInfo.get("fileName").toString());
            }
        }
        return rentDocumentSupplierSellVO;
    }

    @Override
    public RentDocumentVO saveOrUpdates(RentDocumentVO saveorUpdateVO) {
        RentDocumentEntity entity = (RentDocumentEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, RentDocumentEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        RentDocumentVO vo = (RentDocumentVO)BeanMapper.map((Object)((Object)entity), RentDocumentVO.class);
        RentInviteEntity subInviteEntity = (RentInviteEntity)((Object)this.rentInviteService.selectById(entity.getInviteId()));
        List subInviteDetailRecordVOS = BeanMapper.mapList(subInviteEntity.getRentDetailRecord(), RentInviteDetailRecordVO.class);
        vo.setRentDetailRecord(subInviteDetailRecordVOS);
        return vo;
    }

    @Override
    public RentDocumentVO queryDocDetail(Long id, Integer talkNum) {
        RentDocumentEntity entity = (RentDocumentEntity)((Object)super.selectById((Serializable)id));
        RentDocumentVO rentDocumentVO = (RentDocumentVO)BeanMapper.map((Object)((Object)entity), RentDocumentVO.class);
        rentDocumentVO.setRentDocumentSchemeList(null);
        rentDocumentVO.setRentDocumentSellList(null);
        if (rentDocumentVO.getNoticeId() != null) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(RentNoticeSupplierEntity::getNoticeId, (Object)entity.getNoticeId());
            wrapper.ne(RentNoticeSupplierEntity::getState, (Object)1);
            List list = this.rentNoticeSupplierService.list((Wrapper)wrapper);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                List noticeSupplierVOS = BeanMapper.mapList((Iterable)list, RentNoticeSupplierVO.class);
                Map<Object, Object> documentSupplierVOMap = new HashMap();
                if (CollectionUtils.isNotEmpty((Collection)rentDocumentVO.getRentDocumentSupplierList())) {
                    documentSupplierVOMap = rentDocumentVO.getRentDocumentSupplierList().stream().filter(t -> t.getSupplierId() != null).collect(Collectors.toMap(RentDocumentSupplierVO::getSupplierId, item -> item, (v1, v2) -> v2));
                }
                for (RentNoticeSupplierVO noticeSupplier : noticeSupplierVOS) {
                    if (documentSupplierVOMap.containsKey(noticeSupplier.getSupplierId())) {
                        noticeSupplier.setDocumentType(Integer.valueOf(0));
                        continue;
                    }
                    noticeSupplier.setDocumentType(Integer.valueOf(1));
                }
                rentDocumentVO.setRentDocumentSupplierDetail(noticeSupplierVOS);
            }
        }
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(RentDocumentSupplierEntity::getDocumentId, (Object)id);
        lambda.eq(RentDocumentSupplierEntity::getTalkNum, (Object)talkNum);
        List supplierList = this.rentDocumentSupplierService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)supplierList)) {
            List rentDocumentSupplierVOS = BeanMapper.mapList((Iterable)supplierList, RentDocumentSupplierVO.class);
            LambdaQueryWrapper lambdaScheme = Wrappers.lambdaQuery();
            lambdaScheme.eq(RentDocumentSchemeEntity::getDocumentId, (Object)id);
            lambdaScheme.eq(RentDocumentSchemeEntity::getTalkNum, (Object)talkNum);
            lambdaScheme.orderByAsc(RentDocumentSchemeEntity::getSchemeName);
            List schemeList = this.rentDocumentSchemeService.list((Wrapper)lambdaScheme);
            Map<Long, List<RentDocumentSchemeEntity>> schemeMap = schemeList.stream().collect(Collectors.groupingBy(RentDocumentSchemeEntity::getDocumentSupplierId));
            if (entity.getBidFlag() == 0) {
                for (RentDocumentSupplierVO rentDocumentSupplierEntity : rentDocumentSupplierVOS) {
                    List<RentDocumentSchemeEntity> rentDocumentSchemeEntities = schemeMap.get(rentDocumentSupplierEntity.getId());
                    String schemeMoney = "";
                    for (RentDocumentSchemeEntity rentDocumentSchemeEntity : rentDocumentSchemeEntities) {
                        schemeMoney = schemeMoney + rentDocumentSchemeEntity.getSchemeName() + ":" + rentDocumentSchemeEntity.getMoneyTax().setScale(2, 5) + "\u5143;";
                    }
                    int length = schemeMoney.length();
                    String schemeMoneyNew = schemeMoney.substring(0, length - 1);
                    rentDocumentSupplierEntity.setSchemeMoney(schemeMoneyNew);
                }
                if (CollectionUtils.isNotEmpty((Collection)rentDocumentSupplierVOS)) {
                    List data;
                    List attachIds = rentDocumentSupplierVOS.stream().map(BaseVO::getId).collect(Collectors.toList());
                    HashMap map = new HashMap();
                    map.put("sourceIds", attachIds);
                    JSONObject itemJSONObj = JSONObject.parseObject((String)JSON.toJSONString(map));
                    CommonResponse listCommonResponse = this.attachmentApi.queryAllBySourceIdList(itemJSONObj);
                    if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)(data = (List)listCommonResponse.getData()))) {
                        Map attacMap = data.stream().collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));
                        for (RentDocumentSupplierVO rentDocumentSupplierVO : rentDocumentSupplierVOS) {
                            AttachmentVO attachmentVO = (AttachmentVO)attacMap.get(rentDocumentSupplierVO.getId());
                            if (attachmentVO == null) continue;
                            rentDocumentSupplierVO.setAttachId(attachmentVO.getId());
                            rentDocumentSupplierVO.setFileName(attachmentVO.getFileName());
                        }
                    }
                }
            }
            rentDocumentVO.setRentDocumentSupplierList(rentDocumentSupplierVOS);
            rentDocumentVO.setRentDocumentSupplierSchemeList(rentDocumentSupplierVOS);
            List rentDocumentDetailList = rentDocumentVO.getRentDocumentDetailList();
            LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
            lambdaSell.eq(RentDocumentSellEntity::getDocumentId, (Object)id);
            lambdaSell.eq(RentDocumentSellEntity::getTalkNum, (Object)talkNum);
            lambdaSell.orderByAsc(RentDocumentSellEntity::getSupplierId);
            lambdaSell.orderByAsc(RentDocumentSellEntity::getSchemeName);
            List sellList = this.rentDocumentSellService.list((Wrapper)lambdaSell);
            if (CollectionUtils.isNotEmpty((Collection)sellList)) {
                List rentDocumentSellVOS = BeanMapper.mapList((Iterable)sellList, RentDocumentSellVO.class);
                for (Object rentDocumentSellVO : rentDocumentSellVOS) {
                    if (entity.getBidFlag() == 1) {
                        rentDocumentSellVO.setPrice(null);
                        rentDocumentSellVO.setPriceTax(null);
                        rentDocumentSellVO.setMoney(null);
                        rentDocumentSellVO.setMoneyTax(null);
                        rentDocumentSellVO.setSellTax(null);
                        rentDocumentSellVO.setTenderNum(null);
                        rentDocumentSellVO.setTenderMoney(null);
                        rentDocumentSellVO.setTenderFlag(null);
                    }
                    if (entity.getBidFlag() != 0) continue;
                    rentDocumentSellVO.setTenderNum(null);
                    rentDocumentSellVO.setTenderMoney(null);
                    rentDocumentSellVO.setTenderFlag(null);
                }
                Map<Long, List<RentDocumentSellVO>> sellMap = rentDocumentSellVOS.stream().collect(Collectors.groupingBy(RentDocumentSellVO::getDetailId));
                for (RentDocumentDetailVO rentDocumentDetailVO : rentDocumentDetailList) {
                    ArrayList documentSupplierVOS = new ArrayList();
                    List<RentDocumentSellVO> rentDocumentSellEntities = sellMap.get(rentDocumentDetailVO.getId());
                    Map<Long, List<RentDocumentSellVO>> sellDetailMap = rentDocumentSellEntities.stream().collect(Collectors.groupingBy(RentDocumentSellVO::getSupplierId));
                    sellDetailMap.forEach((key, value) -> {
                        RentDocumentSupplierVO rentDocumentSupplierVO = new RentDocumentSupplierVO();
                        rentDocumentSupplierVO.setSupplierId(key);
                        RentDocumentSellVO rentDocumentSellVO = (RentDocumentSellVO)value.stream().findFirst().get();
                        rentDocumentSupplierVO.setSupplierName(rentDocumentSellVO.getSupplierName());
                        rentDocumentSupplierVO.setRentDocumentSellVOList(value);
                        documentSupplierVOS.add(rentDocumentSupplierVO);
                    });
                    rentDocumentDetailVO.setRentDocumentSupplierVOList(documentSupplierVOS);
                }
                List rentDocumentDetailSellList = rentDocumentVO.getRentDocumentDetailList();
                rentDocumentVO.setRentDocumentDetailSellList(rentDocumentDetailSellList);
            }
        }
        RentInviteEntity rentInviteEntity = (RentInviteEntity)((Object)this.rentInviteService.selectById(rentDocumentVO.getInviteId()));
        rentDocumentVO.setRentDetailRecord(BeanMapper.mapList(rentInviteEntity.getRentDetailRecord(), RentInviteDetailRecordVO.class));
        return rentDocumentVO;
    }

    @Override
    public List<RentDocumentSellVO> getSchemeDetail(RentDocumentSellVO rentDocumentSellVO) {
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(RentDocumentSellEntity::getSupplierId, (Object)rentDocumentSellVO.getSupplierId());
        lambdaSell.eq(RentDocumentSellEntity::getDocumentId, (Object)rentDocumentSellVO.getDocumentId());
        lambdaSell.eq(RentDocumentSellEntity::getSchemeId, (Object)rentDocumentSellVO.getSchemeId());
        List list = this.rentDocumentSellService.list((Wrapper)lambdaSell);
        List rentDocumentSellVOList = BeanMapper.mapList((Iterable)list, RentDocumentSellVO.class);
        return rentDocumentSellVOList;
    }

    @Override
    public RentDocumentSupplierSellVO getSupplierSchemeDetail(Long supplierDetailId, Long documentId) {
        RentDocumentEntity rentDocumentEntity = (RentDocumentEntity)((Object)super.selectById((Serializable)documentId));
        RentDocumentSupplierSellVO rentDocumentSupplierSellVO = new RentDocumentSupplierSellVO();
        RentDocumentSupplierEntity rentDocumentSupplierEntity = (RentDocumentSupplierEntity)((Object)this.rentDocumentSupplierService.selectById(supplierDetailId));
        rentDocumentSupplierSellVO.setLinkName(rentDocumentSupplierEntity.getLinkName());
        rentDocumentSupplierSellVO.setSupplierId(rentDocumentSupplierEntity.getSupplierId());
        rentDocumentSupplierSellVO.setSupplierName(rentDocumentSupplierEntity.getSupplierName());
        rentDocumentSupplierSellVO.setLinkMobile(rentDocumentSupplierEntity.getLinkMobile());
        rentDocumentSupplierSellVO.setOfferTime(rentDocumentSupplierEntity.getOfferTime());
        rentDocumentSupplierSellVO.setTaxMemo(rentDocumentSupplierEntity.getTaxMemo());
        rentDocumentSupplierSellVO.setPurchaseType(rentDocumentEntity.getPurchaseType());
        LambdaQueryWrapper lambdaScheme = Wrappers.lambdaQuery();
        lambdaScheme.eq(RentDocumentSchemeEntity::getDocumentSupplierId, (Object)supplierDetailId);
        List rentDocumentSchemeEntityList = this.rentDocumentSchemeService.list((Wrapper)lambdaScheme);
        List rentDocumentSchemeVOList = BeanMapper.mapList((Iterable)rentDocumentSchemeEntityList, RentDocumentSchemeVO.class);
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(RentDocumentSellEntity::getDocumentId, (Object)rentDocumentSupplierEntity.getDocumentId());
        List rentDocumentSellEntityList = this.rentDocumentSellService.list((Wrapper)lambdaSell);
        List rentDocumentSellVOList = BeanMapper.mapList((Iterable)rentDocumentSellEntityList, RentDocumentSellVO.class);
        Map<Long, List<RentDocumentSellVO>> sellMap = rentDocumentSellVOList.stream().collect(Collectors.groupingBy(RentDocumentSellVO::getSchemeId));
        for (RentDocumentSchemeVO rentDocumentSchemeVO : rentDocumentSchemeVOList) {
            List<RentDocumentSellVO> rentDocumentSellVOS = sellMap.get(rentDocumentSchemeVO.getId());
            rentDocumentSchemeVO.setRentDocumentSellList(rentDocumentSellVOS);
        }
        rentDocumentSupplierSellVO.setRentDocumentSchemeList(rentDocumentSchemeVOList);
        Map<String, Object> fileInfo = this.getFileInfo(supplierDetailId);
        if (fileInfo != null) {
            if (fileInfo.containsKey("attachId")) {
                Long attachId = Long.valueOf(String.valueOf(fileInfo.get("attachId")));
                rentDocumentSupplierSellVO.setAttachId(attachId);
            }
            if (fileInfo.containsKey("fileName")) {
                rentDocumentSupplierSellVO.setFileName(fileInfo.get("fileName").toString());
            }
        }
        return rentDocumentSupplierSellVO;
    }

    @Override
    @Transactional
    public RentDocumentVO extendDocument(RentDocumentRecordVO rentDocumentRecordVO) {
        RentDocumentRecordEntity rentDocumentRecordEntity = (RentDocumentRecordEntity)((Object)BeanMapper.map((Object)rentDocumentRecordVO, RentDocumentRecordEntity.class));
        this.rentDocumentRecordService.save((Object)rentDocumentRecordEntity);
        RentDocumentEntity rentDocumentEntity = (RentDocumentEntity)((Object)super.selectById((Serializable)rentDocumentRecordVO.getDocumentId()));
        rentDocumentEntity.setOfferEndTime(rentDocumentRecordVO.getNewTime());
        boolean b = super.updateById((Object)rentDocumentEntity);
        RentSupplierSellVO supplierSellVO = new RentSupplierSellVO();
        supplierSellVO.setSourceId(Long.toString(rentDocumentEntity.getInviteId()));
        supplierSellVO.setOfferEndTime(rentDocumentRecordVO.getNewTime());
        String stringFb = JSONObject.toJSONString((Object)supplierSellVO);
        Object response = null;
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataWithUniversal(this.updateTimeUrl, RequestMethod.POST, stringFb, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u62db\u6807\u6587\u4ef6\u540c\u6b65\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + stringCommonResponse.getMsg());
        }
        RentDocumentVO rentDocumentVO = this.queryDetail(rentDocumentRecordVO.getDocumentId());
        return rentDocumentVO;
    }

    @Override
    public RentDocumentSupplierSellVO getSupplierSchemeTalkDetail(Long supplierDetailId, Long talkId) {
        RentTalkEntity rentTalkEntity = (RentTalkEntity)((Object)this.rentTalkService.selectById(talkId));
        Integer talkNum = rentTalkEntity.getTalkNum();
        if (rentTalkEntity.getPublishFlag() == 1) {
            talkNum = talkNum - 1;
        }
        ArrayList<RentTalkVO> talkVOArrayList = new ArrayList<RentTalkVO>();
        String name = null;
        for (int a = 0; a <= talkNum; ++a) {
            RentTalkVO rentTalkVO = new RentTalkVO();
            rentTalkVO.setTalkNum(Integer.valueOf(a));
            name = a == 0 ? "\u9996\u6b21\u62a5\u4ef7" : "\u7b2c" + a + "\u8f6e\u62a5\u4ef7";
            rentTalkVO.setTalkNumName(name);
            talkVOArrayList.add(rentTalkVO);
        }
        RentDocumentSupplierSellVO rentDocumentSupplierSellVO = new RentDocumentSupplierSellVO();
        RentDocumentSupplierEntity rentDocumentSupplierEntity = (RentDocumentSupplierEntity)((Object)this.rentDocumentSupplierService.selectById(supplierDetailId));
        rentDocumentSupplierSellVO.setLinkName(rentDocumentSupplierEntity.getLinkName());
        rentDocumentSupplierSellVO.setLinkMobile(rentDocumentSupplierEntity.getLinkMobile());
        rentDocumentSupplierSellVO.setOfferTime(rentDocumentSupplierEntity.getOfferTime());
        rentDocumentSupplierSellVO.setTaxMemo(rentDocumentSupplierEntity.getTaxMemo());
        rentDocumentSupplierSellVO.setSupplierName(rentDocumentSupplierEntity.getSupplierName());
        for (RentTalkVO rentTalkVO : talkVOArrayList) {
            LambdaQueryWrapper lambdaScheme = Wrappers.lambdaQuery();
            lambdaScheme.eq(RentDocumentSchemeEntity::getDocumentId, (Object)rentDocumentSupplierEntity.getDocumentId());
            lambdaScheme.eq(RentDocumentSchemeEntity::getSupplierId, (Object)rentDocumentSupplierEntity.getSupplierId());
            lambdaScheme.eq(RentDocumentSchemeEntity::getTalkNum, (Object)rentTalkVO.getTalkNum());
            List rentDocumentSchemeEntityList = this.rentDocumentSchemeService.list((Wrapper)lambdaScheme);
            if (CollectionUtils.isEmpty((Collection)rentDocumentSchemeEntityList)) continue;
            List rentDocumentSchemeVOList = BeanMapper.mapList((Iterable)rentDocumentSchemeEntityList, RentDocumentSchemeVO.class);
            List schemePkList = rentDocumentSchemeVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
            lambdaSell.in(RentDocumentSellEntity::getSchemeId, schemePkList);
            List rentDocumentSellEntityList = this.rentDocumentSellService.list((Wrapper)lambdaSell);
            List rentDocumentSellVOList = BeanMapper.mapList((Iterable)rentDocumentSellEntityList, RentDocumentSellVO.class);
            Map<Long, List<RentDocumentSellVO>> sellMap = rentDocumentSellVOList.stream().collect(Collectors.groupingBy(RentDocumentSellVO::getSchemeId));
            for (RentDocumentSchemeVO rentDocumentSchemeVO : rentDocumentSchemeVOList) {
                List<RentDocumentSellVO> rentDocumentSellVOS = sellMap.get(rentDocumentSchemeVO.getId());
                rentDocumentSchemeVO.setRentDocumentSellList(rentDocumentSellVOS);
            }
            rentTalkVO.setRentDocumentSchemeList(rentDocumentSchemeVOList);
        }
        rentDocumentSupplierSellVO.setRentTalkVOList(talkVOArrayList);
        Map<String, Object> fileInfo = this.getFileInfo(supplierDetailId);
        if (fileInfo != null) {
            if (fileInfo.containsKey("attachId")) {
                Long attachId = Long.valueOf(String.valueOf(fileInfo.get("attachId")));
                rentDocumentSupplierSellVO.setAttachId(attachId);
            }
            if (fileInfo.containsKey("fileName")) {
                rentDocumentSupplierSellVO.setFileName(fileInfo.get("fileName").toString());
            }
        }
        return rentDocumentSupplierSellVO;
    }

    private Map<String, Object> getFileInfo(Long sourceId) {
        AttachmentVO attachmentVO;
        List data;
        HashMap<String, Object> map = new HashMap<String, Object>();
        CommonResponse attachResponse = this.attachmentApi.queryListBySourceId(sourceId, BILL_SUPPLIER_TYPE, "supplierFileType", null);
        if (attachResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)(data = (List)attachResponse.getData())) && (attachmentVO = (AttachmentVO)data.stream().findFirst().get()) != null) {
            map.put("fileName", attachmentVO.getFileName());
            map.put("attachId", attachmentVO.getId());
        }
        return map;
    }

    @Override
    public RentDocumentVO publishManyDocument(Long id) throws InvocationTargetException, IllegalAccessException {
        RentDocumentEntity rentDocumentEntity = (RentDocumentEntity)((Object)super.selectById((Serializable)id));
        rentDocumentEntity.setPublishFlag(0);
        super.updateById((Object)rentDocumentEntity);
        RentNoticeSupplierTbVO rentNoticeSupplierTbVO = new RentNoticeSupplierTbVO();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        rentNoticeSupplierTbVO.setSourceType("\u90d1\u5dde\u4e00\u5efa\u62db\u6807\u6587\u4ef6");
        rentNoticeSupplierTbVO.setSourceId(rentDocumentEntity.getInviteId().toString());
        RentInviteEntity inviteEntity = (RentInviteEntity)((Object)this.rentInviteService.selectById(rentDocumentEntity.getInviteId()));
        if (rentDocumentEntity.getTenderType() == 2) {
            rentNoticeSupplierTbVO.setNoticeType(Integer.valueOf(2));
        } else {
            rentNoticeSupplierTbVO.setNoticeType(Integer.valueOf(3));
        }
        if (rentDocumentEntity.getPurchaseType() == 1) {
            rentNoticeSupplierTbVO.setSourceProjectId(null);
            rentNoticeSupplierTbVO.setProjectName(null);
            rentNoticeSupplierTbVO.setProjectCode(null);
        } else {
            rentNoticeSupplierTbVO.setSourceProjectId(rentDocumentEntity.getProjectId().toString());
            rentNoticeSupplierTbVO.setProjectName(rentDocumentEntity.getProjectName());
            rentNoticeSupplierTbVO.setProjectCode(rentDocumentEntity.getProjectCode());
        }
        rentNoticeSupplierTbVO.setSourceOrgId(rentDocumentEntity.getOrgId().toString());
        rentNoticeSupplierTbVO.setOrgName(rentDocumentEntity.getOrgName());
        rentNoticeSupplierTbVO.setSourceUnitId(rentDocumentEntity.getUnitId().toString());
        rentNoticeSupplierTbVO.setUnitName(rentDocumentEntity.getUnitName());
        rentNoticeSupplierTbVO.setMemo(rentDocumentEntity.getMemo());
        rentNoticeSupplierTbVO.setType("RENT");
        rentNoticeSupplierTbVO.setTenderName(rentDocumentEntity.getDocumentName());
        rentNoticeSupplierTbVO.setTenderType(rentDocumentEntity.getTenderType());
        rentNoticeSupplierTbVO.setPurchaseType(rentDocumentEntity.getPurchaseType().toString());
        rentNoticeSupplierTbVO.setPurchaseName(rentDocumentEntity.getPurchaseName());
        rentNoticeSupplierTbVO.setSourceEmployeeId(rentDocumentEntity.getEmployeeId().toString());
        rentNoticeSupplierTbVO.setEmployeeName(rentDocumentEntity.getEmployeeName());
        rentNoticeSupplierTbVO.setEmployeeMobile(rentDocumentEntity.getEmployeeMobile());
        rentNoticeSupplierTbVO.setValueType(rentDocumentEntity.getValueType());
        rentNoticeSupplierTbVO.setContent(rentDocumentEntity.getDocumentContent());
        rentNoticeSupplierTbVO.setOfferStartTime(sdf.format(rentDocumentEntity.getOfferStartTime()));
        rentNoticeSupplierTbVO.setOfferEndTime(sdf.format(rentDocumentEntity.getOfferEndTime()));
        rentNoticeSupplierTbVO.setBrandFlag(rentDocumentEntity.getBrandFlag());
        rentNoticeSupplierTbVO.setProjectLinkName(rentDocumentEntity.getProjectLinkName());
        rentNoticeSupplierTbVO.setProjectLinkPhone(rentDocumentEntity.getProjectLinkPhone());
        rentNoticeSupplierTbVO.setSystemId((String)this.proSupplierApi.getEjcCloudSystemCode().getData());
        rentNoticeSupplierTbVO.setMaterialContentId(inviteEntity.getPurchaseId());
        rentNoticeSupplierTbVO.setMaterialContent(inviteEntity.getPurchaseName());
        rentNoticeSupplierTbVO.setRentType(inviteEntity.getRentType());
        rentNoticeSupplierTbVO.setSettlementClause(inviteEntity.getSettlementClause());
        ArrayList<Object> rentNoticeDetailVOS = new ArrayList<Object>();
        List<RentDocumentDetailVO> documentDetailEntityList = ((RentDocumentMapper)this.baseMapper).selectSumDetail(rentDocumentEntity.getId());
        for (RentDocumentDetailVO rentDocumentDetailEntity : documentDetailEntityList) {
            RentNoticeDetailTbVO rentNoticeDetailTbVO = new RentNoticeDetailTbVO();
            BeanUtils.copyProperties((Object)rentNoticeDetailTbVO, (Object)rentDocumentDetailEntity);
            rentNoticeDetailTbVO.setNum(rentDocumentDetailEntity.getSumNum());
            rentNoticeDetailTbVO.setMoney(rentDocumentDetailEntity.getSumMoney());
            rentNoticeDetailTbVO.setMoneyTax(rentDocumentDetailEntity.getSumMoneyTax());
            rentNoticeDetailTbVO.setSourceId(rentDocumentEntity.getInviteId().toString());
            rentNoticeDetailTbVO.setSourceMaterialId(rentDocumentDetailEntity.getMaterialId() == null ? null : rentDocumentDetailEntity.getMaterialId().toString());
            rentNoticeDetailTbVO.setSourceMaterialTypeId(rentDocumentDetailEntity.getMaterialTypeId() == null ? null : rentDocumentDetailEntity.getMaterialTypeId().toString());
            rentNoticeDetailVOS.add(rentNoticeDetailTbVO);
        }
        rentNoticeSupplierTbVO.setRentDetailList(rentNoticeDetailVOS);
        if (rentDocumentEntity.getTenderType() != 2) {
            List detailEntityList = this.supplierDetailService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RentDocumentSupplierDetailEntity::getInviteId, (Object)rentDocumentEntity.getInviteId())).eq(BaseEntity::getDr, (Object)0));
            ArrayList<RentNoticeSupplierDetailTbVO> supplierDetailTbVOList = new ArrayList<RentNoticeSupplierDetailTbVO>();
            for (RentDocumentSupplierDetailEntity supplierDetailEntity : detailEntityList) {
                RentNoticeSupplierDetailTbVO rentNoticeSupplierDetailTbVO = new RentNoticeSupplierDetailTbVO();
                rentNoticeSupplierDetailTbVO.setSourceId(supplierDetailEntity.getInviteId().toString());
                rentNoticeSupplierDetailTbVO.setSourceSupplierId(supplierDetailEntity.getSupplierId().toString());
                rentNoticeSupplierDetailTbVO.setTenantId(Long.valueOf(supplierDetailEntity.getSourceId()));
                supplierDetailTbVOList.add(rentNoticeSupplierDetailTbVO);
            }
            rentNoticeSupplierTbVO.setApplyList(supplierDetailTbVOList);
        }
        String stringFb = JSONObject.toJSONString((Object)rentNoticeSupplierTbVO);
        CommonResponse response = null;
        try {
            response = this.systemDataPushService.exchangeDataWithUniversal(this.saveOrUpdateUrl, RequestMethod.POST, stringFb, this.appId, this.appSecret, this.appHost);
            if (!response.isSuccess()) {
                throw new BusinessException("\u62db\u6807\u6587\u4ef6\u540c\u6b65\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + response.getMsg());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u62db\u6807\u6587\u4ef6\u540c\u6b65\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + response.getMsg());
        }
        return this.queryDetail(id);
    }

    @Override
    public CommonResponse delSupplier(Long id) {
        RentDocumentEntity rentDocumentEntity = (RentDocumentEntity)((Object)((RentDocumentMapper)this.baseMapper).selectById(id));
        List rentDocumentSupplierList = this.supplierMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"document_id", (Object)rentDocumentEntity.getId())).eq((Object)"dr", (Object)0));
        List supplierDetailList = this.supplierDetailMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"invite_id", (Object)rentDocumentEntity.getInviteId())).eq((Object)"dr", (Object)0));
        ArrayList oldIds = new ArrayList();
        ArrayList newIds = new ArrayList();
        rentDocumentSupplierList.stream().forEach(it -> oldIds.add(it.getSupplierId()));
        supplierDetailList.stream().forEach(it -> newIds.add(it.getSupplierId()));
        List newId = newIds.stream().filter(it -> !oldIds.contains(it)).collect(Collectors.toList());
        List newRequestList = supplierDetailList.stream().filter(it -> newId.contains(it.getSupplierId())).collect(Collectors.toList());
        ArrayList<RentNoticeSupplierDetailTbVO> signVOList = new ArrayList<RentNoticeSupplierDetailTbVO>();
        for (RentDocumentSupplierDetailEntity supplierDetailEntity : newRequestList) {
            RentNoticeSupplierDetailTbVO rentNoticeSupplierDetailTbVO = new RentNoticeSupplierDetailTbVO();
            rentNoticeSupplierDetailTbVO.setSourceId(supplierDetailEntity.getInviteId().toString());
            rentNoticeSupplierDetailTbVO.setSourceSupplierId(supplierDetailEntity.getSupplierId().toString());
            rentNoticeSupplierDetailTbVO.setTenantId(Long.valueOf(supplierDetailEntity.getSourceId()));
            rentNoticeSupplierDetailTbVO.setOutReason("\u8d85\u65f6\u672a\u62a5\u4ef7");
            signVOList.add(rentNoticeSupplierDetailTbVO);
        }
        this.logger.info("\u5254\u9664\u7684\u4f9b\u5e94\u5546" + JSON.toJSONString(signVOList));
        CommonResponse response = null;
        try {
            response = this.systemDataPushService.exchangeDataWithUniversal(this.saveOrUpdateUrl, RequestMethod.POST, JSON.toJSONString(signVOList), this.appId, this.appSecret, this.appHost);
            if (!response.isSuccess()) {
                return CommonResponse.error((String)("\u8c03\u7528\u5e73\u53f0\u62a5\u540d\u63a5\u53e3\u5931\u8d25\uff0c" + response.getMsg()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return CommonResponse.error((String)"\u8c03\u7528\u5e73\u53f0\u62a5\u540d\u63a5\u53e3\u5931\u8d25");
        }
        return CommonResponse.success((String)"\u5254\u9664\u4f9b\u5e94\u5546\u6210\u529f");
    }

    @Override
    public RentDocumentVO saveManyDocument(Long id) {
        RentDocumentEntity rentDocumentEntity = new RentDocumentEntity();
        RentInviteEntity inviteEntity = (RentInviteEntity)((Object)this.rentInviteService.selectById(id));
        rentDocumentEntity.setInviteId(inviteEntity.getId());
        rentDocumentEntity.setDocumentName(inviteEntity.getTenderName());
        if (inviteEntity.getPurchaseType() == 0) {
            rentDocumentEntity.setProjectId(inviteEntity.getProjectId());
            rentDocumentEntity.setProjectName(inviteEntity.getProjectName());
            rentDocumentEntity.setProjectCode(inviteEntity.getProjectCode());
        }
        rentDocumentEntity.setPurchaseId(inviteEntity.getPurchaseId());
        rentDocumentEntity.setPurchaseName(inviteEntity.getPurchaseName());
        rentDocumentEntity.setPurchaseType(inviteEntity.getPurchaseType());
        rentDocumentEntity.setOrgId(inviteEntity.getOrgId());
        rentDocumentEntity.setOrgName(inviteEntity.getOrgName());
        rentDocumentEntity.setParentOrgId(inviteEntity.getParentOrgId());
        rentDocumentEntity.setParentOrgName(inviteEntity.getParentOrgName());
        rentDocumentEntity.setValueType(inviteEntity.getValueType());
        rentDocumentEntity.setUnitId(inviteEntity.getUnitId());
        rentDocumentEntity.setUnitName(inviteEntity.getUnitName());
        rentDocumentEntity.setTenderType(inviteEntity.getTenderType());
        rentDocumentEntity.setSettlementClause(inviteEntity.getSettlementClause());
        rentDocumentEntity.setBidFlag(1);
        rentDocumentEntity.setPublishFlag(1);
        rentDocumentEntity.setNextFlag(1);
        List<RentInviteDetailEntity> rentNoticeDetailList = inviteEntity.getRentDetail();
        List rentDocumentDetailList = BeanMapper.mapList(rentNoticeDetailList, RentDocumentDetailEntity.class);
        for (RentDocumentDetailEntity rentDocumentDetailEntity : rentDocumentDetailList) {
            rentDocumentDetailEntity.setId(null);
        }
        rentDocumentEntity.setRentDocumentDetailList(rentDocumentDetailList);
        List<RentInviteSupplierEntity> supplierDetailList = inviteEntity.getSupplierDetail();
        List rentDocumentSupplierDetailVOS = BeanMapper.mapList(supplierDetailList, RentDocumentSupplierDetailEntity.class);
        for (RentDocumentSupplierDetailEntity rentDocumentSupplierDetailVO : rentDocumentSupplierDetailVOS) {
            rentDocumentSupplierDetailVO.setId(null);
            this.documentSupplierDetailService.saveOrUpdate((Object)rentDocumentSupplierDetailVO);
        }
        this.service.saveOrUpdate((Object)rentDocumentEntity, false);
        ProcessEntity processEntity = new ProcessEntity();
        switch (inviteEntity.getTenderType()) {
            case 3: {
                inviteEntity.setTenderStage(6);
                processEntity.setBillName("\u7ade\u4e89\u6027\u8c08\u5224");
                break;
            }
            case 4: {
                inviteEntity.setTenderStage(8);
                processEntity.setBillName("\u5355\u4e00\u6765\u6e90");
                break;
            }
            case 5: {
                inviteEntity.setTenderStage(9);
                processEntity.setBillName("\u7d27\u6025\u62db\u6807");
                break;
            }
            case 2: {
                inviteEntity.setTenderStage(10);
                processEntity.setBillName("\u8be2\u4ef7\u516c\u544a");
            }
        }
        this.rentInviteService.updateById((Object)inviteEntity);
        processEntity.setBillId(rentDocumentEntity.getId());
        processEntity.setTenderId(id);
        processEntity.setType(3);
        processEntity.setFrontendUrl("rent/fourJzDyJjXj");
        this.processService.saveOrUpdate((Object)processEntity);
        RentDocumentVO vo = (RentDocumentVO)BeanMapper.map((Object)((Object)rentDocumentEntity), RentDocumentVO.class);
        return vo;
    }

    @Override
    public RentDocumentSupplierSellVO getSupplierSchemeDetailTalk(Long supplierDetailId, Long talkId) {
        RentTalkRecordEntity rentTalkRecordEntity = (RentTalkRecordEntity)((Object)this.rentTalkRecordService.selectById(talkId));
        Integer talkNum = rentTalkRecordEntity.getTalkNum();
        if (rentTalkRecordEntity.getPublishFlag() == 1) {
            talkNum = talkNum - 1;
        }
        RentDocumentSupplierSellVO rentDocumentSupplierSellVO = new RentDocumentSupplierSellVO();
        RentDocumentSupplierEntity rentDocumentSupplierEntity = (RentDocumentSupplierEntity)((Object)this.rentDocumentSupplierService.selectById(supplierDetailId));
        rentDocumentSupplierSellVO.setLinkName(rentDocumentSupplierEntity.getLinkName());
        rentDocumentSupplierSellVO.setLinkMobile(rentDocumentSupplierEntity.getLinkMobile());
        rentDocumentSupplierSellVO.setOfferTime(rentDocumentSupplierEntity.getOfferTime());
        rentDocumentSupplierSellVO.setTaxMemo(rentDocumentSupplierEntity.getTaxMemo());
        LambdaQueryWrapper lambdaScheme = Wrappers.lambdaQuery();
        lambdaScheme.eq(RentDocumentSchemeEntity::getDocumentSupplierId, (Object)supplierDetailId);
        List rentDocumentSchemeEntityList = this.rentDocumentSchemeService.list((Wrapper)lambdaScheme);
        List rentDocumentSchemeVOList = BeanMapper.mapList((Iterable)rentDocumentSchemeEntityList, RentDocumentSchemeVO.class);
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(RentDocumentSellEntity::getDocumentId, (Object)rentDocumentSupplierEntity.getDocumentId());
        lambdaSell.eq(RentDocumentSellEntity::getTalkNum, (Object)talkNum);
        List rentDocumentSellEntityList = this.rentDocumentSellService.list((Wrapper)lambdaSell);
        List rentDocumentSellVOList = BeanMapper.mapList((Iterable)rentDocumentSellEntityList, RentDocumentSellVO.class);
        Map<Long, List<RentDocumentSellVO>> sellMap = rentDocumentSellVOList.stream().collect(Collectors.groupingBy(RentDocumentSellVO::getSchemeId));
        for (RentDocumentSchemeVO rentDocumentSchemeVO : rentDocumentSchemeVOList) {
            List<RentDocumentSellVO> rentDocumentSellVOS = sellMap.get(rentDocumentSchemeVO.getId());
            rentDocumentSchemeVO.setRentDocumentSellList(rentDocumentSellVOS);
        }
        rentDocumentSupplierSellVO.setRentDocumentSchemeList(rentDocumentSchemeVOList);
        Map<String, Object> fileInfo = this.getFileInfo(supplierDetailId);
        if (fileInfo != null) {
            if (fileInfo.containsKey("attachId")) {
                Long attachId = Long.valueOf(String.valueOf(fileInfo.get("attachId")));
                rentDocumentSupplierSellVO.setAttachId(attachId);
            }
            if (fileInfo.containsKey("fileName")) {
                rentDocumentSupplierSellVO.setFileName(fileInfo.get("fileName").toString());
            }
        }
        return rentDocumentSupplierSellVO;
    }

    @Override
    public RentDocumentVO saveDocument(Long noticeId) {
        RentDocumentEntity entity = new RentDocumentEntity();
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        RentNoticeEntity rentNoticeEntity = (RentNoticeEntity)((Object)this.rentNoticeService.selectById(noticeId));
        RentInviteEntity rentInvite = (RentInviteEntity)((Object)this.rentInviteService.selectById(rentNoticeEntity.getInviteId()));
        List<RentInviteDetailEntity> rentInviteDetailList = rentInvite.getRentDetail();
        List rentDocumentDetailList = BeanMapper.mapList(rentInviteDetailList, RentDocumentDetailEntity.class);
        for (RentDocumentDetailEntity rentDocumentDetailEntity : rentDocumentDetailList) {
            rentDocumentDetailEntity.setId(null);
        }
        entity.setRentDocumentDetailList(rentDocumentDetailList);
        entity.setProjectId(rentNoticeEntity.getProjectId());
        entity.setNoticeId(noticeId);
        entity.setProjectName(rentNoticeEntity.getProjectName());
        entity.setOrgId(rentNoticeEntity.getOrgId());
        entity.setOrgName(rentNoticeEntity.getOrgName());
        entity.setParentOrgId(rentNoticeEntity.getParentOrgId());
        entity.setParentOrgName(rentNoticeEntity.getParentOrgName());
        entity.setProjectCode(rentNoticeEntity.getProjectCode());
        entity.setDocumentName(rentNoticeEntity.getNoticeName());
        entity.setEmployeeId(rentNoticeEntity.getEmployeeId());
        entity.setEmployeeName(rentNoticeEntity.getEmployeeName());
        entity.setEmployeeMobile(rentNoticeEntity.getEmployeeMobile());
        entity.setInviteId(rentNoticeEntity.getInviteId());
        entity.setPurchaseId(rentNoticeEntity.getPurchaseId());
        entity.setPurchaseName(rentNoticeEntity.getPurchaseName());
        entity.setPurchaseType(rentNoticeEntity.getPurchaseType());
        entity.setTenderType(rentNoticeEntity.getTenderType());
        RentInviteEntity rentInviteEntity = (RentInviteEntity)((Object)this.rentInviteService.selectById(rentNoticeEntity.getInviteId()));
        entity.setValueType(rentInviteEntity.getValueType());
        entity.setBidFlag(1);
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        this.service.saveOrUpdate((Object)entity, false);
        rentInviteEntity.setTenderStage(3);
        this.rentInviteService.updateById((Object)rentInviteEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("\u62db\u6807\u6587\u4ef6");
        processEntity.setTenderId(rentNoticeEntity.getInviteId());
        processEntity.setType(3);
        processEntity.setFrontendUrl("rent/document");
        this.processService.saveOrUpdate((Object)processEntity);
        RentDocumentVO vo = (RentDocumentVO)BeanMapper.map((Object)((Object)entity), RentDocumentVO.class);
        return vo;
    }

    @Override
    public CommonResponse<Boolean> checkExpertNum(Long documentId) {
        List expertEntityList = this.documentExpertService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(RentDocumentExpertEntity::getDocumentId, (Object)documentId)).eq(BaseEntity::getDr, (Object)0));
        int totalNum = expertEntityList.size();
        if (totalNum < 3) {
            return CommonResponse.error((String)"\u6240\u9009\u4e13\u5bb6\u6570\u91cf\u81f3\u5c11\u4e3a3\u4eba\uff01", (Object)false);
        }
        if (totalNum % 2 == 0) {
            return CommonResponse.error((String)"\u6240\u9009\u4e13\u5bb6\u6570\u91cf\u5fc5\u987b\u4e3a\u5355\u6570\uff01", (Object)false);
        }
        int departmentExpertNum = (int)expertEntityList.stream().filter(entity -> "\u96c6\u56e2".equals(entity.getExpertFromName())).count();
        int projectExpertNum = (int)expertEntityList.stream().filter(entity -> "\u9879\u76ee".equals(entity.getExpertFromName())).count();
        int trueDepartmentExpertNum = (int)Math.ceil((double)totalNum * 1.0 / 3.0);
        int trueProjectExpertNum = totalNum - trueDepartmentExpertNum;
        if (departmentExpertNum != trueDepartmentExpertNum || projectExpertNum != trueProjectExpertNum) {
            return CommonResponse.error((String)("\u6240\u9009\u4e13\u5bb6\u6570\u91cf\u4e0d\u7b26\u5408\u8981\u6c42\uff01\u96c6\u56e2\u4e13\u5bb6" + trueDepartmentExpertNum + "\u4e2a,\u9879\u76ee\u4e13\u5bb6" + trueProjectExpertNum + "\u4e2a\uff01"), (Object)false);
        }
        return CommonResponse.success((String)"\u4e13\u5bb6\u9009\u53d6\u6210\u529f\uff01", (Object)true);
    }
}

