/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.rent.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.expert.bean.ExpertEvaluatingEntity;
import com.ejianc.business.tender.expert.mapper.ExpertRecordMapper;
import com.ejianc.business.tender.expert.service.IExpertEvaluatingService;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.rent.bean.RentDocumentEntity;
import com.ejianc.business.tender.rent.bean.RentDocumentSchemeEntity;
import com.ejianc.business.tender.rent.bean.RentDocumentSellEntity;
import com.ejianc.business.tender.rent.bean.RentDocumentSupplierEntity;
import com.ejianc.business.tender.rent.bean.RentInviteEntity;
import com.ejianc.business.tender.rent.bean.RentPicketageEntity;
import com.ejianc.business.tender.rent.bean.RentPicketageSupplierEntity;
import com.ejianc.business.tender.rent.bean.RentTalkEntity;
import com.ejianc.business.tender.rent.mapper.RentDocumentSchemeMapper;
import com.ejianc.business.tender.rent.mapper.RentPicketageMapper;
import com.ejianc.business.tender.rent.service.IRentDocumentSchemeService;
import com.ejianc.business.tender.rent.service.IRentDocumentSellService;
import com.ejianc.business.tender.rent.service.IRentDocumentService;
import com.ejianc.business.tender.rent.service.IRentDocumentSupplierService;
import com.ejianc.business.tender.rent.service.IRentInviteService;
import com.ejianc.business.tender.rent.service.IRentPicketageService;
import com.ejianc.business.tender.rent.service.IRentPicketageSupplierService;
import com.ejianc.business.tender.rent.service.IRentTalkService;
import com.ejianc.business.tender.rent.vo.RentDocumentDetailVO;
import com.ejianc.business.tender.rent.vo.RentDocumentSellVO;
import com.ejianc.business.tender.rent.vo.RentDocumentVO;
import com.ejianc.business.tender.rent.vo.RentPicketageSupplierVO;
import com.ejianc.business.tender.rent.vo.RentPicketageVO;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.business.tender.util.TenderTypeEnum;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="rentPicketageService")
public class RentPicketageServiceImpl
extends BaseServiceImpl<RentPicketageMapper, RentPicketageEntity>
implements IRentPicketageService {
    private static final String BILL_CODE = "invite-picketage-code";
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IExpertEvaluatingService IExpertEvaluatingService;
    @Autowired
    private IRentInviteService rentInviteService;
    @Autowired
    private IRentDocumentService rentDocumentService;
    @Autowired
    private IRentDocumentSellService rentDocumentSellService;
    @Autowired
    private IRentDocumentSchemeService rentDocumentSchemeService;
    @Autowired
    private IRentDocumentSupplierService rentDocumentSupplierService;
    @Autowired
    private RentDocumentSchemeMapper schemeMapper;
    @Autowired
    private IProcessService processService;
    @Autowired
    private IRentTalkService rentTalkService;
    @Autowired
    private IRentPicketageSupplierService rentPicketageSupplierService;
    @Autowired
    private ExpertRecordMapper recordMapper;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public RentPicketageVO savePicketage(Long evaluationId) {
        RentPicketageEntity entity = new RentPicketageEntity();
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        ExpertEvaluatingEntity rentEvaluationEntity = (ExpertEvaluatingEntity)((Object)this.IExpertEvaluatingService.selectById(evaluationId));
        RentInviteEntity inviteEntity = (RentInviteEntity)((Object)this.rentInviteService.selectById(rentEvaluationEntity.getInviteId()));
        RentDocumentEntity rentDocumentEntity = (RentDocumentEntity)((Object)this.rentDocumentService.selectById(rentEvaluationEntity.getDocumentId()));
        entity.setPicketageName(inviteEntity.getTenderName() + "\u5b9a\u6807");
        entity.setEmployeeId(rentDocumentEntity.getEmployeeId());
        entity.setPurchaseType(inviteEntity.getPurchaseType());
        entity.setEmployeeName(rentDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(rentDocumentEntity.getEmployeeMobile());
        entity.setValueType(rentDocumentEntity.getValueType());
        RentInviteEntity rentInviteEntity = (RentInviteEntity)((Object)this.rentInviteService.selectById(rentDocumentEntity.getInviteId()));
        entity.setPurchaseId(rentInviteEntity.getPurchaseId());
        entity.setPurchaseName(rentInviteEntity.getPurchaseName());
        entity.setDocumentId(rentEvaluationEntity.getDocumentId());
        entity.setEvaluationId(rentEvaluationEntity.getId());
        entity.setInviteId(rentEvaluationEntity.getInviteId());
        entity.setBidStatus(0);
        entity.setWinnoticeStatus(0);
        entity.setTrusteesId(this.sessionManager.getUserContext().getEmployeeId());
        entity.setTrusteesName(this.sessionManager.getUserContext().getEmployeeName());
        String mobilePhone = ((EmployeeVO)this.employeeApi.getById(this.sessionManager.getUserContext().getEmployeeId()).getData()).getMobilePhone();
        entity.setTrusteesPhone(mobilePhone);
        entity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode((Integer)inviteEntity.getTenderType()).getDescription());
        entity.setLineTypeName(CommonUtils.getTypeName(3));
        entity.setOrgId(inviteEntity.getOrgId());
        entity.setOrgName(inviteEntity.getOrgName());
        entity.setParentOrgId(inviteEntity.getParentOrgId());
        entity.setParentOrgName(inviteEntity.getParentOrgName());
        entity.setProjectId(inviteEntity.getProjectId());
        entity.setProjectName(inviteEntity.getProjectName());
        entity.setPurchaseId(inviteEntity.getPurchaseId());
        entity.setPurchaseName(inviteEntity.getPurchaseName());
        entity.setUnitName(inviteEntity.getUnitName());
        super.saveOrUpdate((Object)entity, false);
        RentPicketageVO vo = (RentPicketageVO)BeanMapper.map((Object)((Object)entity), RentPicketageVO.class);
        rentInviteEntity.setTenderStage(5);
        this.rentInviteService.updateById((Object)rentInviteEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("\u5b9a\u6807");
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(2);
        processEntity.setFrontendUrl("rent/picketage");
        this.processService.saveOrUpdate((Object)processEntity);
        List<RentDocumentSchemeEntity> schemeList = this.schemeMapper.selectSupplier(rentDocumentEntity.getId());
        for (RentDocumentSchemeEntity schemeEntity : schemeList) {
            BigDecimal score = this.recordMapper.selectScore(schemeEntity.getId(), schemeEntity.getSupplierId(), rentDocumentEntity.getId());
            Boolean scoreBoolean = this.schemeMapper.updateScore(schemeEntity.getId(), schemeEntity.getSupplierId(), rentDocumentEntity.getId(), score);
            if (scoreBoolean.booleanValue()) continue;
            throw new BusinessException("\u56de\u5199\u65b9\u6848\u5f97\u5206\u5931\u8d25!");
        }
        return vo;
    }

    @Override
    public RentPicketageVO queryDetail(Long id) {
        RentPicketageEntity rentPicketageEntity = (RentPicketageEntity)((Object)super.selectById((Serializable)id));
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(RentDocumentSupplierEntity::getDocumentId, (Object)rentPicketageEntity.getDocumentId());
        List supplierEntityList = this.rentDocumentSupplierService.list((Wrapper)lambdaSupplier);
        List talkNumList = supplierEntityList.stream().map(RentDocumentSupplierEntity::getTalkNum).collect(Collectors.toList());
        Integer talkNumMax = (Integer)talkNumList.stream().max(Integer::compareTo).get();
        RentDocumentEntity entity = (RentDocumentEntity)((Object)this.rentDocumentService.selectById(rentPicketageEntity.getDocumentId()));
        RentDocumentVO rentDocumentVO = (RentDocumentVO)BeanMapper.map((Object)((Object)entity), RentDocumentVO.class);
        List rentDocumentDetailList = rentDocumentVO.getRentDocumentDetailList();
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(RentDocumentSellEntity::getDocumentId, (Object)rentPicketageEntity.getDocumentId());
        lambdaSell.eq(RentDocumentSellEntity::getTalkNum, (Object)talkNumMax);
        lambdaSell.eq(RentDocumentSellEntity::getPassFlag, (Object)1);
        lambdaSell.orderByAsc(RentDocumentSellEntity::getSupplierId);
        lambdaSell.orderByAsc(RentDocumentSellEntity::getSchemeName);
        List sellList = this.rentDocumentSellService.list((Wrapper)lambdaSell);
        List rentDocumentSellVOS = BeanMapper.mapList((Iterable)sellList, RentDocumentSellVO.class);
        LambdaQueryWrapper lambdaScheme = Wrappers.lambdaQuery();
        lambdaScheme.eq(RentDocumentSchemeEntity::getDocumentId, (Object)rentPicketageEntity.getDocumentId());
        lambdaScheme.eq(RentDocumentSchemeEntity::getTalkNum, (Object)talkNumMax);
        lambdaScheme.orderByAsc(RentDocumentSchemeEntity::getSchemeName);
        List schemeList = this.rentDocumentSchemeService.list((Wrapper)lambdaScheme);
        for (RentDocumentSchemeEntity rentDocumentSchemeEntity : schemeList) {
            for (RentDocumentSellVO rentDocumentSellVO : rentDocumentSellVOS) {
                if (!rentDocumentSellVO.getSchemeId().equals(rentDocumentSchemeEntity.getId())) continue;
                rentDocumentSellVO.setScore(rentDocumentSchemeEntity.getScore());
            }
        }
        RentDocumentSellVO rentDocumentSellFirst = (RentDocumentSellVO)rentDocumentSellVOS.stream().findFirst().get();
        if (rentDocumentSellFirst.getScore() == null) {
            rentDocumentSellVOS.sort(Comparator.comparing(BaseVO::getCreateTime).reversed());
        }
        if (rentDocumentSellFirst.getScore() != null) {
            rentDocumentSellVOS.sort(Comparator.comparing(RentDocumentSellVO::getScore).reversed());
        }
        Map<Long, List<RentDocumentSellVO>> sellMap = rentDocumentSellVOS.stream().collect(Collectors.groupingBy(RentDocumentSellVO::getDetailId));
        for (RentDocumentDetailVO rentDocumentDetailVO : rentDocumentDetailList) {
            List<RentDocumentSellVO> rentDocumentSellEntities = sellMap.get(rentDocumentDetailVO.getId());
            rentDocumentDetailVO.setRentDocumentSellVOList(rentDocumentSellEntities);
        }
        RentPicketageVO rentPicketageVO = (RentPicketageVO)BeanMapper.map((Object)((Object)rentPicketageEntity), RentPicketageVO.class);
        rentPicketageVO.setRentDocumentDetailList(rentDocumentDetailList);
        if (rentDocumentSellFirst.getScore() == null) {
            rentPicketageVO.setScoreStatus(Integer.valueOf(1));
        }
        if (rentDocumentSellFirst.getScore() != null) {
            rentPicketageVO.setScoreStatus(Integer.valueOf(0));
        }
        RentInviteEntity rentInviteEntity = (RentInviteEntity)((Object)this.rentInviteService.selectById(rentPicketageVO.getInviteId()));
        rentPicketageVO.setRentType(rentInviteEntity.getRentType());
        return rentPicketageVO;
    }

    @Override
    @Transactional
    public RentPicketageVO saveOrUpdates(RentPicketageVO saveorUpdateVO) {
        RentPicketageEntity entity = (RentPicketageEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, RentPicketageEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setPicketageSupplierList(null);
        super.saveOrUpdate((Object)entity, false);
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(RentPicketageSupplierEntity::getPicketageId, (Object)entity.getId());
        this.rentPicketageSupplierService.remove((Wrapper)lambdaSupplier);
        List picketageSupplierList = saveorUpdateVO.getPicketageSupplierList();
        for (RentPicketageSupplierVO rentPicketageSupplierVO : picketageSupplierList) {
            rentPicketageSupplierVO.setTenderFlag(Integer.valueOf(0));
        }
        List rentPicketageSupplierList = BeanMapper.mapList((Iterable)picketageSupplierList, RentPicketageSupplierEntity.class);
        this.rentPicketageSupplierService.saveBatch(rentPicketageSupplierList);
        List rentDocumentDetailList = saveorUpdateVO.getRentDocumentDetailList();
        ArrayList documentSellVOArrayList = new ArrayList();
        for (RentDocumentDetailVO rentDocumentDetailVO : rentDocumentDetailList) {
            documentSellVOArrayList.addAll(rentDocumentDetailVO.getRentDocumentSellVOList());
        }
        List rentDocumentSellEntityList = BeanMapper.mapList(documentSellVOArrayList, RentDocumentSellEntity.class);
        boolean saveOrUpdateBatch = this.rentDocumentSellService.updateBatchById(rentDocumentSellEntityList);
        RentPicketageVO rentPicketageVO = this.queryDetail(saveorUpdateVO.getId());
        return rentPicketageVO;
    }

    @Override
    public RentPicketageVO saveManyPicketage(Long documentId) {
        RentPicketageEntity entity = new RentPicketageEntity();
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        RentDocumentEntity documentEntity = (RentDocumentEntity)((Object)this.rentDocumentService.selectById(documentId));
        documentEntity.setNextFlag(0);
        this.rentDocumentService.saveOrUpdate((Object)documentEntity);
        LambdaQueryWrapper lambdaTalk = Wrappers.lambdaQuery();
        lambdaTalk.eq(RentTalkEntity::getBillId, (Object)documentId);
        RentTalkEntity rentTalkEntity = (RentTalkEntity)((Object)this.rentTalkService.getOne((Wrapper)lambdaTalk));
        if (rentTalkEntity != null) {
            rentTalkEntity.setNextFlag(0);
            this.rentTalkService.updateById((Object)rentTalkEntity);
        }
        RentDocumentEntity rentDocumentEntity = (RentDocumentEntity)((Object)this.rentDocumentService.selectById(documentId));
        RentInviteEntity inviteEntity = (RentInviteEntity)((Object)this.rentInviteService.selectById(rentDocumentEntity.getInviteId()));
        entity.setPicketageName(inviteEntity.getTenderName() + "\u5b9a\u6807");
        entity.setEmployeeId(rentDocumentEntity.getEmployeeId());
        entity.setEmployeeName(rentDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(rentDocumentEntity.getEmployeeMobile());
        entity.setValueType(rentDocumentEntity.getValueType());
        RentInviteEntity rentInviteEntity = (RentInviteEntity)((Object)this.rentInviteService.selectById(rentDocumentEntity.getInviteId()));
        entity.setPurchaseId(rentInviteEntity.getPurchaseId());
        entity.setPurchaseName(rentInviteEntity.getPurchaseName());
        entity.setPurchaseType(rentInviteEntity.getPurchaseType());
        entity.setDocumentId(documentId);
        entity.setInviteId(rentDocumentEntity.getInviteId());
        entity.setBidStatus(0);
        entity.setWinnoticeStatus(0);
        entity.setTrusteesId(this.sessionManager.getUserContext().getEmployeeId());
        entity.setTrusteesName(this.sessionManager.getUserContext().getEmployeeName());
        entity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode((Integer)inviteEntity.getTenderType()).getDescription());
        entity.setLineTypeName(CommonUtils.getTypeName(0));
        entity.setOrgId(inviteEntity.getOrgId());
        entity.setOrgName(inviteEntity.getOrgName());
        entity.setParentOrgId(inviteEntity.getParentOrgId());
        entity.setParentOrgName(inviteEntity.getParentOrgName());
        entity.setProjectId(inviteEntity.getProjectId());
        entity.setProjectName(inviteEntity.getProjectName());
        entity.setPurchaseId(inviteEntity.getPurchaseId());
        entity.setPurchaseName(inviteEntity.getPurchaseName());
        entity.setUnitName(inviteEntity.getUnitName());
        super.saveOrUpdate((Object)entity, false);
        RentPicketageVO vo = (RentPicketageVO)BeanMapper.map((Object)((Object)entity), RentPicketageVO.class);
        rentInviteEntity.setTenderStage(5);
        this.rentInviteService.updateById((Object)rentInviteEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("\u5b9a\u6807");
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(2);
        processEntity.setFrontendUrl("rent/picketage");
        this.processService.saveOrUpdate((Object)processEntity);
        return vo;
    }

    @Override
    public List<RentPicketageSupplierVO> querySupplierList(Long picketageId) {
        RentPicketageEntity rentPicketageEntity = (RentPicketageEntity)((Object)super.selectById((Serializable)picketageId));
        List<RentPicketageSupplierEntity> picketageSupplierList = rentPicketageEntity.getPicketageSupplierList();
        List list = BeanMapper.mapList(picketageSupplierList, RentPicketageSupplierVO.class);
        return list;
    }

    @Override
    public RentPicketageVO saveSupplierBatch(RentPicketageVO saveorUpdateVO) {
        RentPicketageEntity stuffPicketageEntity = (RentPicketageEntity)((Object)super.selectById((Serializable)saveorUpdateVO.getId()));
        List<RentPicketageSupplierEntity> picketageSupplierList = stuffPicketageEntity.getPicketageSupplierList();
        if (CollectionUtils.isNotEmpty(picketageSupplierList)) {
            return this.queryDetail(saveorUpdateVO.getId());
        }
        List rentPicketageSupplierEntities = BeanMapper.mapList((Iterable)saveorUpdateVO.getPicketageSupplierList(), RentPicketageSupplierEntity.class);
        for (RentPicketageSupplierEntity rentPicketageSupplierEntity : rentPicketageSupplierEntities) {
            rentPicketageSupplierEntity.setTenderFlag(0);
        }
        this.rentPicketageSupplierService.saveBatch(rentPicketageSupplierEntities);
        List rentDocumentDetailList = saveorUpdateVO.getRentDocumentDetailList();
        ArrayList documentSellVOArrayList = new ArrayList();
        for (RentDocumentDetailVO rentDocumentDetailVO : rentDocumentDetailList) {
            documentSellVOArrayList.addAll(rentDocumentDetailVO.getRentDocumentSellVOList());
        }
        List rentDocumentSellEntityList = BeanMapper.mapList(documentSellVOArrayList, RentDocumentSellEntity.class);
        this.rentDocumentSellService.saveOrUpdateBatch(rentDocumentSellEntityList);
        return this.queryDetail(saveorUpdateVO.getId());
    }
}

