/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.stuff.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.expert.bean.ExpertEvaluatingEntity;
import com.ejianc.business.tender.expert.mapper.ExpertRecordMapper;
import com.ejianc.business.tender.expert.service.IExpertEvaluatingService;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.stuff.bean.StuffDocumentEntity;
import com.ejianc.business.tender.stuff.bean.StuffDocumentSchemeEntity;
import com.ejianc.business.tender.stuff.bean.StuffDocumentSellEntity;
import com.ejianc.business.tender.stuff.bean.StuffDocumentSupplierEntity;
import com.ejianc.business.tender.stuff.bean.StuffInviteEntity;
import com.ejianc.business.tender.stuff.bean.StuffPicketageEntity;
import com.ejianc.business.tender.stuff.bean.StuffPicketageSupplierEntity;
import com.ejianc.business.tender.stuff.bean.StuffTalkEntity;
import com.ejianc.business.tender.stuff.mapper.StuffDocumentSchemeMapper;
import com.ejianc.business.tender.stuff.mapper.StuffPicketageMapper;
import com.ejianc.business.tender.stuff.service.IStuffDocumentSchemeService;
import com.ejianc.business.tender.stuff.service.IStuffDocumentSellService;
import com.ejianc.business.tender.stuff.service.IStuffDocumentService;
import com.ejianc.business.tender.stuff.service.IStuffDocumentSupplierService;
import com.ejianc.business.tender.stuff.service.IStuffInviteService;
import com.ejianc.business.tender.stuff.service.IStuffPicketageService;
import com.ejianc.business.tender.stuff.service.IStuffPicketageSupplierService;
import com.ejianc.business.tender.stuff.service.IStuffTalkService;
import com.ejianc.business.tender.stuff.vo.StuffDocumentDetailVO;
import com.ejianc.business.tender.stuff.vo.StuffDocumentSellVO;
import com.ejianc.business.tender.stuff.vo.StuffDocumentVO;
import com.ejianc.business.tender.stuff.vo.StuffPicketageSupplierVO;
import com.ejianc.business.tender.stuff.vo.StuffPicketageVO;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.business.tender.util.TenderTypeEnum;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="stuffPicketageService")
public class StuffPicketageServiceImpl
extends BaseServiceImpl<StuffPicketageMapper, StuffPicketageEntity>
implements IStuffPicketageService {
    private static final String BILL_CODE = "invite-picketage-code";
    @Autowired
    private IExpertEvaluatingService IExpertEvaluatingService;
    @Autowired
    private IStuffInviteService stuffInviteService;
    @Autowired
    private IStuffDocumentService stuffDocumentService;
    @Autowired
    private IStuffDocumentSellService stuffDocumentSellService;
    @Autowired
    private IStuffDocumentSchemeService stuffDocumentSchemeService;
    @Autowired
    private IStuffDocumentSupplierService stuffDocumentSupplierService;
    @Autowired
    private StuffDocumentSchemeMapper schemeMapper;
    @Autowired
    private IProcessService processService;
    @Autowired
    private IStuffTalkService stuffTalkService;
    @Autowired
    private IStuffPicketageSupplierService stuffPicketageSupplierService;
    @Autowired
    private ExpertRecordMapper recordMapper;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IEmployeeApi employeeApi;

    @Override
    public StuffPicketageVO savePicketage(Long evaluationId) {
        StuffPicketageEntity entity = new StuffPicketageEntity();
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        ExpertEvaluatingEntity stuffEvaluationEntity = (ExpertEvaluatingEntity)((Object)this.IExpertEvaluatingService.selectById(evaluationId));
        StuffInviteEntity inviteEntity = (StuffInviteEntity)((Object)this.stuffInviteService.selectById(stuffEvaluationEntity.getInviteId()));
        StuffDocumentEntity stuffDocumentEntity = (StuffDocumentEntity)((Object)this.stuffDocumentService.selectById(stuffEvaluationEntity.getDocumentId()));
        entity.setPicketageName(inviteEntity.getTenderName() + "\u5b9a\u6807");
        entity.setPurchaseType(inviteEntity.getPurchaseType());
        entity.setEmployeeId(stuffDocumentEntity.getEmployeeId());
        entity.setEmployeeName(stuffDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(stuffDocumentEntity.getEmployeeMobile());
        entity.setValueType(stuffDocumentEntity.getValueType());
        StuffInviteEntity stuffInviteEntity = (StuffInviteEntity)((Object)this.stuffInviteService.selectById(stuffDocumentEntity.getInviteId()));
        entity.setPurchaseId(stuffInviteEntity.getPurchaseId());
        entity.setPurchaseName(stuffInviteEntity.getPurchaseName());
        entity.setDocumentId(stuffEvaluationEntity.getDocumentId());
        entity.setEvaluationId(stuffEvaluationEntity.getId());
        entity.setInviteId(stuffEvaluationEntity.getInviteId());
        entity.setBidStatus(0);
        entity.setWinnoticeStatus(0);
        entity.setTrusteesId(this.sessionManager.getUserContext().getEmployeeId());
        entity.setTrusteesName(this.sessionManager.getUserContext().getEmployeeName());
        String mobilePhone = ((EmployeeVO)this.employeeApi.getById(this.sessionManager.getUserContext().getEmployeeId()).getData()).getMobilePhone();
        entity.setTrusteesPhone(mobilePhone);
        entity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode((Integer)inviteEntity.getTenderType()).getDescription());
        entity.setLineTypeName(CommonUtils.getTypeName(0));
        entity.setOrgId(inviteEntity.getOrgId());
        entity.setOrgName(inviteEntity.getOrgName());
        entity.setParentOrgId(inviteEntity.getParentOrgId());
        entity.setParentOrgName(inviteEntity.getParentOrgName());
        entity.setProjectId(inviteEntity.getProjectId());
        entity.setProjectName(inviteEntity.getProjectName());
        entity.setPurchaseId(inviteEntity.getPurchaseId());
        entity.setPurchaseName(inviteEntity.getPurchaseName());
        entity.setUnitName(inviteEntity.getUnitName());
        super.saveOrUpdate((Object)entity, false);
        StuffPicketageVO vo = (StuffPicketageVO)BeanMapper.map((Object)((Object)entity), StuffPicketageVO.class);
        stuffInviteEntity.setTenderStage(5);
        this.stuffInviteService.updateById((Object)stuffInviteEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("\u5b9a\u6807");
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(0);
        processEntity.setFrontendUrl("stuff/picketage");
        this.processService.saveOrUpdate((Object)processEntity);
        List<StuffDocumentSchemeEntity> schemeList = this.schemeMapper.selectSupplier(stuffDocumentEntity.getId());
        for (StuffDocumentSchemeEntity schemeEntity : schemeList) {
            BigDecimal score = this.recordMapper.selectScore(schemeEntity.getId(), schemeEntity.getSupplierId(), stuffDocumentEntity.getId());
            Boolean scoreBoolean = this.schemeMapper.updateScore(schemeEntity.getId(), schemeEntity.getSupplierId(), stuffDocumentEntity.getId(), score);
            if (scoreBoolean.booleanValue()) continue;
            throw new BusinessException("\u56de\u5199\u65b9\u6848\u5f97\u5206\u5931\u8d25!");
        }
        return vo;
    }

    @Override
    @Transactional
    public StuffPicketageVO queryDetail(Long id) {
        StuffPicketageEntity stuffPicketageEntity = (StuffPicketageEntity)((Object)super.selectById((Serializable)id));
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(StuffDocumentSupplierEntity::getDocumentId, (Object)stuffPicketageEntity.getDocumentId());
        List supplierEntityList = this.stuffDocumentSupplierService.list((Wrapper)lambdaSupplier);
        List talkNumList = supplierEntityList.stream().map(StuffDocumentSupplierEntity::getTalkNum).collect(Collectors.toList());
        Integer talkNumMax = (Integer)talkNumList.stream().max(Integer::compareTo).get();
        StuffDocumentEntity entity = (StuffDocumentEntity)((Object)this.stuffDocumentService.selectById(stuffPicketageEntity.getDocumentId()));
        StuffDocumentVO stuffDocumentVO = (StuffDocumentVO)BeanMapper.map((Object)((Object)entity), StuffDocumentVO.class);
        List stuffDocumentDetailList = stuffDocumentVO.getStuffDocumentDetailList();
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(StuffDocumentSellEntity::getDocumentId, (Object)stuffPicketageEntity.getDocumentId());
        lambdaSell.eq(StuffDocumentSellEntity::getTalkNum, (Object)talkNumMax);
        lambdaSell.eq(StuffDocumentSellEntity::getPassFlag, (Object)1);
        lambdaSell.orderByAsc(StuffDocumentSellEntity::getSupplierId);
        lambdaSell.orderByAsc(StuffDocumentSellEntity::getSchemeName);
        List sellList = this.stuffDocumentSellService.list((Wrapper)lambdaSell);
        List stuffDocumentSellVOS = BeanMapper.mapList((Iterable)sellList, StuffDocumentSellVO.class);
        LambdaQueryWrapper lambdaScheme = Wrappers.lambdaQuery();
        lambdaScheme.eq(StuffDocumentSchemeEntity::getDocumentId, (Object)stuffPicketageEntity.getDocumentId());
        lambdaScheme.eq(StuffDocumentSchemeEntity::getTalkNum, (Object)talkNumMax);
        lambdaScheme.orderByAsc(StuffDocumentSchemeEntity::getSchemeName);
        List schemeList = this.stuffDocumentSchemeService.list((Wrapper)lambdaScheme);
        for (StuffDocumentSchemeEntity stuffDocumentSchemeEntity : schemeList) {
            for (StuffDocumentSellVO stuffDocumentSellVO : stuffDocumentSellVOS) {
                if (!stuffDocumentSellVO.getSchemeId().equals(stuffDocumentSchemeEntity.getId())) continue;
                stuffDocumentSellVO.setScore(stuffDocumentSchemeEntity.getScore());
            }
        }
        StuffDocumentSellVO stuffDocumentSellFirst = (StuffDocumentSellVO)stuffDocumentSellVOS.stream().findFirst().get();
        if (stuffDocumentSellFirst.getScore() == null) {
            stuffDocumentSellVOS.sort(Comparator.comparing(BaseVO::getCreateTime).reversed());
        }
        if (stuffDocumentSellFirst.getScore() != null) {
            stuffDocumentSellVOS.sort(Comparator.comparing(StuffDocumentSellVO::getScore).reversed());
        }
        Map<Long, List<StuffDocumentSellVO>> sellMap = stuffDocumentSellVOS.stream().collect(Collectors.groupingBy(StuffDocumentSellVO::getDetailId));
        for (StuffDocumentDetailVO stuffDocumentDetailVO : stuffDocumentDetailList) {
            List<StuffDocumentSellVO> stuffDocumentSellEntities = sellMap.get(stuffDocumentDetailVO.getId());
            stuffDocumentDetailVO.setStuffDocumentSellVOList(stuffDocumentSellEntities);
        }
        StuffPicketageVO stuffPicketageVO = (StuffPicketageVO)BeanMapper.map((Object)((Object)stuffPicketageEntity), StuffPicketageVO.class);
        stuffPicketageVO.setStuffDocumentDetailList(stuffDocumentDetailList);
        if (stuffDocumentSellFirst.getScore() == null) {
            stuffPicketageVO.setScoreStatus(Integer.valueOf(1));
        }
        if (stuffDocumentSellFirst.getScore() != null) {
            stuffPicketageVO.setScoreStatus(Integer.valueOf(0));
        }
        return stuffPicketageVO;
    }

    @Override
    public StuffPicketageVO saveOrUpdates(StuffPicketageVO saveorUpdateVO) {
        StuffPicketageEntity entity = (StuffPicketageEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, StuffPicketageEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(StuffPicketageSupplierEntity::getPicketageId, (Object)entity.getId());
        this.stuffPicketageSupplierService.remove((Wrapper)lambdaSupplier);
        List picketageSupplierList = saveorUpdateVO.getPicketageSupplierList();
        for (StuffPicketageSupplierVO stuffPicketageSupplierVO : picketageSupplierList) {
            stuffPicketageSupplierVO.setTenderFlag(Integer.valueOf(0));
        }
        List stuffPicketageSupplierList = BeanMapper.mapList((Iterable)picketageSupplierList, StuffPicketageSupplierEntity.class);
        this.stuffPicketageSupplierService.saveBatch(stuffPicketageSupplierList);
        List stuffDocumentDetailList = saveorUpdateVO.getStuffDocumentDetailList();
        ArrayList documentSellVOArrayList = new ArrayList();
        for (StuffDocumentDetailVO stuffDocumentDetailVO : stuffDocumentDetailList) {
            documentSellVOArrayList.addAll(stuffDocumentDetailVO.getStuffDocumentSellVOList());
        }
        List stuffDocumentSellEntityList = BeanMapper.mapList(documentSellVOArrayList, StuffDocumentSellEntity.class);
        this.stuffDocumentSellService.saveOrUpdateBatch(stuffDocumentSellEntityList);
        StuffPicketageVO stuffPicketageVO = this.queryDetail(saveorUpdateVO.getId());
        return stuffPicketageVO;
    }

    @Override
    public StuffPicketageVO saveManyPicketage(Long documentId) {
        StuffPicketageEntity entity = new StuffPicketageEntity();
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        StuffDocumentEntity documentEntity = (StuffDocumentEntity)((Object)this.stuffDocumentService.selectById(documentId));
        documentEntity.setNextFlag(0);
        this.stuffDocumentService.saveOrUpdate((Object)documentEntity);
        LambdaQueryWrapper lambdaTalk = Wrappers.lambdaQuery();
        lambdaTalk.eq(StuffTalkEntity::getBillId, (Object)documentId);
        StuffTalkEntity stuffTalkEntity = (StuffTalkEntity)((Object)this.stuffTalkService.getOne((Wrapper)lambdaTalk));
        if (stuffTalkEntity != null) {
            stuffTalkEntity.setNextFlag(0);
            this.stuffTalkService.updateById((Object)stuffTalkEntity);
        }
        StuffDocumentEntity stuffDocumentEntity = (StuffDocumentEntity)((Object)this.stuffDocumentService.selectById(documentId));
        StuffInviteEntity inviteEntity = (StuffInviteEntity)((Object)this.stuffInviteService.selectById(stuffDocumentEntity.getInviteId()));
        entity.setPicketageName(inviteEntity.getTenderName() + "\u5b9a\u6807");
        entity.setEmployeeId(stuffDocumentEntity.getEmployeeId());
        entity.setEmployeeName(stuffDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(stuffDocumentEntity.getEmployeeMobile());
        entity.setValueType(stuffDocumentEntity.getValueType());
        StuffInviteEntity stuffInviteEntity = (StuffInviteEntity)((Object)this.stuffInviteService.selectById(stuffDocumentEntity.getInviteId()));
        entity.setPurchaseId(stuffInviteEntity.getPurchaseId());
        entity.setPurchaseName(stuffInviteEntity.getPurchaseName());
        entity.setPurchaseType(inviteEntity.getPurchaseType());
        entity.setDocumentId(documentId);
        entity.setInviteId(stuffDocumentEntity.getInviteId());
        entity.setBidStatus(0);
        entity.setWinnoticeStatus(0);
        entity.setTrusteesId(this.sessionManager.getUserContext().getEmployeeId());
        entity.setTrusteesName(this.sessionManager.getUserContext().getEmployeeName());
        entity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode((Integer)inviteEntity.getTenderType()).getDescription());
        entity.setLineTypeName(CommonUtils.getTypeName(0));
        entity.setOrgId(inviteEntity.getOrgId());
        entity.setOrgName(inviteEntity.getOrgName());
        entity.setParentOrgId(inviteEntity.getParentOrgId());
        entity.setParentOrgName(inviteEntity.getParentOrgName());
        entity.setProjectId(inviteEntity.getProjectId());
        entity.setProjectName(inviteEntity.getProjectName());
        entity.setPurchaseId(inviteEntity.getPurchaseId());
        entity.setPurchaseName(inviteEntity.getPurchaseName());
        entity.setUnitName(inviteEntity.getUnitName());
        super.saveOrUpdate((Object)entity, false);
        StuffPicketageVO vo = (StuffPicketageVO)BeanMapper.map((Object)((Object)entity), StuffPicketageVO.class);
        stuffInviteEntity.setTenderStage(5);
        this.stuffInviteService.updateById((Object)stuffInviteEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("\u5b9a\u6807");
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(0);
        processEntity.setFrontendUrl("stuff/picketage");
        this.processService.saveOrUpdate((Object)processEntity);
        return vo;
    }

    @Override
    public List<StuffPicketageSupplierVO> querySupplierList(Long picketageId) {
        StuffPicketageEntity stuffPicketageEntity = (StuffPicketageEntity)((Object)super.selectById((Serializable)picketageId));
        List<StuffPicketageSupplierEntity> picketageSupplierList = stuffPicketageEntity.getPicketageSupplierList();
        List list = BeanMapper.mapList(picketageSupplierList, StuffPicketageSupplierVO.class);
        return list;
    }

    @Override
    public StuffPicketageVO saveSupplierBatch(StuffPicketageVO saveorUpdateVO) {
        StuffPicketageEntity stuffPicketageEntity = (StuffPicketageEntity)((Object)super.selectById((Serializable)saveorUpdateVO.getId()));
        List<StuffPicketageSupplierEntity> picketageSupplierList = stuffPicketageEntity.getPicketageSupplierList();
        if (CollectionUtils.isNotEmpty(picketageSupplierList)) {
            return this.queryDetail(saveorUpdateVO.getId());
        }
        List stuffPicketageSupplierEntities = BeanMapper.mapList((Iterable)saveorUpdateVO.getPicketageSupplierList(), StuffPicketageSupplierEntity.class);
        for (StuffPicketageSupplierEntity stuffPicketageSupplierEntity : stuffPicketageSupplierEntities) {
            stuffPicketageSupplierEntity.setTenderFlag(0);
        }
        this.stuffPicketageSupplierService.saveBatch(stuffPicketageSupplierEntities);
        List stuffDocumentDetailList = saveorUpdateVO.getStuffDocumentDetailList();
        ArrayList documentSellVOArrayList = new ArrayList();
        for (StuffDocumentDetailVO stuffDocumentDetailVO : stuffDocumentDetailList) {
            documentSellVOArrayList.addAll(stuffDocumentDetailVO.getStuffDocumentSellVOList());
        }
        List stuffDocumentSellEntityList = BeanMapper.mapList(documentSellVOArrayList, StuffDocumentSellEntity.class);
        this.stuffDocumentSellService.saveOrUpdateBatch(stuffDocumentSellEntityList);
        return this.queryDetail(saveorUpdateVO.getId());
    }
}

