package com.ejianc.business.tender.prosub.controller;

import com.ejianc.business.tender.prosub.bean.ProsubBidEntity;
import com.ejianc.business.tender.prosub.service.IProsubBidService;
import com.ejianc.business.tender.prosub.vo.ProsubBidVO;
import com.ejianc.business.tender.prosub.vo.ProsubPicketageSupplierVO;
import com.ejianc.business.tender.prosub.vo.ProsubPicketageVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 中标主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("prosubBid")
@Api(value = "中标主表", tags = {"中标主表"})
public class ProsubBidController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "invite-bid-code";//此处需要根据实际修改

    @Autowired
    private IProsubBidService service;


    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProsubBidVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody ProsubBidVO saveorUpdateVO) {
        ProsubBidEntity entity = BeanMapper.map(saveorUpdateVO, ProsubBidEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
        ProsubBidVO vo = BeanMapper.map(entity, ProsubBidVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    @ApiOperation("生成中标通知书接口")
    @RequestMapping(value = "/saveBid", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProsubBidVO> saveBid(@RequestParam Long picketageId) {
        ProsubBidVO subBidVO = service.saveBid(picketageId);
    	return CommonResponse.success("保存或修改单据成功！",subBidVO);
    }
    @ApiOperation("新增进展接口")
    @RequestMapping(value = "/insertProcess", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProsubPicketageVO> insertProcess(@RequestParam Long picketageId) {
        ProsubPicketageVO subPicketageVO = service.insertProcess(picketageId);
    	return CommonResponse.success("保存或修改单据成功！",subPicketageVO);
    }
    @ApiOperation("中标公告下一步接口")
    @RequestMapping(value = "/nextPaper", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProsubBidVO> nextPaper(@RequestParam Long winnoticeId) {
        ProsubBidVO subBidVO = service.nextPaper(winnoticeId);
        return CommonResponse.success("初始化基础数据成功！",subBidVO);
    }


    @ApiOperation("发布接口")
    @RequestMapping(value = "/publishBid", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProsubBidVO> publishBid(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody ProsubBidVO saveorUpdateVO) {
        ProsubBidVO subBidVO = service.publishBid(saveorUpdateVO);
        return CommonResponse.success("发布成功！",subBidVO);
    }

    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ProsubPicketageSupplierVO>> querySupplierDetail(@RequestParam Long id) {
        List<ProsubPicketageSupplierVO> list = service.querySupplierDetail(id);
        return CommonResponse.success("查询详情数据成功！",list);
    }

//    @ApiOperation("查询供应商列表详情")
//    @RequestMapping(value = "/querySupplierList", method = RequestMethod.GET)
//    @ResponseBody
//    public CommonResponse<List<ProsubPicketageSupplierVO>> querySupplierList(@RequestParam Long picketageId) {
//        List<ProsubPicketageSupplierVO> list = service.querySupplierList(picketageId);
//        return CommonResponse.success("查询详情数据成功！",list);
//    }
    @ApiOperation("定标下一步查询详情接口")
    @RequestMapping(value = "/queryDbDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProsubBidVO> queryDbDetail(@RequestParam Long picketage) {
        ProsubBidVO subBidVO = service.queryDbDetail(picketage);
        return CommonResponse.success("查询详情数据成功！",subBidVO);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProsubBidVO> vos) {
        service.removeByIds(vos.stream().map(ProsubBidVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }




}
