package com.ejianc.business.tender.stuff.service;

import com.ejianc.business.tender.stuff.vo.StuffAdviceVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.tender.stuff.bean.StuffAdviceEntity;

import java.util.List;

/**
 * 材料-中标通知书表
 * 
 * @author generator
 *
 */
public interface IStuffAdviceService extends IBaseService<StuffAdviceEntity> {

    CommonResponse<String> changeStatus(Long billId, int status, String refCode);

    String sendAdvice(Long id);

    List<StuffAdviceVO> queryAdviceList(Long id);

    /**
     * 中标通知书推送供方
     *
     * @param datInfo      推送数据
     * @param supplierId   供应商id
     * @param sourceId     单据id
     * @param billTypeCode 单据类型编码
     * @param url          推送URL
     * @param sourceName   该条单据名称
     * @return 推送结果
     */
    boolean pushBillToSupCenter(String datInfo, Long supplierId, Long sourceId, String billTypeCode, String url,
                                String sourceName);
}
