package com.ejianc.business.tradematerial.finance.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * PM支付主实体
 *
 * @author generator
 */
public class PMPayVO extends BaseVO {

    private static final long serialVersionUID = 1609891322730392923L;

    /**
     * 基础消息信息处理队列
     */
    public static final String PAY_RESULT_MESSAGE = "payresult_trade";


    public static final String SOURCE_TYPE_FINANCY_SYS = "财务通知核销";
    public static final String SOURCE_TYPE_PAYMENT_SUPPLEMENT = "付款补录核销";
    public static final String SOURCE_TYPE_PAYMENT_SUPPLEMENT_RETRN = "付款补录核销红冲";


    public static final String SOURCE_TYPE_CODE_FINANCY_SYS = "0";
    public static final String SOURCE_TYPE_CODE_PAYMENT_SUPPLEMENT = "1";

    public static final Integer PAID_FLAG_UN_HANDLE = 0;
    public static final Integer PAID_FLAG_HANDLE_SUC = 1;
    public static final Integer PAID_FLAG_HANDLE_FAIL = 2;
    public static final Integer PAID_FLAG_HANDLE_By_HAND = 3;

    private String createUserName; // 创建者名称
    private String updateUserName; // 修改者名称
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date pushTime; // 推送时间
    private Long projectId; // 项目ID
    private Long supplyId; // 供应商ID
    private Long contractId; // 合同ID（无合同为-1）
    private Long payeeId; // 收款单位ID
    private BigDecimal payMnyActual; // 实际支付金额
    private String sourceId; // 来源ID
    private String ext1; // 扩展字段
    private String ext2; // 扩展字段
    private String ext3; // 扩展字段
    private String ext4; // 扩展字段
    private String ext5; // 扩展字段
    private String ext6; // 扩展字段
    private String ext7; // 扩展字段
    private String ext8; // 扩展字段

    /**
     * 核销标识：0-未核销，1-已核销, 2-处理失败，3-手动处理
     */
    private Integer paidFlag;

    /**
     * 付款结果信息 处理成功、处理失败
     */
    private String payResultMessage;

    /**
     * 实际付款时间
     */
    private Date actualPayTime;

    /**
     * 数据来源：财务通知、付款补录
     */
    private String sourceType;

    /**
     * 数据来源编码：0-财务通知，1-付款补录
     */
    private String sourceTypeCode;

    public Integer getPaidFlag() {
        return paidFlag;
    }

    public void setPaidFlag(Integer paidFlag) {
        this.paidFlag = paidFlag;
    }

    @Override
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    @Override
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    public Date getPushTime() {
        return pushTime;
    }

    public void setPushTime(Date pushTime) {
        this.pushTime = pushTime;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Long getSupplyId() {
        return supplyId;
    }

    public void setSupplyId(Long supplyId) {
        this.supplyId = supplyId;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getPayeeId() {
        return payeeId;
    }

    public void setPayeeId(Long payeeId) {
        this.payeeId = payeeId;
    }

    public BigDecimal getPayMnyActual() {
        return payMnyActual;
    }

    public void setPayMnyActual(BigDecimal payMnyActual) {
        this.payMnyActual = payMnyActual;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getExt1() {
        return ext1;
    }

    public void setExt1(String ext1) {
        this.ext1 = ext1;
    }

    public String getExt2() {
        return ext2;
    }

    public void setExt2(String ext2) {
        this.ext2 = ext2;
    }

    public String getExt3() {
        return ext3;
    }

    public void setExt3(String ext3) {
        this.ext3 = ext3;
    }

    public String getExt4() {
        return ext4;
    }

    public void setExt4(String ext4) {
        this.ext4 = ext4;
    }

    public String getExt5() {
        return ext5;
    }

    public void setExt5(String ext5) {
        this.ext5 = ext5;
    }

    public String getExt6() {
        return ext6;
    }

    public void setExt6(String ext6) {
        this.ext6 = ext6;
    }

    public String getExt7() {
        return ext7;
    }

    public void setExt7(String ext7) {
        this.ext7 = ext7;
    }

    public String getExt8() {
        return ext8;
    }

    public void setExt8(String ext8) {
        this.ext8 = ext8;
    }

    public String getPayResultMessage() {
        return payResultMessage;
    }

    public void setPayResultMessage(String payResultMessage) {
        this.payResultMessage = payResultMessage;
    }

    public Date getActualPayTime() {
        return actualPayTime;
    }

    public void setActualPayTime(Date actualPayTime) {
        this.actualPayTime = actualPayTime;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getSourceTypeCode() {
        return sourceTypeCode;
    }

    public void setSourceTypeCode(String sourceTypeCode) {
        this.sourceTypeCode = sourceTypeCode;
    }
}
