package com.ejianc.business.tradematerial.plan.vo;

import com.ejianc.business.promaterial.plan.vo.BatPlanDetailVO;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 材料批次采购计划主表
 *
 * @author generator
 */
@ApiModel("材料批次采购计划主表")
public class BatPlanVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("项目ID")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("项目编号")
    private String projectCode;
    @ApiModelProperty("编制人")
    private Long employeeId;
    @ApiModelProperty("编制人名称")
    private String employeeName;
    @ApiModelProperty("采购单位ID")
    private Long unitId;
    @ApiModelProperty("采购单位名称")
    private String unitName;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    @ApiModelProperty("单据状态（审批必须字段）")
    private String billStateName;
    @ApiModelProperty("计划名称")
    private String planName;
    @ApiModelProperty("合同类型(0-消耗材,1-周转材,2-混凝土,3-零星材料)")
    private Integer contractType;
    @ApiModelProperty("编制日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date createDate;
    @ApiModelProperty("采购类别ID")
    private String purchaseId;
    @ApiModelProperty("采购类别名称")
    private String purchaseName;
    @ApiModelProperty("暂估金额")
    private BigDecimal temporaryMoney;
    @ApiModelProperty("组织")
    private Long orgId;
    @ApiModelProperty("组织名称")
    private String orgName;
    @ApiModelProperty("父级组织")
    private Long parentOrgId;
    @ApiModelProperty("父级组织名称")
    private String parentOrgName;
    @ApiModelProperty("项目部上级组织编码")
    private String parentOrgCode;
    @ApiModelProperty("供货开始时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date supplyStartTime;
    @ApiModelProperty("供货结束时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date supplyEndTime;
    @ApiModelProperty("付款方式ID")
    private String paymentId;
    @ApiModelProperty("付款方式名称")
    private String paymentName;
    @ApiModelProperty("拖车是否可进ID")
    private Long trailerId;
    @ApiModelProperty("拖车是否可进名称")
    private String trailerName;
    @ApiModelProperty("收货地址")
    private String takeAddress;
    @ApiModelProperty("结算条款")
    private String settlementClause;
    @ApiModelProperty("质量验收标准")
    private String planStandard;
    @ApiModelProperty("采购计划状态（0-待采购,1-采购中,2-采购完成）")
    private Integer planState;
    @ApiModelProperty("采购计划状态（0-待采购,1-采购中,2-采购完成）")
    private String planStateName;
    @ApiModelProperty("招标经办人ID")
    private Long trusteesId;
    @ApiModelProperty("招标经办人名称")
    private String trusteesName;
    private String orgCode; // 项目部编码
    @ApiModelProperty("采购类型 1-自采，2-集采")
    private String purchaseType;
    @ApiModelProperty("集采/自采")
    private String purchaseTypeName;

    @ApiModelProperty("审定产值金额")
    private BigDecimal approveOutputMny;


    @ApiModelProperty("材料批次采购计划字表（采购清单）")
    private List<BatPlanDetailVO> batPlanDetailList = new ArrayList<>();


    private List<BatPlanControlVO> batPlanControlList = new ArrayList<>();

    public List<BatPlanControlVO> getBatPlanControlList() {
        return batPlanControlList;
    }

    public void setBatPlanControlList(List<BatPlanControlVO> batPlanControlList) {
        this.batPlanControlList = batPlanControlList;
    }



    public BigDecimal getApproveOutputMny() {
        return approveOutputMny;
    }

    public void setApproveOutputMny(BigDecimal approveOutputMny) {
        this.approveOutputMny = approveOutputMny;
    }

    public String getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(String purchaseType) {
        this.purchaseType = purchaseType;
    }

    public String getPurchaseTypeName() {
        return purchaseTypeName;
    }

    public void setPurchaseTypeName(String purchaseTypeName) {
        this.purchaseTypeName = purchaseTypeName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    /**
     * 项目ID
     */
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目ID
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    /**
     * 编制人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 编制人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    /**
     * 编制人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 编制人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    /**
     * 采购单位ID
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 采购单位ID
     */
    @ReferDeserialTransfer
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    /**
     * 采购单位名称
     */
    public String getUnitName() {
        return unitName;
    }

    /**
     * 采购单位名称
     */
    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    /**
     * 计划名称
     */
    public String getPlanName() {
        return planName;
    }

    /**
     * 计划名称
     */
    public void setPlanName(String planName) {
        this.planName = planName;
    }

    /**
     * 合同类型(0-消耗材,1-周转材,2-混凝土,3-零星材料)
     */
    public Integer getContractType() {
        return contractType;
    }

    /**
     * 合同类型(0-消耗材,1-周转材,2-混凝土,3-零星材料)
     */
    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }

    /**
     * 编制日期
     */
    public java.util.Date getCreateDate() {
        return createDate;
    }

    /**
     * 编制日期
     */
    public void setCreateDate(java.util.Date createDate) {
        this.createDate = createDate;
    }

    public String getPurchaseId() {
        return purchaseId;
    }

    public void setPurchaseId(String purchaseId) {
        this.purchaseId = purchaseId;
    }

    /**
     * 采购类别名称
     */
    public String getPurchaseName() {
        return purchaseName;
    }

    /**
     * 采购类别名称
     */
    public void setPurchaseName(String purchaseName) {
        this.purchaseName = purchaseName;
    }

    /**
     * 暂估金额
     */
    public BigDecimal getTemporaryMoney() {
        return temporaryMoney;
    }

    /**
     * 暂估金额
     */
    public void setTemporaryMoney(BigDecimal temporaryMoney) {
        this.temporaryMoney = temporaryMoney;
    }

    /**
     * 组织
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    /**
     * 供货开始时间
     */
    public java.util.Date getSupplyStartTime() {
        return supplyStartTime;
    }

    /**
     * 供货开始时间
     */
    public void setSupplyStartTime(java.util.Date supplyStartTime) {
        this.supplyStartTime = supplyStartTime;
    }

    /**
     * 供货结束时间
     */
    public java.util.Date getSupplyEndTime() {
        return supplyEndTime;
    }

    /**
     * 供货结束时间
     */
    public void setSupplyEndTime(java.util.Date supplyEndTime) {
        this.supplyEndTime = supplyEndTime;
    }

    /**
     * 付款方式ID
     */
    public String getPaymentId() {
        return paymentId;
    }

    /**
     * 付款方式ID
     */
//    @ReferDeserialTransfer
    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    /**
     * 付款方式名称
     */
    public String getPaymentName() {
        return paymentName;
    }

    /**
     * 付款方式名称
     */
    public void setPaymentName(String paymentName) {
        this.paymentName = paymentName;
    }

    /**
     * 拖车是否可进ID
     */
    public Long getTrailerId() {
        return trailerId;
    }

    /**
     * 拖车是否可进ID
     */
    @ReferDeserialTransfer
    public void setTrailerId(Long trailerId) {
        this.trailerId = trailerId;
    }

    /**
     * 拖车是否可进名称
     */
    public String getTrailerName() {
        return trailerName;
    }

    /**
     * 拖车是否可进名称
     */
    public void setTrailerName(String trailerName) {
        this.trailerName = trailerName;
    }

    /**
     * 收货地址
     */
    public String getTakeAddress() {
        return takeAddress;
    }

    /**
     * 收货地址
     */
    public void setTakeAddress(String takeAddress) {
        this.takeAddress = takeAddress;
    }

    /**
     * 结算条款
     */
    public String getSettlementClause() {
        return settlementClause;
    }

    /**
     * 结算条款
     */
    public void setSettlementClause(String settlementClause) {
        this.settlementClause = settlementClause;
    }

    /**
     * 质量验收标准
     */
    public String getPlanStandard() {
        return planStandard;
    }

    /**
     * 质量验收标准
     */
    public void setPlanStandard(String planStandard) {
        this.planStandard = planStandard;
    }

    /**
     * 采购计划状态（0-待采购,1-采购中,2-采购完成）
     */
    public Integer getPlanState() {
        return planState;
    }

    /**
     * 采购计划状态（0-待采购,1-采购中,2-采购完成）
     */
    public void setPlanState(Integer planState) {
        this.planState = planState;
    }

    /**
     * 招标经办人ID
     */
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getTrusteesId() {
        return trusteesId;
    }

    /**
     * 招标经办人ID
     */
    @ReferDeserialTransfer
    public void setTrusteesId(Long trusteesId) {
        this.trusteesId = trusteesId;
    }

    /**
     * 招标经办人名称
     */
    public String getTrusteesName() {
        return trusteesName;
    }

    /**
     * 招标经办人名称
     */
    public void setTrusteesName(String trusteesName) {
        this.trusteesName = trusteesName;
    }

    public String getPlanStateName() {
        return planStateName;
    }

    public void setPlanStateName(String planStateName) {
        this.planStateName = planStateName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    /**
     * 材料批次采购计划字表（采购清单）
     */
    public List<BatPlanDetailVO> getBatPlanDetailList() {
        return batPlanDetailList;
    }

    /**
     * 材料批次采购计划字表（采购清单）
     */
    public void setBatPlanDetailList(List<BatPlanDetailVO> batPlanDetailList) {
        this.batPlanDetailList = batPlanDetailList;
    }
}
