package com.ejianc.business.trade.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.trade.bean.ConfirmationZiEntity;
/**
 * 订货确认单
 * 
 * @author generator
 * 
 */
 @TableName("t_trade_confirmation")
public class ConfirmationEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="create_user_name")
    private String createUserName; // 编制人
    @TableField(value="operator_id")
    private Long operatorId; // 经办人ID
    @TableField(value="operator_name")
    private String operatorName; // 经办人姓名
    @TableField(value="update_user_name")
    private String updateUserName; // 修改者
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="dhdw_id")
    private Long dhdwId; // 订货单位id
    @TableField(value="dhdw_name")
    private String dhdwName; // 订货单位名称
    @TableField(value="lxr_id")
    private Long lxrId; // 联系人id
    @TableField(value="lxr_name")
    private String lxrName; // 联系人
    @TableField(value="lxfs")
    private String lxfs; // 联系方式
    @TableField(value="contract_id")
    private Long contractId; // 采购合同id
    @TableField(value="contract_name")
    private String contractName; // 采购合同名称
    @TableField(value="receive_address")
    private String receiveAddress; // 收货地址


    public String getReceiveAddress() {
        return receiveAddress;
    }

    public void setReceiveAddress(String receiveAddress) {
        this.receiveAddress = receiveAddress;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    @TableField(exist=false)
    @SubEntity(serviceName="confirmationZiService", pidName = "zhuId")
    private List<ConfirmationZiEntity> confirmationZiList = new ArrayList<>(); // 订货确认单子表
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public Long getDhdwId() {
        return dhdwId;
    }

    public void setDhdwId(Long dhdwId) {
        this.dhdwId = dhdwId;
    }
    public String getDhdwName() {
        return dhdwName;
    }

    public void setDhdwName(String dhdwName) {
        this.dhdwName = dhdwName;
    }
    public Long getLxrId() {
        return lxrId;
    }

    public void setLxrId(Long lxrId) {
        this.lxrId = lxrId;
    }
    public String getLxrName() {
        return lxrName;
    }

    public void setLxrName(String lxrName) {
        this.lxrName = lxrName;
    }
    public String getLxfs() {
        return lxfs;
    }

    public void setLxfs(String lxfs) {
        this.lxfs = lxfs;
    }
    

    public List<ConfirmationZiEntity> getConfirmationZiList() {
        return confirmationZiList;
    }

    public void setConfirmationZiList(List<ConfirmationZiEntity> confirmationZiList) {
        this.confirmationZiList = confirmationZiList;
    }
}
