/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tradematerial.contract.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.tradematerial.contract.bean.ContractEntity;
import com.ejianc.business.tradematerial.contract.bean.ContractFreezeEntity;
import com.ejianc.business.tradematerial.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.tradematerial.contract.service.IContractFreezeService;
import com.ejianc.business.tradematerial.contract.service.IContractService;
import com.ejianc.business.tradematerial.contract.vo.ContractVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="contractFreeze")
public class ContractFreezeBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IContractFreezeService service;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IBillTypeApi billTypeApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("-------------\u8fdb\u5165\u5408\u540c\u51bb\u7ed3/\u89e3\u51bbafterSubmitProcessor\u65b9\u6cd5-------------------------");
        ContractFreezeEntity entity = (ContractFreezeEntity)((Object)this.service.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        this.logger.info("\u67e5\u8be2\u51fa\u7528\u6237\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)userContext));
        entity.setCommitDate(new Date());
        entity.setCommitUserCode(userContext.getUserCode());
        entity.setCommitUserName(userContext.getUserName());
        this.service.saveOrUpdate((Object)entity);
        this.logger.info("\u63d0\u4ea4\u524d\u56de\u8c03\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)entity)));
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("-------------\u7ec8\u5ba1\u5ba1\u6838\u56de\u8c03----------------");
        ContractFreezeEntity contractFreezeEntity = (ContractFreezeEntity)((Object)this.service.selectById(billId));
        if (contractFreezeEntity != null) {
            contractFreezeEntity.setEffectiveDate(new Date());
            this.service.saveOrUpdate((Object)contractFreezeEntity, false);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter("eq", (Object)contractFreezeEntity.getContractId()));
            List contractList = this.contractService.queryList(queryParam);
            ContractEntity contractEntity = (ContractEntity)((Object)contractList.get(0));
            if (PerformanceStatusEnum.\u5df2\u51bb\u7ed3.getCode().equals(contractFreezeEntity.getPerformanceStatus())) {
                contractEntity.setPerformanceStatus(PerformanceStatusEnum.\u5df2\u51bb\u7ed3.getCode());
            } else if (PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode().equals(contractFreezeEntity.getPerformanceStatus())) {
                contractEntity.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
            }
            this.contractService.saveOrUpdate((Object)contractEntity, false);
            this.contractService.pushContract((ContractVO)BeanMapper.map((Object)((Object)contractEntity), ContractVO.class));
            this.logger.info("\u7ec8\u5ba1\u5ba1\u6838\u5b8c\uff0c\u5408\u540c\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)contractEntity)));
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u5408\u540c\u51bb\u7ed3/\u89e3\u51bb\u4e0d\u5141\u8bb8\u64a4\u56de\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        return CommonResponse.success((String)"\u5f03\u5ba1/\u64a4\u56de\u524d\u6821\u9a8c\u56de\u8c03\u6210\u529f\uff01");
    }
}

