/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.trade.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.trade.bean.ClwjxjglEntity;
import com.ejianc.business.trade.mapper.ClwjxjglMapper;
import com.ejianc.business.trade.service.IClwjxjglService;
import com.ejianc.business.trade.utils.DetailIndexExcelReader;
import com.ejianc.business.trade.utils.ImportVo;
import com.ejianc.business.trade.vo.ClwjxjglZiVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="clwjxjglService")
public class ClwjxjglServiceImpl
extends BaseServiceImpl<ClwjxjglMapper, ClwjxjglEntity>
implements IClwjxjglService {
    @Autowired
    private IClwjxjglService service;
    @Autowired
    private IBillCodeApi billCodeApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public CommonResponse<JSONObject> excelImportInfo(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
        if (size == null || size != 1) {
            return CommonResponse.error((String)"\u6587\u4ef6\u9875\u7b7e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List<List<List<String>>> resList = DetailIndexExcelReader.readExcel(mf);
        List<List<String>> result0 = resList.get(0);
        if (result0.size() > 0 && result0.get(0).size() < 13) {
            return CommonResponse.error((String)"\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        ImportVo importVo0 = this.excelImportSub(result0);
        JSONObject json = new JSONObject();
        json.put("successList", (Object)importVo0.getSubList());
        json.put("errorList", (Object)importVo0.getErrorList());
        return CommonResponse.success((Object)json);
    }

    private ImportVo excelImportSub(List<List<String>> result) {
        ImportVo res = new ImportVo();
        if (result != null && result.size() > 0) {
            ArrayList<ClwjxjglZiVO> detailVoList = new ArrayList<ClwjxjglZiVO>();
            for (int i = 0; i < result.size(); ++i) {
                List<String> datas = result.get(i);
                ClwjxjglZiVO vo = new ClwjxjglZiVO();
                vo.setFlag(true);
                String materialCode = datas.get(0);
                vo.setMaterialCode(materialCode);
                String materialName = datas.get(1);
                vo.setMaterialName(materialName);
                String spec = datas.get(2);
                vo.setSpec(spec);
                String unit = datas.get(3);
                vo.setUnit(unit);
                String price = datas.get(4);
                String priceSourceName = datas.get(5);
                String yxrq = datas.get(6);
                String cjId = datas.get(7);
                String cjName = datas.get(8);
                vo.setCjName(cjName);
                String cjJc = datas.get(9);
                vo.setCjJc(cjJc);
                try {
                    Long aLong = Long.valueOf(cjId);
                    vo.setCjId(aLong);
                }
                catch (Exception e) {
                    vo.setFlag(false);
                }
                try {
                    vo.setPrice(new BigDecimal(price));
                }
                catch (Exception e) {
                    vo.setFlag(false);
                }
                if (priceSourceName.equals("\u7f51\u4ef7")) {
                    vo.setPriceSourceId(Long.valueOf(1516365790259974146L));
                    vo.setPriceSourceName("\u7f51\u4ef7");
                } else if (priceSourceName.equals("\u8be2\u4ef7")) {
                    vo.setPriceSourceId(Long.valueOf(1516365822166044673L));
                    vo.setPriceSourceName("\u8be2\u4ef7");
                }
                SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
                Date date = null;
                try {
                    date = ft.parse(yxrq);
                    vo.setXjrq(date);
                }
                catch (ParseException e) {
                    vo.setFlag(false);
                }
                detailVoList.add(vo);
            }
            ArrayList<ClwjxjglZiVO> successList = new ArrayList<ClwjxjglZiVO>();
            ArrayList<ClwjxjglZiVO> errorList = new ArrayList<ClwjxjglZiVO>();
            for (ClwjxjglZiVO vo : detailVoList) {
                if (vo.getFlag()) {
                    successList.add(vo);
                    continue;
                }
                errorList.add(vo);
            }
            res.setErrorList(errorList);
            res.setSubList(successList);
        }
        return res;
    }

    public static void main(String[] args) {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String format = simpleDateFormat.format(date);
        Date parse = null;
        try {
            parse = simpleDateFormat.parse(format);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }
}

