/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.trade.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.trade.bean.PriceLibraryEntity;
import com.ejianc.business.trade.controller.PriceLibraryController;
import com.ejianc.business.trade.mapper.PriceLibraryMapper;
import com.ejianc.business.trade.service.IPriceLibraryService;
import com.ejianc.business.trade.utils.DetailIndexExcelReader;
import com.ejianc.business.trade.utils.ImportVo;
import com.ejianc.business.trade.vo.PriceLibraryVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="priceLibraryService")
public class PriceLibraryServiceImpl
extends BaseServiceImpl<PriceLibraryMapper, PriceLibraryEntity>
implements IPriceLibraryService {
    @Autowired
    private PriceLibraryController controller;

    @Override
    public List<PriceLibraryVO> queryData(Page<PriceLibraryVO> page, QueryWrapper wrapper) {
        return ((PriceLibraryMapper)this.baseMapper).queryData(page, wrapper);
    }

    @Override
    public CommonResponse<JSONObject> excelImportInfo(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
        if (size == null || size != 1) {
            return CommonResponse.error((String)"\u6587\u4ef6\u9875\u7b7e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List<List<List<String>>> resList = DetailIndexExcelReader.readExcel(mf);
        List<List<String>> result0 = resList.get(0);
        if (result0.size() > 0 && result0.get(0).size() < 13) {
            return CommonResponse.error((String)"\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        ImportVo importVo0 = this.excelImportSub(result0);
        JSONObject json = new JSONObject();
        json.put("successList", (Object)importVo0.getSubList());
        json.put("errorList", (Object)importVo0.getErrorList());
        return CommonResponse.success((Object)json);
    }

    private ImportVo excelImportSub(List<List<String>> result) {
        ImportVo res = new ImportVo();
        if (result != null && result.size() > 0) {
            ArrayList<PriceLibraryVO> detailVoList = new ArrayList<PriceLibraryVO>();
            for (int i = 0; i < result.size(); ++i) {
                List<String> datas = result.get(i);
                PriceLibraryVO vo = new PriceLibraryVO();
                vo.setFlag(true);
                String materialCode = datas.get(0);
                String gfName = datas.get(1);
                vo.setGfName(gfName);
                String cplbName = datas.get(2);
                vo.setCplbName(cplbName);
                String pmName = datas.get(3);
                vo.setPmName(pmName);
                String ggName = datas.get(4);
                vo.setGgName(ggName);
                String czName = datas.get(5);
                vo.setCzName(czName);
                String insertDate = datas.get(6);
                String price = datas.get(7);
                String insertTime = datas.get(8);
                try {
                    Integer aLong = Integer.valueOf(insertTime);
                    vo.setInsertTime(aLong);
                }
                catch (Exception e) {
                    vo.setFlag(false);
                }
                String orgId = datas.get(9);
                try {
                    Long aLong = Long.valueOf(orgId);
                    vo.setOrgId(aLong);
                }
                catch (Exception e) {
                    vo.setFlag(false);
                }
                String orgName = datas.get(10);
                vo.setOrgName(orgName);
                String gfId = datas.get(11);
                try {
                    Long aLong = Long.valueOf(gfId);
                    vo.setGfId(aLong);
                }
                catch (Exception e) {
                    vo.setFlag(false);
                }
                String cplbId = datas.get(12);
                try {
                    Long aLong = Long.valueOf(cplbId);
                    vo.setCplbId(aLong);
                }
                catch (Exception e) {
                    vo.setFlag(false);
                }
                String pmId = datas.get(13);
                try {
                    Long aLong = Long.valueOf(pmId);
                    vo.setPmId(aLong);
                }
                catch (Exception e) {
                    vo.setFlag(false);
                }
                String ggId = datas.get(14);
                try {
                    Long aLong = Long.valueOf(ggId);
                    vo.setGgId(aLong);
                }
                catch (Exception e) {
                    vo.setFlag(false);
                }
                String czId = datas.get(15);
                try {
                    Long aLong = Long.valueOf(czId);
                    vo.setCzId(aLong);
                }
                catch (Exception e) {
                    vo.setFlag(false);
                }
                try {
                    vo.setPrice(new BigDecimal(price));
                }
                catch (Exception e) {
                    vo.setFlag(false);
                }
                SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
                Date date = null;
                try {
                    date = ft.parse(insertDate);
                    vo.setInsertDate(date);
                }
                catch (ParseException e) {
                    vo.setFlag(false);
                }
                detailVoList.add(vo);
            }
            ArrayList<PriceLibraryVO> successList = new ArrayList<PriceLibraryVO>();
            ArrayList<PriceLibraryVO> errorList = new ArrayList<PriceLibraryVO>();
            for (PriceLibraryVO vo : detailVoList) {
                if (vo.getFlag()) {
                    successList.add(vo);
                    this.controller.saveOrUpdate(vo);
                    continue;
                }
                errorList.add(vo);
            }
            res.setErrorList(errorList);
            res.setSubList(successList);
        }
        return res;
    }
}

