package com.ejianc.business.trade.service.impl;

import com.ejianc.business.trade.bean.CghtdjEntity;
import com.ejianc.business.trade.bean.CghtdjZiEntity;
import com.ejianc.business.trade.bean.CghtlyqkmxEntity;
import com.ejianc.business.trade.service.ICghtdjService;
import com.ejianc.business.trade.service.ICghtlyqkmxService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;

@Service("cghtdj") 
public class CghtdjBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private ICghtdjService service;

	@Autowired
	private ICghtlyqkmxService mxService;


	private Logger logger = LoggerFactory.getLogger(this.getClass());
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("采购合同登记审批流开始执行，单据id：{}",billId);
		CghtdjEntity entity = service.selectById(billId);
		if (entity != null){
			List<CghtdjZiEntity> cghtdjZiList = entity.getCghtdjZiList();
			for (CghtdjZiEntity ziEntity : cghtdjZiList){
				CghtlyqkmxEntity cghtlyqkmxEntity = BeanMapper.map(ziEntity, CghtlyqkmxEntity.class);
				cghtlyqkmxEntity.setBillCode(entity.getBillCode());
				cghtlyqkmxEntity.setOrgId(entity.getOrgId());
				cghtlyqkmxEntity.setOrgName(entity.getOrgName());
				cghtlyqkmxEntity.setHtCode(entity.getHtCode());
				cghtlyqkmxEntity.setHtName(entity.getHtName());
				cghtlyqkmxEntity.setGfId(entity.getGfId());
				cghtlyqkmxEntity.setGfName(entity.getGfName());
				cghtlyqkmxEntity.setLxr(entity.getLxr());
				cghtlyqkmxEntity.setCgplId(entity.getCgplId());
				cghtlyqkmxEntity.setCgplName(entity.getCgplName());
				cghtlyqkmxEntity.setTags("cghtdj");
				mxService.saveOrUpdate(cghtlyqkmxEntity);
			}
			logger.info("采购合同登记审批流执行结束，共插入明细表：{}条",cghtdjZiList.size());
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
