package com.ejianc.business.trade.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.trade.utils.DetailIndexExcelReader;
import com.ejianc.business.trade.utils.ImportVo;
import com.ejianc.business.trade.vo.ClwjxjglZiVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.trade.mapper.ClwjxjglMapper;
import com.ejianc.business.trade.bean.ClwjxjglEntity;
import com.ejianc.business.trade.service.IClwjxjglService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 材料网价询价管理
 * 
 * @author generator
 * 
 */
@Service("clwjxjglService")
public class ClwjxjglServiceImpl extends BaseServiceImpl<ClwjxjglMapper, ClwjxjglEntity> implements IClwjxjglService{


    @Autowired
    private IClwjxjglService service;
    @Autowired
    private IBillCodeApi billCodeApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public CommonResponse<JSONObject> excelImportInfo(HttpServletRequest request, HttpServletResponse response) {



        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();

        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        }else {
            Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
            if (size == null || size != 1) {
                return CommonResponse.error("文件页签不完整，请下载最新模板！");
            }
            List<List<List<String>>> resList = DetailIndexExcelReader.readExcel(mf);
            List<List<String>> result0 = resList.get(0);
            if(result0.size()>0&&result0.get(0).size()<13){
                return CommonResponse.error("数据不完整，请下载最新模板！");
            }
            ImportVo importVo0 = excelImportSub(result0);

            JSONObject json = new JSONObject();
            json.put("successList", importVo0.getSubList());
            json.put("errorList", importVo0.getErrorList());
            return CommonResponse.success(json);
        }


    }

    private ImportVo excelImportSub(List<List<String>> result){
        ImportVo res = new ImportVo();

        if (result != null && result.size() > 0) {
            List<ClwjxjglZiVO> detailVoList = new ArrayList<>();

            for (int i = 0; i < result.size(); i++) {
                List<String> datas = result.get(i);
                ClwjxjglZiVO vo = new ClwjxjglZiVO();
                vo.setFlag(true);

                String materialCode = datas.get(0);//物资编号
                vo.setMaterialCode(materialCode);
                String materialName = datas.get(1);//物资名称
                vo.setMaterialName(materialName);
                String spec = datas.get(2);//规格型号
                vo.setSpec(spec);
                String unit = datas.get(3);//计量单位
                vo.setUnit(unit);
                String price = datas.get(4);//单价
                String priceSourceName = datas.get(5);//价格来源名称
                String yxrq = datas.get(6);//询价日期
                String cjId = datas.get(7);//厂家id
                String cjName = datas.get(8);//厂家名称
                vo.setCjName(cjName);
                String cjJc = datas.get(9);//厂家简称
                vo.setCjJc(cjJc);


                try{
                    Long aLong = Long.valueOf(cjId);
                    vo.setCjId(aLong);
                } catch (Exception e) {
                    vo.setFlag(false);
                }

                try {
                    vo.setPrice(new BigDecimal(price));
                } catch (Exception e) {
                    vo.setFlag(false);
                }


                if (priceSourceName.equals("网价") ) {
                    vo.setPriceSourceId(1516365790259974146L);
                    vo.setPriceSourceName("网价");
                }
                else if (priceSourceName.equals("询价") ) {
                    vo.setPriceSourceId(1516365822166044673L);
                    vo.setPriceSourceName("询价");
                }

                SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
                Date date = null;
                try {
                    date = ft.parse(yxrq);
                    vo.setXjrq(date);
                } catch (ParseException e) {
                    vo.setFlag(false);
                }

                detailVoList.add(vo);

            }
            List<ClwjxjglZiVO> successList = new ArrayList<>();
            List<ClwjxjglZiVO> errorList = new ArrayList<>();

            for(ClwjxjglZiVO vo :detailVoList){
                if(vo.getFlag()){
                    successList.add(vo);
                }else{
                    errorList.add(vo);
                }
            }

            res.setErrorList(errorList);
            res.setSubList(successList);
        }
        return res;
    }

    public static void main(String[] args) {
        Date date = new Date();
        DateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String format = simpleDateFormat.format(date);
        Date parse = null;
        try {
            parse =  simpleDateFormat.parse(format);
        }catch (ParseException e){
            e.printStackTrace();
        }
    }
}
