package com.ejianc.business.tradematerial.finance.service.impl;


import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

@Service("paymentApply")
public class PaymentApplyBpmServiceImpl implements ICommonBusinessService {


	private final Logger logger = LoggerFactory.getLogger(this.getClass());
	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success("付款申请-提交前回调成功！");
	}

	/**
	 * 终审审核完回调
	 *
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success("付款申请终审回调成功！");
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}



	//撤回、弃审回调方法
	private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
		logger.info("付款申请单据billId-{}, state-{}, billTypeCode-{}撤回前校验", billId, state, billTypeCode);
		return CommonResponse.success("弃审/撤回前校验回调成功！");
	}

}
