package com.ejianc.business.tradematerial.check.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.financeintegration.PMPayApply.api.IPMZZCRKDApi;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMZZCRKDVO;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.tradematerial.check.bean.CheckDetailEntity;
import com.ejianc.business.tradematerial.check.bean.CheckEntity;
import com.ejianc.business.tradematerial.check.service.ICheckService;
import com.ejianc.business.tradematerial.check.vo.SupplierPushCheckDetailVO;
import com.ejianc.business.tradematerial.check.vo.SupplierPushCheckVO;
import com.ejianc.business.tradematerial.contract.bean.ContractDetailEntity;
import com.ejianc.business.tradematerial.contract.bean.ContractEntity;
import com.ejianc.business.tradematerial.contract.service.IContractDetailService;
import com.ejianc.business.tradematerial.contract.service.IContractService;
import com.ejianc.business.tradematerial.enums.BillPushStatusEnum;
import com.ejianc.business.store.api.IStoreManageApi;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.sign.api.ISignApi;
import com.ejianc.foundation.sign.vo.SignVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service("check")
public class CheckBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private ICheckService checkService;
	@Autowired
	private IAttachmentApi attachmentApi;
	private final String OPERATE = "XHC_CHECK_SYNC";
	@Autowired
	private IStoreManageApi storeManageApi;
	@Autowired
	private IProSupplierApi proSupplierApi;
	@Autowired
	private ICostDetailApi costDetailApi;
	@Autowired
	private IContractService contractService;
	@Autowired
	private IContractDetailService contractDetailService;
	@Autowired
	private IPMZZCRKDApi ipmzzcrkdApi;
	@Autowired
	private IShareCooperateApi shareCooperateApi;
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	private static final String BILL_TYPE = "BT220215000000006";//此处需要根据实际修改
	private final String PUSH_DELETE_URL = "/ejc-supbusiness-web/openapi/materialCheck/deleteCheck";
	private final String PUSH_SAVE_URL = "/ejc-supbusiness-web/openapi/materialCheck/saveCheck";
	@Value("${contract.generateBillCodeType:common}")
	private String GenerateBillCodeType;
	@Autowired
	private ISignApi signApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){


		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
		logger.info("审批节点审批中时节点审批后回调，sign：{}",sign);
		if("wuzizhuguan".equals(sign)){
			CheckEntity checkEntity = checkService.selectById(billId);
			if (checkEntity!= null){
				//获取当前操作人的默认签名
				logger.info("InvocationInfoProxy.getUserid()：{}", InvocationInfoProxy.getUserid());
				CommonResponse<List<SignVO>> listCommonResponse = signApi.queryByUserIdList(Arrays.asList(InvocationInfoProxy.getUserid()));
				logger.info("listCommonResponse：{}", JSONObject.toJSONString(listCommonResponse));
				if (listCommonResponse.getCode() == 0){
					for (SignVO datum : listCommonResponse.getData()) {
						if (datum.getDefaultFlag()){
							//签名信息图片地址赋值
							checkEntity.setUrlWz(datum.getFileUrl());
							logger.info("图片地址赋值成功，UrlWz：{}",datum.getFileUrl());
							checkService.saveOrUpdate(checkEntity);
						}
					}
				}

			}
		}
		return CommonResponse.success();
	}
	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		CheckEntity checkEntity = checkService.selectById(billId);
		ContractEntity contractEntity = null;
		if (checkEntity.getContractId() != null){
			contractEntity = contractService.selectById(checkEntity.getContractId());
		}
		checkEntity.setCheckState(1);
		checkService.updateById(checkEntity);



//		验收类型，proMaterial-1,大宗材
//		proMaterial-2,周转材
//		proMaterial-3,零星材料
//		proMaterial-4, 甲供材
		//入库方式，0-收料入库，1-直入直出
		if (checkEntity.getStoreType() == 0){
			//调用库存逻辑
			StoreManageVO storeManageVO = new StoreManageVO();
			if (checkEntity.getCheckType().equals("proMaterial-2")){
				storeManageVO.setInOutTypeEnum(InOutTypeEnum.周转材收料入库);
				storeManageVO.setStoreId(checkEntity.getProjectId());
			}
			if (!checkEntity.getCheckType().equals("proMaterial-2")){
				storeManageVO.setInOutTypeEnum(InOutTypeEnum.收料入库);
				storeManageVO.setStoreId(checkEntity.getStoreId());
			}
			storeManageVO.setOutEffectiveON(true);
			storeManageVO.setSourceId(checkEntity.getId());
			ArrayList<FlowVO> flowVOS = new ArrayList<>();
//			checkEntity.getCheckDetailList().forEach(t->{
//				FlowVO flowVO = new FlowVO();
//				if (checkEntity.getCheckType().equals("proMaterial-2")) {
//					flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.周转材收料入库, 0);
//				}
//				if (!checkEntity.getCheckType().equals("proMaterial-2")) {
//					flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.收料入库, 0);
//				}
//
//				getFlow(checkEntity, t, flowVO);
//				flowVOS.add(flowVO);
//			});
			for(int i=0;i<checkEntity.getCheckDetailList().size();i++){
				FlowVO flowVO = new FlowVO();
				if (checkEntity.getCheckType().equals("proMaterial-2")) {
					flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.周转材收料入库, 0);
				}
				if (!checkEntity.getCheckType().equals("proMaterial-2")) {
					flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.收料入库, 0);
				}

				getFlow(checkEntity, checkEntity.getCheckDetailList().get(i), flowVO,contractEntity);
				flowVOS.add(flowVO);
			}

			storeManageVO.setFlowVOList(flowVOS);
			String stringInfo = JSONObject.toJSONString(storeManageVO);
			logger.info("消耗材验收入库参数：" +stringInfo);
			CommonResponse<StoreManageVO> response = storeManageApi.inOutStore(storeManageVO);
			if(!response.isSuccess()) {
                logger.info("测试报错01");
				throw new BusinessException("调用库存管理失败,错误信息" +response.getMsg());
			}
		}
		//入库方式，0-收料入库，1-直入直出
		if (checkEntity.getStoreType() == 1){
			//调用库存逻辑
			StoreManageVO storeManageVO = new StoreManageVO();
			storeManageVO.setStoreId(checkEntity.getStoreId());
			storeManageVO.setInOutTypeEnum(InOutTypeEnum.直入直出入库);
			storeManageVO.setOutEffectiveON(true);
            storeManageVO.setSourceId(checkEntity.getId());
			ArrayList<FlowVO> flowVOS = new ArrayList<>();
//			checkEntity.getCheckDetailList().forEach(t->{
//				FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.直入直出入库, 0);
//				getFlow(checkEntity, t, flowVO);
//				flowVOS.add(flowVO);
//			});
			for(int i=0;i<checkEntity.getCheckDetailList().size();i++){
				FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.直入直出入库, 0);
				getFlow(checkEntity, checkEntity.getCheckDetailList().get(i), flowVO,contractEntity);
				flowVOS.add(flowVO);
			}
			storeManageVO.setFlowVOList(flowVOS);
			ArrayList<FlowVO> flowOutS = new ArrayList<>();
//			checkEntity.getCheckDetailList().forEach(t->{
//				FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.直入直出出库, 0);
//				getFlow(checkEntity, t, flowVO);
//				flowOutS.add(flowVO);
//			});

			for(int i=0;i<checkEntity.getCheckDetailList().size();i++){
				FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.直入直出出库, 0);
				getFlow(checkEntity, checkEntity.getCheckDetailList().get(i), flowVO,contractEntity);
				flowOutS.add(flowVO);
			}
			storeManageVO.setStraightOutFlowVOList(flowOutS);
			String stringInfo = JSONObject.toJSONString(storeManageVO);
			logger.info("消耗材直入直出参数：" +stringInfo);
			CommonResponse<StoreManageVO> response = storeManageApi.inOutStore(storeManageVO);
            logger.info("测试报错03"+response.getMsg());
			if(!response.isSuccess()) {
                logger.info("测试报错01");
				throw new BusinessException("调用库存管理失败,错误信息" +response.getMsg());
			}
		}
		//周转材 -推财务 --郑州一建业务
		if (checkEntity.getCheckType().equals("proMaterial-2") && "common".equals(GenerateBillCodeType)){
        	List<CheckDetailEntity> checkDetailEntity = checkEntity.getCheckDetailList();
        	if(CollectionUtils.isNotEmpty(checkDetailEntity)){
				SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        		List<PMZZCRKDVO> list = new ArrayList<>();
				checkDetailEntity.forEach(e->{
					PMZZCRKDVO vo = new PMZZCRKDVO();
					vo.setContractId(checkEntity.getContractId()==null?"":checkEntity.getContractId().toString());
					vo.setProjectId(checkEntity.getProjectId()==null?"":checkEntity.getProjectId().toString());
					vo.setCheckDate(sdf.format(checkEntity.getCheckDate()));
					vo.setMaterialId(e.getMaterialId()==null?"":e.getMaterialId().toString());
					vo.setMaterialName(e.getMaterialName());
					vo.setMaterialTypeName(e.getMaterialTypeName());
					vo.setSpec(e.getSpec());
					vo.setUnitName(e.getUnit());
					vo.setCheckNum(e.getCheckNum());
					vo.setCheckTaxMny(e.getCheckTaxMny());
					vo.setSourceId(e.getId().toString());
					vo.setCheckMny(e.getCheckMny());
					vo.setTaxMny(e.getTaxMny());
					list.add(vo);
				});
				logger.info("周转材调用财务参数：" + JSONObject.toJSONString(list));
				ipmzzcrkdApi.saveOrUpdate(list);
			}
		}
		return CommonResponse.success();
	}

	private void getFlow(CheckEntity checkEntity, CheckDetailEntity t, FlowVO flowVO, ContractEntity contractEntity) {
		flowVO.setProjectId(checkEntity.getProjectId());
		flowVO.setTaxRate(t.getTaxRate());
		flowVO.setProjectName(checkEntity.getProjectName());
		flowVO.setParentOrgId(checkEntity.getParentOrgId());
		flowVO.setParentOrgName(checkEntity.getParentOrgName());
		flowVO.setOrgId(checkEntity.getOrgId());
		flowVO.setOrgName(checkEntity.getOrgName());
		if ("proMaterial-2".equals(checkEntity.getCheckType())){
			flowVO.setStoreId(checkEntity.getProjectId());
			flowVO.setStoreName(checkEntity.getProjectName());
		}
		if (!"proMaterial-2".equals(checkEntity.getCheckType())){
			flowVO.setStoreId(checkEntity.getStoreId());
			flowVO.setStoreName(checkEntity.getStoreName());
		}
		flowVO.setEmployeeId(checkEntity.getEmployeeId());
		flowVO.setEmployeeName(checkEntity.getEmployeeName());
		flowVO.setMaterialType(checkEntity.getCheckType());
		flowVO.setMaterialTypeName(checkEntity.getCheckTypeName());
		flowVO.setSupplierId(checkEntity.getSupplierId());
		flowVO.setSupplierName(checkEntity.getSupplierName());
		flowVO.setPurchaseContractId(checkEntity.getContractId());
		flowVO.setPurchaseContractName(checkEntity.getContractName());
		flowVO.setMaterialCategoryId(t.getMaterialTypeId());
		flowVO.setMaterialCategoryName(t.getMaterialTypeName());
		flowVO.setMaterialId(t.getMaterialId());
		flowVO.setMaterialName(t.getMaterialName());
		flowVO.setMaterialCode(t.getMaterialCode());
		flowVO.setMaterialSpec(t.getSpec());
		flowVO.setMaterialUnitId(t.getUnitId());
		flowVO.setMaterialUnitName(t.getUnit());
		flowVO.setTaxPrice(t.getCheckTaxPrice());
		flowVO.setPrice(t.getCheckPrice());
		flowVO.setNum(t.getCheckNum());
		flowVO.setTaxMny(t.getCheckTaxMny());
		flowVO.setMny(t.getCheckMny());
		flowVO.setTax(t.getTaxMny());
		flowVO.setPickUnitId(checkEntity.getSubSupplierId());
		flowVO.setPickUnitName(checkEntity.getSubSupplierName());
		flowVO.setPickContractId(checkEntity.getSubContractId());
		flowVO.setPickContractName(checkEntity.getSubContractName());
		flowVO.setSourceId(checkEntity.getId());
		flowVO.setSourceDetailId(t.getId());
		flowVO.setSourceBillCode(checkEntity.getBillCode());
		flowVO.setSourceBillDate(checkEntity.getCheckDate());
		flowVO.setSourceBillRemark(checkEntity.getMemo());
		flowVO.setSourceBillDetailRemark(t.getMemo());
		flowVO.setSourceBillTypeName("材料验收");
		flowVO.setSourceBillTypeCode("BT220215000000006");
		flowVO.setSourceType(checkEntity.getSourceType());
		flowVO.setPickType(checkEntity.getSubOutType());
		flowVO.setLicensePlate(checkEntity.getLicensePlate());
		//1-内部领料,2-分包领料
		if (checkEntity.getSubOutType() != null && checkEntity.getSubOutType() == 1){
			flowVO.setPickTypeName("内部领料");
		}
		if (checkEntity.getSubOutType() != null && checkEntity.getSubOutType() == 2){
			flowVO.setPickTypeName("分包领料");
		}

		if (null!=checkEntity.getContractId()&&null!=contractEntity){
			List<ContractDetailEntity> contractDetailList = contractEntity.getContractDetailList();
			Map<Long, ContractDetailEntity> sourceIdMap = contractDetailList.stream().collect(Collectors.toMap(ContractDetailEntity::getId, Function.identity()));
			Map<Long, ContractDetailEntity> DetailMaterialIdMap = contractDetailList.stream().filter(e -> e.getMaterialId() != null).collect(Collectors.toMap(ContractDetailEntity::getMaterialId, Function.identity()));
			Map<Long, ContractDetailEntity> DetailMaterialIdTypeMap = contractDetailList.stream().filter(e -> e.getMaterialId() == null).collect(Collectors.toMap(ContractDetailEntity::getMaterialTypeId, Function.identity()));
			//处理子表数据返回
			//1 先根据sourceId取合同明细行对应的单价  取到--返回  否则  到第2步
			ContractDetailEntity contractDetailEntity = sourceIdMap.get(t.getSourceId());
            if(null!=contractDetailEntity){
				flowVO.setContractTaxPrice(contractDetailEntity.getDetailTaxPrice());
				flowVO.setContractPrice(contractDetailEntity.getPrice());
			}else{
            	//2  根据物料id取合同明细行对应的单价  取到--返回  否则  到第3步
				contractDetailEntity = DetailMaterialIdMap.get(t.getMaterialId());
				if(null!=contractDetailEntity){
					flowVO.setContractTaxPrice(contractDetailEntity.getDetailTaxPrice());
					flowVO.setContractPrice(contractDetailEntity.getPrice());
				}else{
					//3  根据材料分类Id 取合同明细行对应的单价  取到--返回  否则  单价设置为0
					contractDetailEntity = DetailMaterialIdTypeMap.get(t.getMaterialTypeId());
					if(null!=contractDetailEntity){
						flowVO.setContractTaxPrice(contractDetailEntity.getDetailTaxPrice());
						flowVO.setContractPrice(contractDetailEntity.getPrice());
					}else{
						flowVO.setContractTaxPrice(BigDecimal.ZERO);
						flowVO.setContractPrice(BigDecimal.ZERO);
					}
				}
			}
		}
		flowVO.setRowState(t.getRowState());
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//是否被其他单据引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
		if(!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能撤回！");
		}

		CheckEntity checkEntity = checkService.selectById(billId);
		if (checkEntity.getSignStatus() == 1){
			return CommonResponse.error("供方已签字,无法撤回");
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {


		CheckEntity checkEntity = checkService.selectById(billId);
		logger.info("弃审推送成本---");
		logger.info("删除成本中心之前的数据-验收单Id---{}",checkEntity.getId());
		CommonResponse<String> stringCommonResponse = costDetailApi.deleteSubject(checkEntity.getId());
		logger.info("结果"+ JSONObject.toJSONString(stringCommonResponse));
		if(!stringCommonResponse.isSuccess()){
			throw new BusinessException(stringCommonResponse.getMsg());
		}
		//更新是否关联
		LambdaUpdateWrapper<CheckEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.in(CheckEntity::getId, checkEntity.getId());
		updateWrapper.set(CheckEntity::getRelationFlag, "0");//(1:是，0：否)
		checkService.update(updateWrapper);

		if(BillPushStatusEnum.推送成功.getStatus().equals(checkEntity.getBillPushFlag())){
			//推送供方
			//对单据进行加锁
			CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
			if (!ejcCloudSystemCode.isSuccess()) {
				throw new BusinessException("获取当前系统编码失败！");
			}
			Map<String,Object> map = new HashMap<>();
			map.put("sourceId",billId);
			map.put("systemId",ejcCloudSystemCode.getData());
			String dataInfo = JSONObject.toJSONString(map);
			checkEntity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
			checkService.saveOrUpdate(checkEntity,false);
		}

		//入库方式，0-收料入库，1-直入直出
		if (checkEntity.getStoreType() == 0){
			List<Long> ids = new ArrayList<>();
			ids.add(billId);
			StoreManageVO storeManageVO = new StoreManageVO();
			storeManageVO.setSourceId(checkEntity.getId());
			if (checkEntity.getCheckType().equals("proMaterial-2")){
				storeManageVO.setInOutTypeEnum(InOutTypeEnum.周转材收料入库);
				storeManageVO.setStoreId(checkEntity.getProjectId());
			}
			if (!checkEntity.getCheckType().equals("proMaterial-2")){
				storeManageVO.setInOutTypeEnum(InOutTypeEnum.收料入库);
				storeManageVO.setStoreId(checkEntity.getStoreId());
			}


			storeManageVO.setOutEffectiveON(true);

			String stringInfo = JSONObject.toJSONString(storeManageVO);
			logger.info("消耗材撤回参数：" +stringInfo);
			CommonResponse<StoreManageVO> response = storeManageApi.inOutStoreRollback(storeManageVO);
			if(!response.isSuccess()) {
				return CommonResponse.error(response.getMsg());
//				throw new BusinessException();
			}else{
				logger.info("xhc推送仓库成功:"+response.getMsg());
			}

		}
		if (checkEntity.getStoreType() == 1){
			List<Long> ids = new ArrayList<>();
			ids.add(billId);
			StoreManageVO storeManageVO = new StoreManageVO();
			storeManageVO.setStoreId(checkEntity.getStoreId());
			storeManageVO.setSourceId(checkEntity.getId());
			storeManageVO.setSourceIdsForRollBack(ids);
			storeManageVO.setInOutTypeEnum(InOutTypeEnum.直入直出入库);
			storeManageVO.setOutEffectiveON(true);
			String stringInfo = JSONObject.toJSONString(storeManageVO);
			logger.info("消耗材撤回参数：" +stringInfo);
			CommonResponse<StoreManageVO> response = storeManageApi.inOutStoreRollback(storeManageVO);
			if(!response.isSuccess()) {
				return CommonResponse.error(response.getMsg());
//				throw new BusinessException(response.getMsg());
			}else{
				logger.info("xhc推送仓库成功:"+response.getMsg());
			}

		}

		//周转材 -推财务
		if (checkEntity.getCheckType().equals("proMaterial-2") && "common".equals(GenerateBillCodeType)){
			List<CheckDetailEntity> checkDetailEntity = checkEntity.getCheckDetailList();
			if(CollectionUtils.isNotEmpty(checkDetailEntity)){
				List<String> list = new ArrayList<>();
				checkDetailEntity.forEach(e->{
					list.add(e.getId().toString());
				});
				logger.info("弃审周转材调用财务参数：" + JSONObject.toJSONString(list));
				ipmzzcrkdApi.delete(list);
			}
		}
		return CommonResponse.success();
	}

}
