package com.ejianc.business.tradematerial.finance.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.tradematerial.finance.bean.PaymentRegisterEntity;
import com.ejianc.business.tradematerial.finance.vo.PaymentRegisterVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 付款登记主实体
 * 
 * @author generator
 * 
 */
public interface IPaymentRegisterService extends IBaseService<PaymentRegisterEntity> {

    List<PaymentRegisterEntity> queryPaymentRegisterByContractId(Long contractId);

    Map<String, BigDecimal> queryAlreadyPayMny(Long contractId);

    CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response);

    String saveImportExcel(HttpServletRequest request, List<PaymentRegisterVO> importVOS);

    BigDecimal getTotalPaidMny(QueryParam param);
    void writeBack(PaymentRegisterEntity entity, boolean check);
    void  checkStatus(PaymentRegisterVO entity);
    void  updateStatus(PaymentRegisterEntity entity, int flag);

    /**
     * 按月份查询实付金额
     *
     * @param queryParam
     * @return
     */
    Map<String, BigDecimal> queryActualPayGroupByMonth(QueryParam queryParam);

    BigDecimal getAcutalPayAndRegisterDiffMny(Long projectId, Long supplyId, Long payeeId, Long contractId);

    Map<String, BigDecimal> queryActualPayGroupByContractCategoryType(QueryParam queryParam);
}
