package com.ejianc.business.tradematerial.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tradematerial.finance.bean.RegisterDetailEntity;
import com.ejianc.business.tradematerial.finance.mapper.RegisterDetailMapper;
import com.ejianc.business.tradematerial.finance.service.IRegisterDetailService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

/**
 * 付款管理 详情表
 * 
 * @author generator
 * 
 */
@Service("registerDetailService")
public class RegisterDetailServiceImpl extends BaseServiceImpl<RegisterDetailMapper, RegisterDetailEntity> implements IRegisterDetailService {




    @Override
    public void updateBillState(Long planId, Integer billStateCode) {
        LambdaUpdateWrapper<RegisterDetailEntity> updateWrapper = Wrappers.lambdaUpdate();
        updateWrapper.eq(RegisterDetailEntity::getRegisterId, planId);
        updateWrapper.set(RegisterDetailEntity::getBillState, billStateCode);
        super.update(updateWrapper);
    }
}
