/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tradematerial.contract.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractPropertyEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.prosub.vo.ContractPaymentResultVO;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import com.ejianc.business.targetcost.api.IDutyApi;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.tender.common.vo.SignContractVo;
import com.ejianc.business.tradematerial.contract.bean.ContractDetailEntity;
import com.ejianc.business.tradematerial.contract.bean.ContractEntity;
import com.ejianc.business.tradematerial.contract.enums.BillTypeEnum;
import com.ejianc.business.tradematerial.contract.enums.ChangeStatusEnum;
import com.ejianc.business.tradematerial.contract.enums.ChangeTypeEnum;
import com.ejianc.business.tradematerial.contract.enums.DraftTypeEnum;
import com.ejianc.business.tradematerial.contract.enums.MaterialContractTypeEnum;
import com.ejianc.business.tradematerial.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.tradematerial.contract.enums.PurchaseTypeEnum;
import com.ejianc.business.tradematerial.contract.enums.SignatureStatusEnum;
import com.ejianc.business.tradematerial.contract.mapper.ContractMapper;
import com.ejianc.business.tradematerial.contract.service.IContractAsyncService;
import com.ejianc.business.tradematerial.contract.service.IContractChangeService;
import com.ejianc.business.tradematerial.contract.service.IContractDetailService;
import com.ejianc.business.tradematerial.contract.service.IContractFreezeService;
import com.ejianc.business.tradematerial.contract.service.IContractRelieveService;
import com.ejianc.business.tradematerial.contract.service.IContractService;
import com.ejianc.business.tradematerial.contract.vo.ContractDetailVO;
import com.ejianc.business.tradematerial.contract.vo.ContractMaterialReportVO;
import com.ejianc.business.tradematerial.contract.vo.ContractVO;
import com.ejianc.business.tradematerial.contract.vo.MaterialMnyVO;
import com.ejianc.business.tradematerial.contract.vo.MaterialReportVO;
import com.ejianc.business.tradematerial.utils.CommonUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service(value="contractService")
public class ContractServiceImpl
extends BaseServiceImpl<ContractMapper, ContractEntity>
implements IContractService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PURCHASE_CONTRACT_BILL_CODE = "CONTRACT_MATERIAL";
    private static final String PURCHASE_CONTRACT_CONCRETE_BILL_CODE = "CONTRACT_CONCRETE";
    private static final String PURCHASE_CONTRACT_YNJT = "CONTRACT_MATERIAL_YNJT";
    private static final String WATERMARK_CHECK_PARAM_NAME = "P-00a9W886";
    @Autowired
    private IContractChangeService contractChangeService;
    @Autowired
    private IContractDetailService contractDetailService;
    @Autowired
    private IContractService service;
    @Autowired
    private IContractRelieveService relieveService;
    @Autowired
    private IContractFreezeService freezeService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IDutyApi iDutyApi;
    @Autowired
    private IContractAsyncService contractAsyncService;
    @Autowired
    ISignatureCommonApi signatureCommonApi;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Value(value="${contract.generateBillCodeType:common}")
    private String GenerateBillCodeType;
    private final String MAIN_CONTRACT_REFCODE = "contractMaterial";
    private static final String CHECK_PARAM_CODE = "P-434f5499";
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String M_SUP_CODE = "P-CO2iY888";
    private static final String C_SUP_CODE = "P-K496W490";
    private static final String M_PLAN_CODE = "P-CcZ6rO87";
    private static final String C_PLAN_CODE = "P-00g5A089";
    private static final String CONTRACT_FILING_CODE = "P-eg7rBO0134";
    private static final String UPDATE_CON_SIGN_DATE_PARAM_NAME = "P-U9uddl0182";

    @Override
    public CommonResponse<ContractVO> saveOrUpdate(ContractVO contractVo, String authority, Boolean isControl) {
        ContractEntity contract;
        QueryParam queryParam;
        LambdaQueryWrapper lambda;
        Object orgResponse;
        Long tenantId = InvocationInfoProxy.getTenantid();
        List entities = null;
        List entitiesc = null;
        if (contractVo.getOrgId() != null && (StringUtils.isEmpty((CharSequence)contractVo.getOrgCode()) || StringUtils.isEmpty((CharSequence)contractVo.getParentOrgCode()) || StringUtils.isEmpty((CharSequence)contractVo.getOrgName())) && (orgResponse = this.iOrgApi.getOneById(contractVo.getOrgId())).isSuccess()) {
            OrgVO orgVO = (OrgVO)orgResponse.getData();
            contractVo.setOrgCode(orgVO.getCode());
            if (StringUtils.isEmpty((CharSequence)contractVo.getOrgName())) {
                contractVo.setOrgName(orgVO.getName());
            }
            if (5 == orgVO.getOrgType()) {
                CommonResponse parentOrgResponse = this.iOrgApi.getOneById(orgVO.getParentId());
                if (parentOrgResponse.isSuccess()) {
                    OrgVO parentOrgVO = (OrgVO)parentOrgResponse.getData();
                    contractVo.setParentOrgId(parentOrgVO.getId());
                    contractVo.setParentOrgCode(parentOrgVO.getCode());
                    contractVo.setParentOrgName(parentOrgVO.getName());
                }
            } else {
                contractVo.setParentOrgId(contractVo.getOrgId());
                contractVo.setParentOrgCode(contractVo.getOrgCode());
                contractVo.setParentOrgName(contractVo.getOrgName());
            }
        }
        if (contractVo.getTargetResultId() != null && CollectionUtils.isNotEmpty((Collection)contractVo.getContractDetailList())) {
            for (ContractDetailVO detailVO : contractVo.getContractDetailList()) {
                detailVO.setInitNum(detailVO.getNum());
            }
        }
        ContractEntity entity = (ContractEntity)((Object)BeanMapper.map((Object)contractVo, ContractEntity.class));
        if (!isControl.booleanValue() && StringUtils.isEmpty((CharSequence)contractVo.getBillCode())) {
            entity.setBillCode(this.getContractBillCode(contractVo));
        }
        if (entity.getId() == null) {
            if (entity.getFilingStatus() == null) {
                entity.setFilingStatus(FilingStatusEnum.\u672a\u5f52\u6863.getTypeCode());
            }
            entity.setFilingRef(0);
        }
        if (contractVo.getId() != null && contractVo.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(ContractEntity::getBillCode, (Object)contractVo.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)contractVo.getId());
            entities = super.list((Wrapper)lambda);
            queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)contractVo.getBillCode()));
            queryParam.getParams().put("contract_id", new Parameter("ne", (Object)contractVo.getId()));
            entitiesc = this.contractChangeService.queryList(queryParam, false);
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(ContractEntity::getBillCode, (Object)contractVo.getBillCode());
            entities = super.list((Wrapper)lambda);
            queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)contractVo.getBillCode()));
            entitiesc = this.contractChangeService.queryList(queryParam, false);
            entity.setId(IdWorker.getId());
            entity.setChangeVersion(0);
            entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
            entity.setMainContractCreateDate(new Date());
        }
        if (entities != null && entities.size() > 0 || entitiesc != null && entitiesc.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        if (contractVo.getMaterialId() != null) {
            QueryParam queryParam2 = new QueryParam();
            queryParam2.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam2.getParams().put("material_id", new Parameter("eq", (Object)contractVo.getMaterialId()));
            queryParam2.getParams().put("id", new Parameter("ne", (Object)contractVo.getId()));
            List contractEntities = this.service.queryList(queryParam2, false);
            if (contractEntities != null && contractEntities.size() > 0) {
                throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        entity.setBaseMoney(contractVo.getContractMny() == null ? BigDecimal.ZERO : contractVo.getContractMny());
        entity.setBaseMoneyWithTax(contractVo.getContractTaxMny() == null ? BigDecimal.ZERO : contractVo.getContractTaxMny());
        entity.setBeforeChangeMny(contractVo.getContractMny() == null ? BigDecimal.ZERO : contractVo.getContractMny());
        entity.setBeforeChangeMnyWithTax(contractVo.getContractTaxMny() == null ? BigDecimal.ZERO : contractVo.getContractTaxMny());
        if (!(entity.getContractFileId() == null || (contract = (ContractEntity)((Object)this.service.getById(entity.getId()))) == null || contract.getContractCategoryId().equals(entity.getContractCategoryId()) && (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(contract.getDraftType()) || DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().toString().equals(contract.getDraftType())) || !DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(entity.getDraftType()) && !DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().toString().equals(entity.getDraftType()))) {
            if (Boolean.FALSE.equals(isControl) && null != contract.getContractFileId()) {
                this.delContractFile(contract.getContractFileId(), authority);
            }
            entity.setContractFileId(null);
            entity.setContractFilePath(null);
        }
        if (!isControl.booleanValue()) {
            boolean saveFlag = super.saveOrUpdate((Object)entity, false);
            if (!saveFlag) {
                throw new BusinessException("\u5408\u540c\u4fdd\u5b58\u5931\u8d25\uff01");
            }
            if (contractVo.getId() == null && contractVo.getTargetResultId() != null) {
                this.updateTargetResult(contractVo, 0);
            }
            if (contractVo.getId() != null && contractVo.getTargetResultId() != null) {
                ContractEntity contractEntity = (ContractEntity)((Object)super.selectById((Serializable)contractVo.getId()));
                this.updateTargetResult((ContractVO)BeanMapper.map((Object)((Object)contractEntity), ContractVO.class), 1);
                this.updateTargetResult(contractVo, 0);
            }
            if (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(entity.getDraftType()) || DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().toString().equals(entity.getDraftType())) {
                entity.setContractFileSyncFlag(false);
            }
        }
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), ContractVO.class));
    }

    private String getContractBillCode(ContractVO contractVo) {
        String contractBillCode;
        this.logger.info("\u751f\u6210\u7f16\u7801\u89c4\u5219\uff0cGenerateBillCodeType=\uff1a{}", (Object)this.GenerateBillCodeType);
        switch (this.GenerateBillCodeType) {
            case "common": {
                BillCodeParam billCodeParam;
                CommonResponse billCode;
                String billCodeStr = PURCHASE_CONTRACT_BILL_CODE;
                if (MaterialContractTypeEnum.\u6df7\u51dd\u571f.getCode().equals(contractVo.getContractType())) {
                    billCodeStr = PURCHASE_CONTRACT_CONCRETE_BILL_CODE;
                }
                if ((billCode = this.billCodeApi.generateBillCode(billCodeParam = BillCodeParam.build((String)billCodeStr, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)contractVo))).isSuccess()) {
                    contractBillCode = (String)billCode.getData();
                    break;
                }
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            default: {
                throw new BusinessException("\u7f16\u7801\u751f\u6210\u5931\u8d25\uff01");
            }
        }
        this.logger.info("\u751f\u6210de\u7f16\u7801\uff0ccontractBillCode=\uff1a{}", (Object)contractBillCode);
        return contractBillCode;
    }

    @Override
    public ContractVO saveOrUpdateSupplement(ContractVO contractVo, String authority, Boolean isControl) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        ContractEntity entity = (ContractEntity)((Object)BeanMapper.map((Object)contractVo, ContractEntity.class));
        List entities = null;
        List entitiesc = null;
        ContractEntity mainContract = (ContractEntity)((Object)this.service.selectById(contractVo.getMainContractId()));
        if (null == mainContract) {
            throw new BusinessException("\u672a\u627e\u5230\u4e3b\u5408\u540c\uff0c\u4e0d\u80fd\u521b\u5efa\u8865\u5145\u534f\u8bae\uff01");
        }
        if (!isControl.booleanValue() && StringUtils.isEmpty((CharSequence)contractVo.getBillCode())) {
            QueryParam billCodeParam = new QueryParam();
            billCodeParam.getParams().put("main_contract_id", new Parameter("eq", (Object)contractVo.getMainContractId()));
            ArrayList<Integer> billStateList = new ArrayList<Integer>();
            billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
            billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
            billCodeParam.getParams().put("bill_state", new Parameter("in", billStateList));
            List billCOdeSupplementList = this.service.queryList(billCodeParam, false);
            String supplementNum = "";
            supplementNum = billCOdeSupplementList.size() < 9 ? supplementNum + "0" + (billCOdeSupplementList.size() + 1) : supplementNum + (billCOdeSupplementList.size() + 1);
            entity.setBillCode(mainContract.getBillCode() + "-2-" + supplementNum);
        }
        if (contractVo.getId() != null && contractVo.getId() > 0L) {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(ContractEntity::getBillCode, (Object)contractVo.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)contractVo.getId());
            entities = super.list((Wrapper)lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)contractVo.getBillCode()));
            queryParam.getParams().put("contract_id", new Parameter("ne", (Object)contractVo.getId()));
            entitiesc = this.contractChangeService.queryList(queryParam, false);
        } else {
            QueryParam param = new QueryParam();
            param.getParams().put("main_contract_id", new Parameter("eq", (Object)contractVo.getMainContractId()));
            List supplementList = super.queryList(param, false);
            supplementList.stream().forEach(e -> {
                if (!e.getSignatureStatus().equals(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()) || !e.getBillState().equals(BillStateEnum.COMMITED_STATE.getBillStateCode()) && !e.getBillState().equals(BillStateEnum.PASSED_STATE.getBillStateCode())) {
                    throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae!");
                }
            });
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(ContractEntity::getBillCode, (Object)contractVo.getBillCode());
            entities = super.list((Wrapper)lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)contractVo.getBillCode()));
            entitiesc = this.contractChangeService.queryList(queryParam, false);
            entity.setChangeVersion(0);
            entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
        }
        if (entities != null && entities.size() > 0 || entitiesc != null && entitiesc.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        this.checkContract(contractVo.getMainContractId(), contractVo.getId());
        entity.setBaseMoney(contractVo.getContractMny() == null ? BigDecimal.ZERO : contractVo.getContractMny());
        entity.setBaseMoneyWithTax(contractVo.getContractTaxMny() == null ? BigDecimal.ZERO : contractVo.getContractTaxMny());
        entity.setBeforeChangeMny(contractVo.getContractMny() == null ? BigDecimal.ZERO : contractVo.getContractMny());
        entity.setBeforeChangeMnyWithTax(contractVo.getContractTaxMny() == null ? BigDecimal.ZERO : contractVo.getContractTaxMny());
        if (FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode().equals(entity.getFilingStatus())) {
            entity.setFilingRef(0);
        }
        if (entity.getContractFileId() != null) {
            if (entity.getId() != null) {
                ContractEntity contract = (ContractEntity)((Object)super.getById((Serializable)entity.getId()));
                if (contract != null && !DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(contract.getDraftType()) && DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(entity.getDraftType())) {
                    if (!isControl.booleanValue()) {
                        this.delContractFile(entity.getContractFileId(), authority);
                    }
                    entity.setContractFileId(null);
                    entity.setContractFilePath(null);
                }
            } else if (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(entity.getDraftType())) {
                if (!isControl.booleanValue()) {
                    this.delContractFile(entity.getContractFileId(), authority);
                }
                entity.setContractFileId(null);
                entity.setContractFilePath(null);
            }
        }
        if (!isControl.booleanValue()) {
            super.saveOrUpdate((Object)entity, false);
            if (entity.getPurchaseType().equals("1")) {
                String linkUrl = entity.getContractType() == 0 ? this.BaseHost + "ejc-promaterial-frontend/#/supplement/card?id=" + entity.getId() : this.BaseHost + "ejc-promaterial-frontend/#/supplementConcrete/card?id=" + entity.getId();
                ExecutionVO executionVO = this.service.targetCost((ContractVO)BeanMapper.map((Object)((Object)entity), ContractVO.class), linkUrl, 0, entity.getContractType());
                this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
                CommonResponse response = this.executionApi.aggPush(executionVO);
                if (!response.isSuccess()) {
                    throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
                }
            }
        }
        return (ContractVO)BeanMapper.map((Object)((Object)entity), ContractVO.class);
    }

    @Override
    public ContractVO addConvertByConId(Long contractId) {
        ContractEntity contractVO = (ContractEntity)((Object)super.selectById((Serializable)contractId));
        ContractVO supplementVO = new ContractVO();
        supplementVO.setPurchaseType(contractVO.getPurchaseType());
        supplementVO.setPurchaseTypeName(contractVO.getPurchaseTypeName());
        supplementVO.setSignPlace(contractVO.getSignPlace());
        supplementVO.setCustomerEmployeeId(contractVO.getCustomerEmployeeId());
        supplementVO.setCustomerEmployeeName(contractVO.getCustomerEmployeeName());
        supplementVO.setCustomerEmployeeMobile(contractVO.getCustomerEmployeeMobile());
        supplementVO.setSupplierEmployeeName(contractVO.getSupplierEmployeeName());
        supplementVO.setSupplierEmployeeMobile(contractVO.getSupplierEmployeeMobile());
        supplementVO.setPricingType(contractVO.getPricingType());
        supplementVO.setMainContractName(contractVO.getContractName());
        supplementVO.setMainContractCode(contractVO.getBillCode());
        supplementVO.setMainContractId(contractId);
        supplementVO.setContractCategoryId(contractVO.getContractCategoryId());
        supplementVO.setContractCategoryName(contractVO.getContractCategoryName());
        supplementVO.setProjectName(contractVO.getProjectName());
        supplementVO.setProjectId(contractVO.getProjectId());
        supplementVO.setProjectPlace(contractVO.getProjectPlace());
        supplementVO.setCustomerId(contractVO.getCustomerId());
        supplementVO.setCustomerName(contractVO.getCustomerName());
        supplementVO.setSupplierId(contractVO.getSupplierId());
        supplementVO.setSupplierName(contractVO.getSupplierName());
        supplementVO.setOrgId(contractVO.getOrgId());
        supplementVO.setOrgName(contractVO.getOrgName());
        supplementVO.setParentOrgId(contractVO.getParentOrgId());
        supplementVO.setParentOrgName(contractVO.getParentOrgName());
        supplementVO.setParentOrgCode(contractVO.getParentOrgCode());
        supplementVO.setSignDate(new Date());
        supplementVO.setSupplementFlag(Integer.valueOf(1));
        supplementVO.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode().toString());
        supplementVO.setPerformanceStatus(PerformanceStatusEnum.\u672a\u7b7e\u8ba2.getCode().toString());
        supplementVO.setDraftType(DraftTypeEnum.\u4e0a\u4f20\u5408\u540c.getCode().toString());
        supplementVO.setContractName(contractVO.getContractName() + "\u8865\u5145\u534f\u8bae");
        supplementVO.setEmployeeId(this.sessionManager.getUserContext().getEmployeeId());
        supplementVO.setEmployeeName(this.sessionManager.getUserContext().getEmployeeName());
        supplementVO.setMainContractCreateDate(contractVO.getMainContractCreateDate());
        supplementVO.setContractType(contractVO.getContractType());
        supplementVO.setContractPropertyCode(contractVO.getContractPropertyCode());
        supplementVO.setContractPropertyName(contractVO.getContractPropertyName());
        supplementVO.setFilingStatus(FilingStatusEnum.\u672a\u5f52\u6863.getTypeCode());
        return supplementVO;
    }

    @Override
    public ContractVO queryDetail(Long id) {
        ContractEntity entity = (ContractEntity)((Object)super.selectById((Serializable)id));
        entity.setContractDetailList(null);
        ContractVO contractVo = (ContractVO)BeanMapper.map((Object)((Object)entity), ContractVO.class);
        List details = null;
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(ContractDetailEntity::getContractId, (Object)id);
        lambda.ne(ContractDetailEntity::getChangeType, (Object)ChangeTypeEnum.\u4e2d\u6b62\u9879);
        details = this.contractDetailService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)details)) {
            contractVo.setContractDetailList(BeanMapper.mapList((Iterable)details, ContractDetailVO.class));
        }
        return contractVo;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        HashMap<String, Object> resp = new HashMap();
        QueryWrapper wrapper = ContractServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        wrapper.select(new String[]{"sum(base_money_with_tax) as baseTaxMoney, sum(contract_tax_mny) as contractTaxMny"});
        resp = super.getMap((Wrapper)wrapper);
        return resp;
    }

    @Override
    public ContractVO querySupplementRecord(Long id) {
        ContractEntity contractEntity = (ContractEntity)((Object)super.selectById((Serializable)id));
        ContractVO recordVO = new ContractVO();
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        recordVO.setId(id);
        recordVO.setContractTaxMny(contractTaxMny);
        recordVO.setChangeStatus(contractEntity.getChangeStatus());
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"main_contract_id", (Object)id);
        query.eq((Object)"signature_status", (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
        query.orderByDesc((Object)"create_time");
        List supplementEntities = super.list((Wrapper)query);
        recordVO.setSupplementList(BeanMapper.mapList((Iterable)supplementEntities, ContractVO.class));
        recordVO.setSupplementNum(Integer.valueOf(supplementEntities.size()));
        BigDecimal allSupplementAmt = BigDecimal.ZERO;
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)supplementEntities)) {
            allSupplementAmt = supplementEntities.stream().map(e -> e.getContractTaxMny() == null ? BigDecimal.ZERO : e.getContractTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        recordVO.setAllSupplementAmt(allSupplementAmt);
        recordVO.setSupplementAmtRate(BigDecimal.ZERO.compareTo(contractTaxMny) != 0 ? allSupplementAmt.divide(contractTaxMny, 8, 4).multiply(new BigDecimal(100)) : BigDecimal.ZERO);
        if (SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().equals(contractEntity.getSignatureStatus()) && (BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractEntity.getBillState()))) {
            recordVO.setEditFlag(this.addSupplementFlag(id));
        }
        return recordVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean changeSignStatus(Long billId, int status, String refCode) {
        this.logger.info("\u8fdb\u5165\u4e3b\u5408\u540c\u7b7e\u7ae0\u72b6\u6001\u4fee\u6539\u65b9\u6cd5\uff0c\u4fee\u6539\u53c2\u6570\uff1abillId:{},status:{},refCode:{}", new Object[]{billId, status, refCode});
        ContractEntity contract = (ContractEntity)((Object)super.selectById((Serializable)billId));
        if (contract != null) {
            if (status == Integer.valueOf(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode())) {
                contract.setSignatureStatus(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
                contract.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
                contract.setFilingStatus(FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode());
                contract.setFilingRef(0);
                contract.setEffectiveDate(new Date());
                CommonResponse response = this.paramConfigApi.getByCode(UPDATE_CON_SIGN_DATE_PARAM_NAME);
                if (!response.isSuccess()) {
                    this.logger.error("\u67e5\u8be2\u7535\u4e2d\u7b7e\u7ae0\u5408\u540c-\u3010id-{}\u3011\u662f\u5426\u66f4\u65b0\u5408\u540c\u7b7e\u8ba2\u65e5\u671f\u53c2\u6570\u5931\u8d25\uff0c\u6682\u4e0d\u66f4\u65b0\u5408\u540c\u7b7e\u8ba2\u65e5\u671f: {}", (Object)billId, (Object)JSONObject.toJSONString((Object)response));
                }
                if (null != response.getData() && "1".equals(((ParamRegisterSetVO)response.getData()).getValueData())) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    this.logger.info("\u5408\u540c\u3010id-{}\uff0c\u539f\u7b7e\u8ba2\u65e5\u671f\uff1a{}, \u6839\u636e\u7535\u5b50\u7b7e\u7ae0\u5408\u540c\u66f4\u65b0\u5408\u540c\u7b7e\u8ba2\u65e5\u671f\u53c2\u6570:{}\uff0c\u5c06\u5408\u540c\u7b7e\u8ba2\u65e5\u671f\u6539\u4e3a\u5f53\u524d\u7b7e\u7ae0\u5b8c\u6210\u65e5\u671f:{}\u3011", new Object[]{billId, sdf.format(contract.getSignDate()), JSONObject.toJSONString((Object)response.getData()), sdf.format(new Date())});
                    contract.setSignDate(new Date());
                }
            } else {
                contract.setSignatureStatus(String.valueOf(status));
            }
        } else {
            return false;
        }
        super.saveOrUpdate((Object)contract, false);
        this.pushContract((ContractVO)BeanMapper.map((Object)((Object)contract), ContractVO.class));
        this.logger.info("\u4e3b\u5408\u540c\u7b7e\u7ae0\u72b6\u6001\u5df2\u4fee\u6539\uff0c\u4fee\u6539\u540e\u7b7e\u7ae0\u72b6\u6001:{}---------------->", (Object)contract.getSignatureStatus());
        return true;
    }

    @Override
    public Boolean addSupplementFlag(Long id) {
        ContractEntity contractEntity = (ContractEntity)((Object)super.selectById((Serializable)id));
        if (!PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode().equals(contractEntity.getPerformanceStatus())) {
            return false;
        }
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(ContractEntity::getMainContractId, (Object)id);
        lambda.eq(ContractEntity::getSupplementFlag, (Object)1);
        lambda.and(l -> (LambdaQueryWrapper)((LambdaQueryWrapper)l.ne(ContractEntity::getSignatureStatus, (Object)String.valueOf(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()))).or(c -> (LambdaQueryWrapper)c.notIn(ContractEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()})));
        List supplementList = super.list((Wrapper)lambda);
        return supplementList.size() == 0;
    }

    @Override
    public ExecutionVO targetCost(ContractVO contractVO, String linkUrl, Integer type, Integer contractType) {
        List contractDetailList;
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        ArrayList<DetailExecutionVO> detailList = new ArrayList<DetailExecutionVO>();
        totalVO.setSourceId(contractVO.getId());
        totalVO.setTenantId(contractVO.getTenantId());
        totalVO.setBillCode(contractVO.getBillCode());
        if (contractType == 0) {
            if (type == 0) {
                contractDetailList = contractVO.getContractDetailList();
                totalVO.setBillType(BillTypeEnum.\u6d88\u8017\u6750\u5408\u540c.getCode());
            } else {
                contractDetailList = contractVO.getContractDetailList();
                totalVO.setLastSourceId(contractVO.getMainContractId());
                totalVO.setBillType(BillTypeEnum.\u6d88\u8017\u6750\u5408\u540c\u53d8\u66f4.getCode());
            }
        } else if (type == 0) {
            contractDetailList = contractVO.getContractDetailList();
            totalVO.setBillType(BillTypeEnum.\u6df7\u51dd\u571f\u5408\u540c.getCode());
        } else {
            contractDetailList = contractVO.getContractDetailList();
            totalVO.setLastSourceId(contractVO.getMainContractId());
            totalVO.setBillType(BillTypeEnum.\u6df7\u51dd\u571f\u53d8\u66f4\u5408\u540c.getCode());
        }
        switch (contractVO.getContractPropertyCode()) {
            case "proMaterial-1": {
                totalVO.setBussinessType(BussinessTypeEnum.\u5927\u5b97\u6750\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getCode());
                break;
            }
            case "proMaterial-2": {
                totalVO.setBussinessType(BussinessTypeEnum.\u5468\u8f6c\u6750\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getCode());
                break;
            }
            case "proMaterial-3": {
                totalVO.setBussinessType(BussinessTypeEnum.\u96f6\u661f\u6750\u6599\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getCode());
                break;
            }
            case "contractConcrete-1": {
                totalVO.setBussinessType(BussinessTypeEnum.\u6df7\u51dd\u571f\u91c7\u8d2d\u5408\u540c.getCode());
            }
        }
        totalVO.setBillCategory(BillCategoryEnum.\u5408\u540c.getCode());
        totalVO.setProjectId(contractVO.getProjectId());
        totalVO.setOrgId(contractVO.getOrgId());
        totalVO.setMoney(contractVO.getContractMny());
        totalVO.setTaxMoney(contractVO.getContractTaxMny());
        totalVO.setLinkUrl(linkUrl);
        if (contractDetailList != null) {
            for (ContractDetailVO planDetailVO : contractVO.getContractDetailList()) {
                if ("del".equals(planDetailVO.getRowState())) continue;
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(Long.valueOf(planDetailVO.getId() == null ? IdWorker.getId() : planDetailVO.getId()));
                detailExecutionVO.setSourceBillId(contractVO.getId());
                detailExecutionVO.setCategoryId(planDetailVO.getMaterialTypeId());
                detailExecutionVO.setCategoryName(planDetailVO.getMaterialTypeName());
                if (planDetailVO.getMaterialId() == null) {
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(true));
                    detailExecutionVO.setDocId(planDetailVO.getMaterialTypeId());
                } else {
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                    detailExecutionVO.setDocId(planDetailVO.getMaterialId());
                }
                detailExecutionVO.setCode(planDetailVO.getMaterialCode());
                detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                MaterialCategoryVO categoryVO = (MaterialCategoryVO)this.materialApi.queryCategoryById(planDetailVO.getMaterialTypeId()).getData();
                if (categoryVO == null) {
                    detailExecutionVO.setCategoryInnerCode(null);
                    detailExecutionVO.setCategoryCode(null);
                } else {
                    detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                    detailExecutionVO.setCategoryCode(categoryVO.getCode());
                }
                detailExecutionVO.setDocType(DocTypeEnum.\u7269\u6599\u6863\u6848.getCode());
                detailExecutionVO.setName(planDetailVO.getMaterialName());
                detailExecutionVO.setUnitId(planDetailVO.getUnitId());
                detailExecutionVO.setUnitName(planDetailVO.getUnitName());
                detailExecutionVO.setNum(planDetailVO.getNum());
                detailExecutionVO.setMoney(planDetailVO.getMoney());
                detailExecutionVO.setSpec(planDetailVO.getSpec());
                detailExecutionVO.setTaxMoney(planDetailVO.getDetailTaxMny());
                detailExecutionVO.setPrice(planDetailVO.getPrice());
                detailExecutionVO.setTaxPrice(planDetailVO.getDetailTaxPrice());
                detailExecutionVO.setTaxRate(planDetailVO.getDetailTaxRate());
                detailList.add(detailExecutionVO);
            }
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    public Boolean delContractFile(Long fileId, String authority) {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> header = new HashMap<String, String>();
        params.put("ids", fileId.toString());
        header.put("authority", authority);
        String delRespStr = null;
        try {
            delRespStr = HttpTookit.get((String)(this.BaseHost + "ejc-file-web/attachment/delete"), params, header, (int)10000, (int)10000);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CommonResponse delResp = (CommonResponse)JSONObject.parseObject(delRespStr, CommonResponse.class);
        if (delResp != null) {
            this.logger.info("\u5728\u7ebf\u8d77\u8349\uff0c\u5220\u9664\u4e0a\u4f20\u5408\u540c\u8fd4\u56de\u4fe1\u606f\uff1a" + delResp.getMsg());
        }
        return true;
    }

    @Override
    public Boolean pushContract(ContractVO contractVO) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert((Object)contractVO, (Object)data);
            data.setPurchaseType(Integer.valueOf(contractVO.getPurchaseType()));
            data.setSourceType(ContractTypeEnum.\u5546\u8d38\u516c\u53f8\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getTypeCode());
            int targetType = contractVO.getTargetResultId() == null ? 1 : 0;
            data.setPcCardUrl("/ejc-trade-frontend/#/contractMaterial/contractApprove?id=" + contractVO.getId() + "&supplementFlag=" + contractVO.getSupplementFlag() + "&targetType=" + targetType + "&performanceStatus=" + contractVO.getPerformanceStatus());
            if (MaterialContractTypeEnum.\u6df7\u51dd\u571f.getCode().equals(contractVO.getContractType())) {
                data.setSourceType(ContractTypeEnum.\u6df7\u51dd\u571f\u5408\u540c.getTypeCode());
                data.setPcCardUrl("/ejc-trade-frontend/#/contractConcrete/contractApprove?id=" + contractVO.getId() + "&supplementFlag=" + contractVO.getSupplementFlag() + "&targetType=" + targetType + "&performanceStatus=" + contractVO.getPerformanceStatus());
            }
            data.setContractProperty(ContractPropertyEnum.\u652f\u51fa\u5408\u540c.getPropertyCode());
            this.logger.info("\u5f00\u59cb\u63a8\u9001\u5408\u540c\u6c60>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            this.logger.info("\u63a8\u9001\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)data));
            CommonResponse transDataResp = this.contractPoolApi.saveOrUpdateContract(data);
            this.logger.info("\u63a8\u9001\u5408\u540c\u6c60\u7ed3\u675f\uff0c\u63a8\u9001\u7ed3\u679c\uff1a{}<<<<<<<<<<<<<<<<<<<<<<<<<<<<<", (Object)transDataResp.isSuccess());
            if (!transDataResp.isSuccess()) {
                this.logger.error("\u5408\u540cid-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c{}", (Object)contractVO.getId(), (Object)transDataResp.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u5408\u540c-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c", (Object)contractVO.getId(), (Object)e);
            return false;
        }
        return true;
    }

    @Override
    public ContractVO syncPushContract(Long id) {
        return null;
    }

    @Override
    public void pushDelContract(ContractVO contractVO) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert((Object)contractVO, (Object)data);
            data.setSourceType(ContractTypeEnum.\u5546\u8d38\u516c\u53f8\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getTypeCode());
            if (MaterialContractTypeEnum.\u6df7\u51dd\u571f.getCode().equals(contractVO.getContractType())) {
                data.setSourceType(ContractTypeEnum.\u6df7\u51dd\u571f\u5408\u540c.getTypeCode());
            }
            this.logger.info("\u5f00\u59cb\u5220\u9664\u5408\u540c\u6c60\u5408\u540c>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            this.logger.info("\u63a8\u9001\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)data));
            CommonResponse transDataResp = this.contractPoolApi.deleteContract(data);
            this.logger.info("\u5220\u9664\u5408\u540c\u6c60\u5408\u540c\u7ed3\u675f\uff0c\u5220\u9664\u7ed3\u679c\uff1a{}<<<<<<<<<<<<<<<<<<<<<<<<<<<<<", (Object)transDataResp.isSuccess());
            if (!transDataResp.isSuccess()) {
                this.logger.error("\u5408\u540cid-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c{}", (Object)contractVO.getId(), (Object)transDataResp.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u5408\u540c-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c", (Object)contractVO.getId(), (Object)e);
        }
    }

    @Override
    public boolean addRelieveFlag(Long id) {
        ContractEntity contractEntity = (ContractEntity)((Object)super.selectById((Serializable)id));
        if (!PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode().equals(contractEntity.getPerformanceStatus())) {
            return false;
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)id));
        List relieveEntityList = this.relieveService.queryList(queryParam, false);
        return CollectionUtils.isEmpty((Collection)relieveEntityList);
    }

    @Override
    public boolean checkContract(Long id, Long otherId) {
        List contractChangeEntityList;
        Long orgId;
        List<Integer> billStateList = Arrays.asList(BillStateEnum.UNCOMMITED_STATE.getBillStateCode(), BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.UNAPPROVED.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
        ContractEntity contractEntity = (ContractEntity)((Object)super.selectById((Serializable)id));
        if (PurchaseTypeEnum.\u516c\u53f8\u96c6\u91c7.getCode().equals(contractEntity.getPurchaseType()) && !(orgId = InvocationInfoProxy.getOrgId()).equals(contractEntity.getOrgId())) {
            throw new BusinessException("\u5f53\u524d\u7ec4\u7ec7\u65e0\u6cd5\u5bf9\u8be5\u5408\u540c\u8fdb\u884c\u64cd\u4f5c\uff01");
        }
        QueryParam supplementQueryParam = new QueryParam();
        supplementQueryParam.getParams().put("mainContractId", new Parameter("eq", (Object)id));
        if (otherId != null) {
            supplementQueryParam.getParams().put("id", new Parameter("ne", (Object)otherId));
        }
        supplementQueryParam.getParams().put("signatureStatus", new Parameter("ne", (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()));
        List supplementContractList = super.queryList(supplementQueryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)supplementContractList)) {
            throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae\uff01");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)id));
        queryParam.getParams().put("signatureStatus", new Parameter("ne", (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()));
        if (otherId != null) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)otherId));
        }
        if (CollectionUtils.isNotEmpty((Collection)(contractChangeEntityList = this.contractChangeService.queryList(queryParam, false)))) {
            throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u53d8\u66f4\u5408\u540c\uff01");
        }
        List relieveEntityList = this.relieveService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)relieveEntityList)) {
            throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u5408\u540c\u89e3\u9664\u5355\u636e\uff01");
        }
        queryParam.getParams().remove("signatureStatus");
        queryParam.getParams().put("billState", new Parameter("in", billStateList));
        List freezeEntityList = this.freezeService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)freezeEntityList)) {
            throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u5408\u540c\u51bb\u7ed3\u6216\u5408\u540c\u89e3\u51bb\u5355\u636e\uff01");
        }
        return true;
    }

    @Override
    public ParamsCheckVO targetCostCtrl(ContractVO contractVO, String authority) {
        return null;
    }

    @Override
    public ParamsCheckVO viewTargetCostCtrlInfo(Long id) {
        return null;
    }

    @Override
    public CommonResponse<String> pushTargetCost(Long id) {
        return CommonResponse.success((String)"\u76ee\u6807\u6210\u672c\u63a8\u9001\u6210\u529f");
    }

    @Override
    public ParamsCheckVO checkParams(ContractVO vo, ParamsCheckVO paramsCheckVO2) {
        return null;
    }

    @Override
    public List<ParamsCheckVO> checkParamsMnySup(ContractVO vo) {
        return null;
    }

    @Override
    public List<ParamsCheckVO> checkParamsMnyPlan(ContractVO vo) {
        return null;
    }

    @Override
    public List<ParamsCheckVO> checkParamsConstruction(ContractVO vo) {
        return null;
    }

    @Override
    public ParamsCheckVO priceCheckParams(ContractVO vo) {
        return null;
    }

    @Override
    public boolean delWatermarkContractFile(Long watermarkFileId) {
        Assert.notNull((Object)watermarkFileId, (String)"\u6c34\u5370\u5408\u540c\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        CommonResponse res = this.attachmentApi.delete(String.valueOf(watermarkFileId));
        if (!res.isSuccess()) {
            this.logger.error("\u5220\u9664\u6587\u4ef6\u4e2d\u5fc3\u6c34\u5370\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}\uff0c\u6c34\u5370\u6587\u4ef6id\uff1a{}", (Object)res.getMsg(), (Object)watermarkFileId);
            throw new BusinessException("\u5220\u9664\u6587\u4ef6\u4e2d\u5fc3\u6c34\u5370\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + res.getMsg() + "\uff0c\u6c34\u5370\u6587\u4ef6id\uff1a" + watermarkFileId);
        }
        return true;
    }

    @Override
    public ContractPaymentResultVO queryPaymentApplyList(Long id) {
        return null;
    }

    @Override
    public List<MaterialReportVO> quueryMaterialByProject(Page pages, QueryWrapper queryWrapper, Long projectId) {
        List<MaterialReportVO> list = ((ContractMapper)this.baseMapper).quueryMaterialByProject(pages, queryWrapper, projectId);
        CommonResponse resDate = this.iDutyApi.queryDoc(projectId);
        if (!resDate.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u6210\u672c\u6570\u91cf\u4fe1\u606f\u5931\u8d25,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5!");
        }
        Map map = (Map)resDate.getData();
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(e -> {
                if (null != map && map.containsKey(e.getMaterialId())) {
                    e.setMbNum(map.get(e.getMaterialId()) == null ? BigDecimal.ZERO : (BigDecimal)map.get(e.getMaterialId()));
                }
            });
        }
        return list;
    }

    @Override
    public List<ContractMaterialReportVO> quueryMaterialByOrg(Page page, QueryWrapper wrapper) {
        List<ContractMaterialReportVO> contractMaterialReportVOList = ((ContractMapper)this.baseMapper).quueryMaterialByOrg(page, wrapper);
        if (CollectionUtils.isNotEmpty(contractMaterialReportVOList)) {
            for (ContractMaterialReportVO contractMaterialReportVO : contractMaterialReportVOList) {
                if (contractMaterialReportVO.getContractNum() == null || BigDecimal.ZERO.compareTo(contractMaterialReportVO.getContractNum()) == 0) {
                    contractMaterialReportVO.setContractTaxPrice(BigDecimal.ZERO);
                } else {
                    contractMaterialReportVO.setContractTaxPrice(contractMaterialReportVO.getContractTaxMny().divide(contractMaterialReportVO.getContractNum(), 8, 5));
                }
                if (contractMaterialReportVO.getContractMny() == null || BigDecimal.ZERO.compareTo(contractMaterialReportVO.getContractMny()) == 0) {
                    contractMaterialReportVO.setContractTaxRate(BigDecimal.ZERO);
                    continue;
                }
                BigDecimal contractTaxRate = contractMaterialReportVO.getContractTaxMny().divide(contractMaterialReportVO.getContractMny(), 8, 5).subtract(new BigDecimal(1));
                contractMaterialReportVO.setContractTaxRate(contractTaxRate.multiply(new BigDecimal(100)));
            }
            List<Long> contractIds = contractMaterialReportVOList.stream().map(ContractMaterialReportVO::getContractId).collect(Collectors.toList());
            List<ContractMaterialReportVO> orderList = ((ContractMapper)this.baseMapper).getOrderNum(contractIds);
            List<ContractMaterialReportVO> checkList = ((ContractMapper)this.baseMapper).getCheckNum(contractIds);
            List<ContractMaterialReportVO> settleList = ((ContractMapper)this.baseMapper).getSettleNum(contractIds);
            if (CollectionUtils.isNotEmpty(settleList)) {
                for (ContractMaterialReportVO contractMaterialReportVO : settleList) {
                    if (BigDecimal.ZERO.compareTo(contractMaterialReportVO.getSettlementNum()) == 0) {
                        contractMaterialReportVO.setSettlementTaxPrice(BigDecimal.ZERO);
                    } else {
                        contractMaterialReportVO.setSettlementTaxPrice(contractMaterialReportVO.getSettlementTaxMny().divide(contractMaterialReportVO.getSettlementNum(), 8, 5));
                    }
                    if (BigDecimal.ZERO.compareTo(contractMaterialReportVO.getSettlementMny()) == 0) {
                        contractMaterialReportVO.setSettlementTaxRate(BigDecimal.ZERO);
                        continue;
                    }
                    BigDecimal contractTaxRate = contractMaterialReportVO.getSettlementTaxMny().divide(contractMaterialReportVO.getSettlementMny(), 8, 5).subtract(new BigDecimal(1));
                    contractMaterialReportVO.setSettlementTaxRate(contractTaxRate.multiply(new BigDecimal(100)));
                }
            }
            for (ContractMaterialReportVO contractMaterialReportVO : contractMaterialReportVOList) {
                for (ContractMaterialReportVO order : orderList) {
                    if (!contractMaterialReportVO.getContractId().equals(order.getContractId()) || !contractMaterialReportVO.getMaterialId().equals(order.getMaterialId())) continue;
                    contractMaterialReportVO.setOrderNum(order.getOrderNum());
                }
                for (ContractMaterialReportVO check : checkList) {
                    if (!contractMaterialReportVO.getContractId().equals(check.getContractId()) || !contractMaterialReportVO.getMaterialId().equals(check.getMaterialId())) continue;
                    contractMaterialReportVO.setCheckNum(check.getCheckNum());
                }
                for (ContractMaterialReportVO settle : settleList) {
                    if (!contractMaterialReportVO.getContractId().equals(settle.getContractId()) || !contractMaterialReportVO.getMaterialId().equals(settle.getMaterialId())) continue;
                    contractMaterialReportVO.setSettlementNum(settle.getSettlementNum());
                    contractMaterialReportVO.setSettlementTaxRate(settle.getSettlementTaxRate());
                    contractMaterialReportVO.setSettlementTaxPrice(settle.getSettlementTaxPrice());
                    contractMaterialReportVO.setSettlementTaxMny(settle.getSettlementTaxMny());
                }
            }
        }
        return contractMaterialReportVOList;
    }

    @Override
    public void updateTargetResult(ContractVO vo, Integer type) {
    }

    @Override
    public List<SignContractVo> queryContractByTargetResultId(List<String> targetResultIdList) {
        return null;
    }

    private String getContractLinkUrl(Long targetResultId, Long contractId, Integer supplementFlag, String performanceStatus, Integer contractType) {
        int targetType = targetResultId == null ? 1 : 0;
        String url = "/ejc-promaterial-frontend/#/contractMaterial/contractApprove?id=" + contractId + "&supplementFlag=" + supplementFlag + "&targetType=" + targetType + "&performanceStatus=" + performanceStatus;
        if (MaterialContractTypeEnum.\u6df7\u51dd\u571f.getCode().equals(contractType)) {
            url = "/ejc-promaterial-frontend/#/contractConcrete/contractApprove?id=" + contractId + "&supplementFlag=" + supplementFlag + "&targetType=" + targetType + "&performanceStatus=" + performanceStatus;
        }
        return url;
    }

    private void checkDetailTenderNum(List<ContractDetailVO> detailList, Long contractId, Long targetResultId) {
        List detailEntityList;
        if (targetResultId == null) {
            return;
        }
        if (CollectionUtils.isEmpty(detailList)) {
            return;
        }
        for (ContractDetailVO vo : detailList) {
            if (vo.getSignNum() != null && vo.getSignNum().compareTo(vo.getNum()) >= 0) continue;
            throw new BusinessException("\u7b7e\u8ba2\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u53ef\u7b7e\u8ba2\u6570\u91cf");
        }
        List sourceIdList = detailList.stream().map(ContractDetailVO::getSourceId).collect(Collectors.toList());
        QueryParam detailParam = new QueryParam();
        detailParam.getParams().put("sourceId", new Parameter("in", sourceIdList));
        if (contractId != null) {
            detailParam.getParams().put("contractId", new Parameter("ne", (Object)contractId));
        }
        if (CollectionUtils.isEmpty((Collection)(detailEntityList = this.contractDetailService.queryList(detailParam, false)))) {
            return;
        }
        Map<String, List<ContractDetailEntity>> queryMap = detailEntityList.stream().collect(Collectors.groupingBy(ContractDetailEntity::getSourceId));
        for (ContractDetailVO detail : detailList) {
            List<ContractDetailEntity> queryDetailList = queryMap.get(detail.getSourceId());
            BigDecimal tenderNum = CommonUtils.setBigDecimalDefaultValue(detail.getTenderNum());
            if (CollectionUtils.isEmpty(queryDetailList)) continue;
            BigDecimal signTenderNum = BigDecimal.ZERO;
            for (ContractDetailEntity detailEntity : queryDetailList) {
                signTenderNum = signTenderNum.add(CommonUtils.setBigDecimalDefaultValue(detailEntity.getInitNum()));
            }
            BigDecimal sy = tenderNum.subtract(signTenderNum);
            if (sy.compareTo(detail.getNum()) >= 0) continue;
            throw new BusinessException(detail.getMaterialName() + "\u91c7\u8d2d\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7" + sy);
        }
    }

    @Override
    public void asyncWatermarkById(Long id) {
        ContractEntity contractEntity = (ContractEntity)((Object)super.selectById((Serializable)id));
        CommonResponse response = this.paramConfigApi.getByCode(WATERMARK_CHECK_PARAM_NAME);
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("\u83b7\u53d6\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u8bf7\u6c42\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
        }
        String valueData = ((ParamRegisterSetVO)response.getData()).getValueData();
        Assert.hasText((String)valueData, (String)"\u83b7\u53d6\u7684\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        if ("0".equals(valueData)) {
            String billType = "BT211227000000003";
            String sourceType = "contractMaterial";
            if (MaterialContractTypeEnum.\u6df7\u51dd\u571f.getCode().equals(contractEntity.getContractType())) {
                billType = "BT220215000000001";
                sourceType = "contractConcrete";
            }
            WatermarkVO watermarkVO = this.signatureCommonApi.fetchWatermarkConfig(contractEntity.getContractFileId(), contractEntity.getId(), contractEntity.getBillCode(), billType, sourceType);
            Assert.notNull((Object)watermarkVO, (String)"\u83b7\u53d6\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u5931\u8d25!");
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("authority", request.getHeader("authority"));
            headers.put("ejc-token", request.getHeader("ejc-token"));
            this.contractAsyncService.fetchWatermarkAttachment(headers, watermarkVO);
        }
    }

    @Override
    public String getContractFilingCode() {
        CommonResponse response = this.paramConfigApi.getByCode(CONTRACT_FILING_CODE);
        this.logger.info("\u5408\u540c\u5f52\u6863\u63a7\u5236\u53c2\u6570\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)response));
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("\u83b7\u53d6\u5408\u540c\u5f52\u6863\u63a7\u5236\u53c2\u6570\u8bf7\u6c42\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
        }
        String valueData = ((ParamRegisterSetVO)response.getData()).getValueData();
        return StringUtils.isNotEmpty((CharSequence)valueData) ? valueData : "0";
    }

    @Override
    public boolean checkContractFiling(Long contractId) {
        String valueData = this.getContractFilingCode();
        ContractEntity contractEntity = (ContractEntity)((Object)super.selectById((Serializable)contractId));
        if ("0".equals(valueData)) {
            return true;
        }
        return FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode().equals(contractEntity.getFilingStatus());
    }

    @Override
    public CommonResponse<List<MaterialMnyVO>> queryMaterialMnyByYear(String year, Long orgId) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (orgId == null) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        List contractList = super.queryList(param);
        List materialMnyList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)contractList)) {
            List contractIds = contractList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            this.logger.info("\u67e5\u51fa\u7b26\u5408\u6761\u4ef6\u5408\u540cid\uff1a{}", (Object)JSONObject.toJSONString(contractIds));
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"DATE_FORMAT(create_time,'%Y')", (Object)year);
            wrapper.in((Object)"contract_id", contractIds);
            wrapper.eq((Object)"dr", (Object)0);
            wrapper.isNotNull((Object)"material_type_name");
            wrapper.select(new String[]{"material_type_name as materialTypeName, material_type_id as materialTypeId, sum( detail_tax_mny ) AS detailTaxMny"});
            wrapper.groupBy((Object[])new String[]{"material_type_id"});
            wrapper.orderByDesc((Object)"detailTaxMny");
            wrapper.last("limit 5");
            List contractDetailList = this.contractDetailService.list((Wrapper)wrapper);
            if (CollectionUtils.isNotEmpty((Collection)contractDetailList)) {
                this.logger.info("\u67e5\u51fa\u7b26\u5408\u6761\u4ef6\u5408\u540cid\uff1a{}", (Object)JSONObject.toJSONString((Object)contractDetailList));
                materialMnyList = BeanMapper.mapList((Iterable)contractDetailList, MaterialMnyVO.class);
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u7269\u6599\u91d1\u989d\u4f7f\u7528\u6570\u636e\u6210\u529f\uff01", materialMnyList);
    }
}

