/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.study.util;

import com.ejianc.business.study.annotation.MyAutowired;
import com.ejianc.business.study.annotation.MyService;
import com.ejianc.business.study.util.ClazzUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class ApplicationContext {
    private String packageName;
    private static ConcurrentHashMap<String, Object> beanMap;

    public ApplicationContext(String packageName) {
        this.packageName = packageName;
        beanMap = new ConcurrentHashMap();
        try {
            this.initBeans();
            this.initAttributes();
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
    }

    private void initAttributes() {
        beanMap.forEach((beanId, bean) -> {
            try {
                this.attributeAssign((String)beanId, bean);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        });
    }

    private void attributeAssign(String beanId, Object bean) throws IllegalAccessException {
        Field[] fields;
        for (Field field : fields = bean.getClass().getDeclaredFields()) {
            String autowiredBeanId;
            Object autowiredBean;
            if (!field.isAnnotationPresent(MyAutowired.class) || Objects.isNull(autowiredBean = this.getBean(autowiredBeanId = field.getName(), field.getType()))) continue;
            field.setAccessible(true);
            field.set(bean, autowiredBean);
            field.setAccessible(false);
        }
    }

    private void initBeans() throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        List<Class<?>> classList = ClazzUtil.getClasses(this.packageName);
        for (Class<?> clazz : classList) {
            if (!clazz.isAnnotationPresent(MyService.class) || clazz.isInterface()) continue;
            MyService myService = clazz.getAnnotation(MyService.class);
            String beanId = myService.value();
            if (Objects.isNull(beanId) || "".equals(beanId)) {
                beanId = clazz.getSimpleName();
                beanId = beanId.substring(0, 1).toLowerCase() + beanId.substring(1);
                beanId = beanId.replace("Impl", "");
            }
            beanMap.put(beanId, clazz.newInstance());
        }
    }

    public <T> T getBean(String beanId, Class<T> type) {
        if (Objects.isNull(beanId) || "".equalsIgnoreCase(beanId)) {
            throw new RuntimeException("BeanID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Object bean = beanMap.get(beanId);
        if (Objects.isNull(bean)) {
            throw new RuntimeException("\u5bb9\u5668\u4e2d\u4e0d\u5b58\u5728BeanID\u4e3a" + beanId + "\u7684\u5bf9\u8c61\uff01");
        }
        return (T)bean;
    }
}

