package com.ejianc.business.capital.bean;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.capital.bean.CapitalCollectionRegistrationSubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 资本金收款登记
 * 
 * @author generator
 * 
 */
 @TableName("ejc_train_capital_yst")
public class CapitalCollectionRegistrationEntity extends BaseEntity {
    private static final Long serialVersionUID = 1L;


    /**
     * 创建人名称
     */
    @TableField("create_user_name")
    private String createUserName;

    /**
     * 修改人名称
     */
    @TableField("modify_user_name")
    private String modifyUserName;

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    @TableField("bill_state")
    private Integer billState;

    /**
     * 提交日期
     */
    @TableField("commit_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date commitDate;

    /**
     * 提交人名称
     */
    @TableField("commit_user_name")
    private String commitUserName;

    /**
     * 提交人账号
     */
    @TableField("commit_user_code")
    private String commitUserCode;

    /**
     * 生效日期
     */
    @TableField("effective_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date effectiveDate;






    /**
     * 单据编号
     */
    @TableField("code")
    private String code;

    /**
     * 申请组织名称
     */
    @TableField("apply_org_name")
    private String applyOrgName;


    /**
     * 登记组织id
     */
    @TableField("register_org_id")
    private Long registerOrgId;


    /**
     * 登记组织名称
     */
    @TableField("register_org_name")
    private String registerOrgName;

    /**
     * 注册资本
     */
    @TableField("register_capital")
    private java.math.BigDecimal registerCapital;

    /**
     * 注册资本币种
     */
    @TableField("currency_type_id")
    private Long currencyTypeId;

    /**
     * 注册资本币种名称
     */
    @TableField("currency_type_name")
    private String currencyTypeName;

    /**
     * 备注
     */
    @TableField("remarks")
    private String remarks;

    /**
     * 总实缴金额
     */
    @TableField("total_capital")
    private java.math.BigDecimal totalCapital;

    /**
     * 所有出资方
     */
    @TableField("total_contributor")
    private String totalContributor;

    /**
     * 子表
     */
    @TableField(exist=false)
    @SubEntity(serviceName="capitalCollectionRegistrationSubService")
    private List<CapitalCollectionRegistrationSubEntity> capitalCollectionRegistrationSubList = new ArrayList<>(); // 资本金收款登记子表

    public List<CapitalCollectionRegistrationSubEntity> getCapitalCollectionRegistrationSubList() {
        return capitalCollectionRegistrationSubList;
    }

    public void setCapitalCollectionRegistrationSubList(List<CapitalCollectionRegistrationSubEntity> capitalCollectionRegistrationSubList) {
        this.capitalCollectionRegistrationSubList = capitalCollectionRegistrationSubList;
    }


    //
//    @Override
//    public Long getId() {
//        return id;
//    }
//
//    @Override
//    public void setId(Long id) {
//        this.id = id;
//    }
//
//    @Override
//    public String getCreateUserCode() {
//        return createUserCode;
//    }
//
//    @Override
//    public void setCreateUserCode(String createUserCode) {
//        this.createUserCode = createUserCode;
//    }
//
//    @Override
//    public Date getCreateTime() {
//        return createTime;
//    }
//
//    @Override
//    public void setCreateTime(Date createTime) {
//        this.createTime = createTime;
//    }
//
//    @Override
//    public String getUpdateUserCode() {
//        return updateUserCode;
//    }
//
//    @Override
//    public void setUpdateUserCode(String updateUserCode) {
//        this.updateUserCode = updateUserCode;
//    }
//
//    @Override
//    public Date getUpdateTime() {
//        return updateTime;
//    }
//
//    @Override
//    public void setUpdateTime(Date updateTime) {
//        this.updateTime = updateTime;
//    }
//
//    @Override
//    public Integer getDr() {
//        return dr;
//    }
//
//    @Override
//    public void setDr(Integer dr) {
//        this.dr = dr;
//    }
//
//    @Override
//    public Long getTenantId() {
//        return tenantId;
//    }
//
//    @Override
//    public void setTenantId(Long tenantId) {
//        this.tenantId = tenantId;
//    }
//
//    @Override
//    public Integer getSyncEsFlag() {
//        return syncEsFlag;
//    }
//
//    @Override
//    public void setSyncEsFlag(Integer syncEsFlag) {
//        this.syncEsFlag = syncEsFlag;
//    }
//
//    @Override
//    public Integer getVersion() {
//        return version;
//    }
//
//    @Override
//    public void setVersion(Integer version) {
//        this.version = version;
//    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getModifyUserName() {
        return modifyUserName;
    }

    public void setModifyUserName(String modifyUserName) {
        this.modifyUserName = modifyUserName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getApplyOrgName() {
        return applyOrgName;
    }

    public void setApplyOrgName(String applyOrgName) {
        this.applyOrgName = applyOrgName;
    }

    public String getRegisterOrgName() {
        return registerOrgName;
    }

    public void setRegisterOrgName(String registerOrgName) {
        this.registerOrgName = registerOrgName;
    }

    public BigDecimal getRegisterCapital() {
        return registerCapital;
    }

    public void setRegisterCapital(BigDecimal registerCapital) {
        this.registerCapital = registerCapital;
    }

    public Long getCurrencyTypeId() {
        return currencyTypeId;
    }

    public void setCurrencyTypeId(Long currencyTypeId) {
        this.currencyTypeId = currencyTypeId;
    }

    public String getCurrencyTypeName() {
        return currencyTypeName;
    }

    public void setCurrencyTypeName(String currencyTypeName) {
        this.currencyTypeName = currencyTypeName;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public BigDecimal getTotalCapital() {
        return totalCapital;
    }

    public void setTotalCapital(BigDecimal totalCapital) {
        this.totalCapital = totalCapital;
    }

    public String getTotalContributor() {
        return totalContributor;
    }

    public void setTotalContributor(String totalContributor) {
        this.totalContributor = totalContributor;
    }

    public Long getRegisterOrgId() {
        return registerOrgId;
    }

    public void setRegisterOrgId(Long registerOrgId) {
        this.registerOrgId = registerOrgId;
    }


}
