package com.ejianc.business.capital.controller;

import java.io.Serializable;

import com.ejianc.business.capital.vo.CapitalCollectionRegistrationSubVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.capital.bean.CapitalCollectionRegistrationEntity;
import com.ejianc.business.capital.service.ICapitalCollectionRegistrationService;
import com.ejianc.business.capital.vo.CapitalCollectionRegistrationVO;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/**
 * 资本金收款登记
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("capital")
public class CapitalCollectionRegistrationController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private SessionManager sessionManager;

    private static final String BILL_CODE = "capital_code";//此处需要根据实际修改

    @Autowired
    private ICapitalCollectionRegistrationService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CapitalCollectionRegistrationVO> saveOrUpdate(@RequestBody CapitalCollectionRegistrationVO saveorUpdateVO) {
    	CapitalCollectionRegistrationEntity entity = BeanMapper.map(saveorUpdateVO, CapitalCollectionRegistrationEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
//                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	entity.setApplyOrgName(sessionManager.getUserContext().getOrgName());
    	entity.setCommitUserName(sessionManager.getUserContext().getUserName());
    	entity.setCommitDate(new Date());
    	entity.setCommitUserCode(sessionManager.getUserContext().getUserCode());
    	String totalContributor = "";
    	List<CapitalCollectionRegistrationSubVO> subList = saveorUpdateVO.getCapitalCollectionRegistrationSubList();
    	for (CapitalCollectionRegistrationSubVO cr : subList){
    	    if (!StringUtils.isBlank(totalContributor)){
    	        totalContributor += "," + cr.getContributor();
            }else {
    	        totalContributor += cr.getContributor();
            }
        }
    	entity.setTotalContributor(totalContributor);
    	entity.setModifyUserName(sessionManager.getUserContext().getUserName());
    	service.saveOrUpdate(entity, false);
    	CapitalCollectionRegistrationVO vo = BeanMapper.map(entity, CapitalCollectionRegistrationVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CapitalCollectionRegistrationVO> queryDetail(Long id) {
    	CapitalCollectionRegistrationEntity entity = service.selectById(id);
    	CapitalCollectionRegistrationVO vo = BeanMapper.map(entity, CapitalCollectionRegistrationVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CapitalCollectionRegistrationVO> vos) {
        service.removeByIds(vos.stream().map(CapitalCollectionRegistrationVO::getId).collect(Collectors.toList()),true);


        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CapitalCollectionRegistrationVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("applyOrgName");
        fuzzyFields.add("totalContributor");
        /** 租户隔离 */
//        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

//        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
//        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());

//        if(!childOrgResp.isSuccess()) {
//            throw new BusinessException("分页列表查询失败, 查询组织信息失败！");
//        }
//        List<Long> childIds = new ArrayList<>();
//        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
//        param.getParams().put("orgId", new Parameter(QueryParam.IN, childIds));

        IPage<CapitalCollectionRegistrationEntity> page = service.queryPage(param,false);
        IPage<CapitalCollectionRegistrationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CapitalCollectionRegistrationVO.class));




        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.getFuzzyFields().add("id");
        param.setPageIndex(1);
        param.setPageSize(10000);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<CapitalCollectionRegistrationEntity> list = service.queryList(param);
        //todo:字段翻译等等
//        if(CollectionUtils.isNotEmpty(pageData.getRecords())) {
//            pageData.getRecords().forEach(loanInterest -> {
//                PrjLoanInterestVO r = BeanMapper.map(loanInterest, PrjLoanInterestVO.class);
//                r.setBillStateName(BillStateEnum.getEnumByStateCode(r.getBillState()).getDescription());
//                voList.add(r);
//            });D:\Tools\ideaworkspace\ejc-train\ejc-train-web\src\main\resources\excel\capitalCollectionRegister-export.xlsx
//        }
        List<CapitalCollectionRegistrationVO> voList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(list)) {
            list.forEach(capitalList -> {
                CapitalCollectionRegistrationVO r = BeanMapper.map(capitalList, CapitalCollectionRegistrationVO.class);
                r.setBillStateName(BillStateEnum.getEnumByStateCode(r.getBillState()).getDescription());
                voList.add(r);
            });
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("capitalCollectionRegister-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refCapitalCollectionRegistrationData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CapitalCollectionRegistrationVO>> refCapitalCollectionRegistrationData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<CapitalCollectionRegistrationEntity> page = service.queryPage(param,false);
        IPage<CapitalCollectionRegistrationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CapitalCollectionRegistrationVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }



    @PostMapping(value = "/downloadImportTemplate")
    public void downloadImportTemplate(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "capitalCollectionRegister-import.xlsx", "资本金收款登记");
    }


    @PostMapping(value = "capitalExcelImport")
    @ResponseBody
    public CommonResponse<JSONObject> capitalExcelImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();

        boolean isFailed = false;
        MultipartFile mf = null;

        List<JSONObject> successList = new ArrayList<>();
        List<JSONObject> errorList = new ArrayList<>();

        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                if(result.size()>10000){
                    return CommonResponse.error("数据超过10000条，请分批上传！");
                }
                CapitalCollectionRegistrationEntity parentEntity = null;
                for(int i = 0;i < result.size(); i++) {
                    List<String> datas = result.get(i);
//                    JSONObject area = new JSONObject();
                    JSONObject capital = new JSONObject();
                    capital.put("id", IdWorker.getId());
                    capital.put("code", datas.get(0));
                    capital.put("applyOrgName", datas.get(1));
                    capital.put("registerOrgName", datas.get(2));
                    capital.put("totalContributor", datas.get(3));
                    capital.put("commitUserName", datas.get(4));
                    capital.put("billStateName", datas.get(5));
//                    capital.put("commitUserName", datas.get(4));billStateName
//                    capital.put("commitUserName", datas.get(4));billStateName


                    if(StringUtils.isBlank(datas.get(0))){
                        capital.put("err", "单据编号为空！");
                        errorList.add(capital);
                        continue;
                    }
                    if(StringUtils.isBlank(datas.get(1))){
                        capital.put("err", "申请组织名称名称为空！");
                        errorList.add(capital);
                        continue;
                    }

                    if(datas.get(0).length() > 50) {
                        capital.put("err", "单据编号为空长度限制为50字以内！");
                        errorList.add(capital);
                        continue;
                    }
                    if(datas.get(1).length() > 200) {
                        capital.put("err", "申请组织名称名称长度限制为200字以内！");
                        errorList.add(capital);
                        continue;
                    }

                    if(StringUtils.isBlank(datas.get(2))){
                        capital.put("err", "登记组织名称名称为空！");
                        errorList.add(capital);
                        continue;
                    }

                    if(datas.get(2).length() > 200) {
                        capital.put("err", "登记组织名称长度限制为50字以内！");
                        errorList.add(capital);
                        continue;
                    }


                    if(datas.get(3).length() > 200) {
                        capital.put("err", "出资人名称长度限制为200字以内！");
                        errorList.add(capital);
                        continue;
                    }


                    if(datas.get(4).length() > 50) {
                        capital.put("err", "登记人长度限制为50字以内！");
                        errorList.add(capital);
                        continue;
                    }


                    if(datas.get(5).length() > 50) {
                        capital.put("err", "单据状态长度限制为50字以内！");
                        errorList.add(capital);
                        continue;
                    }

                    QueryParam queryParam = new QueryParam();
                    queryParam.getParams().put("code", new Parameter(QueryParam.EQ, capital.get("code")));
                    List<CapitalCollectionRegistrationEntity> list = service.queryList(queryParam, false);
                    if(CollectionUtils.isNotEmpty(list)) {
                        capital.put("err", "单据编号重复！");
                        errorList.add(capital);
                        continue;
                    }
                    successList.add(capital);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success(json);
    }

    @PostMapping(value = "/saveCapitalExcelImport")
    @ResponseBody
    public CommonResponse<String> saveCapitalExcelImport(@RequestBody List<JSONObject> importData) {
        if(ListUtil.isEmpty(importData)){
            return CommonResponse.error("导入的数据为空！");
        }
        List<CapitalCollectionRegistrationEntity> saveData = BeanMapper.mapList(importData, CapitalCollectionRegistrationEntity.class);
        service.saveOrUpdateBatch(saveData, saveData.size(), false);
        return CommonResponse.success("导入成功！");
    }





}
