package com.ejianc.business.capital.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.capital.bean.CapitalCollectionRegistrationEntity;
import com.ejianc.business.capital.bean.CapitalCollectionRegistrationSubEntity;
import com.ejianc.business.capital.service.ICapitalCollectionRegistrationService;
import com.ejianc.business.capital.service.ICapitalCollectionRegistrationSubService;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;

@Service("capitalCollectionRegistration") 
public class CapitalCollectionRegistrationBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private ICapitalCollectionRegistrationService capitalCollectionRegistrationService;

	@Autowired
	private ICapitalCollectionRegistrationSubService capitalCollectionRegistrationSubService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {

		QueryWrapper<CapitalCollectionRegistrationSubEntity> query = new QueryWrapper<>();
		query.eq("pid", billId);
		List<CapitalCollectionRegistrationSubEntity> list = capitalCollectionRegistrationSubService.list(query);
		if (CollectionUtils.isNotEmpty(list)){
			return CommonResponse.success("审批前校验通过！");
		}
		return CommonResponse.error("提交失败，请填写实缴收款信息！");
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		CapitalCollectionRegistrationEntity e = capitalCollectionRegistrationService.selectById(billId);
		e.getRegisterOrgId();
		QueryWrapper<CapitalCollectionRegistrationSubEntity> query = new QueryWrapper<>();
		query.eq("register_org_id", e.getRegisterOrgId());
		query.gt("create_time", DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", e.getCreateTime()));
		List<CapitalCollectionRegistrationSubEntity> list = capitalCollectionRegistrationSubService.list(query);
		if (CollectionUtils.isNotEmpty(list)){
			return CommonResponse.error("撤回失败，当前申请组织下有新的审批单据！");
		}
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
