package com.ejianc.business.capital.vo;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.capital.vo.CapitalCollectionRegistrationSubVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 资本金收款登记
 * 
 * @author generator
 * 
 */
public class CapitalCollectionRegistrationVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    
    private List<CapitalCollectionRegistrationSubVO> capitalCollectionRegistrationSubList = new ArrayList<>(); // 资本金收款登记子表

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date createTime;

    /**
     * 创建人名称
     */
    private String createUserName;

    /**
     * 修改人名称
     */
    private String modifyUserName;

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    private Integer billState;

    /**
     * 提交日期
     */
    private java.util.Date commitDate;

    /**
     * 提交人名称
     */
    private String commitUserName;

    /**
     * 提交人账号
     */
    private String commitUserCode;

    /**
     * 生效日期
     */
    private java.util.Date effectiveDate;






    /**
     * 单据编号
     */
    private String code;

    /**
     * 申请组织名称
     */
    private String applyOrgName;


    /**
     * 登记组织id
     */
    private Long registerOrgId;


    /**
     * 登记组织名称
     */
    private String registerOrgName;

    /**
     * 注册资本
     */
    private java.math.BigDecimal registerCapital;

    /**
     * 注册资本币种
     */
    private Long currencyTypeId;

    /**
     * 注册资本币种名称
     */
    private String currencyTypeName;

    /**
     * 备注
     */
    private String remarks;

    /**
     * 总实缴金额
     */
    private java.math.BigDecimal totalCapital;

    /**
     * 所有出资方
     */
    private String totalContributor;

    private String billStateName;

    public List<CapitalCollectionRegistrationSubVO> getCapitalCollectionRegistrationSubList() {
        return capitalCollectionRegistrationSubList;
    }

    public void setCapitalCollectionRegistrationSubList(List<CapitalCollectionRegistrationSubVO> capitalCollectionRegistrationSubList) {
        this.capitalCollectionRegistrationSubList = capitalCollectionRegistrationSubList;
    }

    @Override
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getModifyUserName() {
        return modifyUserName;
    }

    public void setModifyUserName(String modifyUserName) {
        this.modifyUserName = modifyUserName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getApplyOrgName() {
        return applyOrgName;
    }

    public void setApplyOrgName(String applyOrgName) {
        this.applyOrgName = applyOrgName;
    }

    @ReferDeserialTransfer
    public Long getRegisterOrgId() {
        return registerOrgId;
    }

    public void setRegisterOrgId(Long registerOrgId) {
        this.registerOrgId = registerOrgId;
    }

    public String getRegisterOrgName() {
        return registerOrgName;
    }

    public void setRegisterOrgName(String registerOrgName) {
        this.registerOrgName = registerOrgName;
    }


    public BigDecimal getRegisterCapital() {
        return registerCapital;
    }

    public void setRegisterCapital(BigDecimal registerCapital) {
        this.registerCapital = registerCapital;
    }
    @ReferDeserialTransfer
    public Long getCurrencyTypeId() {
        return currencyTypeId;
    }

    public void setCurrencyTypeId(Long currencyTypeId) {
        this.currencyTypeId = currencyTypeId;
    }

    public String getCurrencyTypeName() {
        return currencyTypeName;
    }

    public void setCurrencyTypeName(String currencyTypeName) {
        this.currencyTypeName = currencyTypeName;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public BigDecimal getTotalCapital() {
        return totalCapital;
    }

    public void setTotalCapital(BigDecimal totalCapital) {
        this.totalCapital = totalCapital;
    }

    public String getTotalContributor() {
        return totalContributor;
    }

    public void setTotalContributor(String totalContributor) {
        this.totalContributor = totalContributor;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    @Override
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }
}
