package com.ejianc.business.study.demo;

import java.lang.annotation.*;
import java.util.Arrays;

/**
 * 基于@Inherited
 * 首先元注解@Inherited作为一个元注解，只能修饰其他注解类型（由@Target(ElementType.ANNOTATION_TYPE)决定）。
 *
 * 所谓的基于@Inherited的继承性，指的是@Inherited修饰的其他注解修饰类时，
 * 这个类的子类是否可以继承到父类的注解；主角是@Inherited修饰的其他注解，而不是@Inherited本身。
 *
 * @Author: songlx
 * @Version: 1.0
 */
public class ClassInheritedTest {


    @Target(value = ElementType.TYPE)
    @Retention(value = RetentionPolicy.RUNTIME)
    @Inherited// 声明注解具有继承性
    @interface AInherited {
        String value() default "";
    }

    //范围
    @Target(value = ElementType.TYPE)
    //@Retention注解保留的位置，RetentionPolicy.RUNTIME被jvm保留运行时可通过反射获取
    @Retention(value = RetentionPolicy.RUNTIME)
    @Inherited
            // 声明注解具有继承性
    @interface BInherited {
        String value() default "";
    }

    @Target(value = ElementType.TYPE)
    @Retention(value = RetentionPolicy.RUNTIME)
            // 未声明注解具有继承性
    @interface CInherited {
        String value() default "";
    }

    @AInherited("父类的AInherited")
    @BInherited("父类的BInherited")
    @CInherited("父类的CInherited")
    class SuperClass {
    }

    @BInherited("子类的BInherited")
    class ChildClass extends SuperClass {
    }

    public static void main(String[] args) {
        Annotation[] annotations = ChildClass.class.getAnnotations();
        System.out.println(Arrays.toString(annotations));
       //System.out.println(annotations.length);
    }
}
