package com.ejianc.business.study.demo;

import java.lang.annotation.*;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;

/**
 * 基于类继承
 * 属性和方法注解的继承，与类注解的继承完全不同，与
 * 元注解Inherited毫无关系，忠实于方法/属性本身的继承。
 *
 * @Author: songlx
 * @Version: 1.0
 */
public class InheritedTest {

    @Target(value = {ElementType.METHOD, ElementType.FIELD})
    @Retention(value = RetentionPolicy.RUNTIME)
    @interface DESC {
        String value() default "";
    }

    class SuperClass {

        @DESC("父类方法foo")
        public void foo() {}

        @DESC("父类方法bar")
        public void bar(){}

        @DESC("父类的属性")
        public String field;
    }

    class ChildClass extends SuperClass {

        @Override
        public void foo() {
            super.foo();
        }

    }

    public static void main(String[] args) throws NoSuchMethodException, NoSuchFieldException {
        Method foo = ChildClass.class.getMethod("foo");
        System.out.println(Arrays.toString(foo.getAnnotations()));
        // output: []
        // 子类ChildClass重写了父类方法foo,并且@Override注解只在源码阶段保留，所以没有任何注解

        Method bar = ChildClass.class.getMethod("bar");
        System.out.println(Arrays.toString(bar.getAnnotations()));
        // output: [@annotations.InheritedTest$DESC(value=父类方法bar)]
        // bar方法未被子类重写，从父类继承到了原本注解

        //获取一个类的public成员变量
        Field field = ChildClass.class.getField("field");
        System.out.println(Arrays.toString(field.getAnnotations()));
    }
    // output: [@annotations.InheritedTest$DESC(value=父类的属性)]
    // 解释同上
}
