package com.ejianc.business.study.service.impl;

import com.ejianc.business.study.annotation.MyAutowired;
import com.ejianc.business.study.annotation.MyService;
import com.ejianc.business.study.service.IOrderService;
import com.ejianc.business.study.service.IUserService;

/**
 * UserService
 *
 * @Author: songlx
 * @Version: 1.0
 */
@MyService
public class UserServiceImpl implements IUserService {

    @MyAutowired
    private IOrderService orderService;

    /**
     * 下单
     *
     * @Param orderName: 订单名字
     * @Return void
     * @Author songlx
     * @Date 2021-03-23
     */
    @Override
    public void placeOrder(String orderName) {
        System.out.println("顾客开始下单<" + orderName + ">......");
        orderService.createOrder(orderName);
    }
}
