package com.ejianc.business.study.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

/**
 * ClazzUtil
 *
 * @Author: songlx
 * @Version: 1.0
 */
public class ClazzUtil {


    /**
     * 返回指定包名下的所有Class对象
     *
     * @param packageName
     * @return
     */
    public static List<Class<?>> getClasses(String packageName) throws IOException, ClassNotFoundException {
        //获取类加载器对象，以便读取类路径下的资源
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String path = packageName.replace(".", "/");
        //获取指定类路径下的目录
        Enumeration<URL> resources = classLoader.getResources(path);
        List<File> dirList = new ArrayList<>();
        //将获取的目录逐一保存在集合中
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            String utfPath =
                    URLDecoder.decode(resource.getPath(), "UTF-8");
            dirList.add(new File(utfPath));
        }
        List<Class<?>> classList = new ArrayList<>();
        for (File dir : dirList) {
            classList.addAll(findClass(dir, packageName));
        }
        return classList;
    }

    /**
     * 获取指定目录下的所有Class
     *
     * @param dir
     * @param packageName
     * @return
     */
    private static List<Class<?>> findClass(File dir, String packageName) throws ClassNotFoundException {
        List<Class<?>> classList = new ArrayList<>();
        if (!dir.exists()) {
            System.err.println(dir.getName() + "不存在！");
            return classList;
        }
        File[] files = dir.listFiles();
        for (File file : files) {
            if (file.isDirectory()) {
                //递归读取当前目录下所有的class
                List<Class<?>> fileList =
                        findClass(file, packageName + "." + file.getName());
                classList.addAll(fileList);
            } else if (file.getName().endsWith(".class")) {
                //最后一个 . 符号的位置
                int lastIndex = file.getName().lastIndexOf(".");
                Class<?> clazz = Class.forName(
                        packageName + "."
                                + file.getName().substring(0, lastIndex));
                classList.add(clazz);
            }
        }
        return classList;
    }
}
