package com.ejianc.business.train.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.train.bean.TrainDemoEntity;
import com.ejianc.business.train.service.ITrainDemoService;
import com.ejianc.business.train.vo.TrainDemoVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 培训主表
 *
 * @author generator
 */
@Controller
@RequestMapping("trainDemo")
public class TrainDemoController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ITrainDemoService service;

    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String billCodeRule = "PX_DEMO_CODE";

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TrainDemoVO> saveOrUpdate(@RequestBody TrainDemoVO saveorUpdateVO) {
        System.out.println("----------------------");
        System.out.println(saveorUpdateVO.getSupplierId());
        CommonResponse<String> codeBatchByRuleCode = billCodeApi.getCodeBatchByRuleCode(billCodeRule, InvocationInfoProxy.getTenantid());
        if (StringUtils.isEmpty(saveorUpdateVO.getBillCode()) && codeBatchByRuleCode.isSuccess()) {
            saveorUpdateVO.setBillCode(codeBatchByRuleCode.getData());
        }
        TrainDemoEntity entity = BeanMapper.map(saveorUpdateVO, TrainDemoEntity.class);
        service.saveOrUpdate(entity, false);
        TrainDemoVO vo = BeanMapper.map(entity, TrainDemoVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<TrainDemoVO> queryDetail(Long id) {
        TrainDemoEntity entity = service.selectById(id);
        TrainDemoVO vo = BeanMapper.map(entity, TrainDemoVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TrainDemoVO> vos) {
        service.removeByIds(vos.stream().map(TrainDemoVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TrainDemoVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        param.setFuzzyFields(Arrays.asList("orgName", "billCode", "contractName", "supplierName", "employeeName"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<TrainDemoEntity> page = service.queryPage(param, false);
        IPage<TrainDemoVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), TrainDemoVO.class));
        System.out.println("--------------------");
        System.out.println(pageData.getTotal());
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    @PostMapping("excelExport")
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        service.excelExport(param,response);
    }

}
