package com.ejianc.business.train.controller.cph;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.train.bean.cph.TrainDemoCphEntity;
import com.ejianc.business.train.service.cph.ITrainDemoCphService;
import com.ejianc.business.train.vo.cph.TrainDemoCphVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 培训主表(曹鹏辉)
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("trainDemoCph")
public class TrainDemoCphController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private ITrainDemoCphService service;

    @Autowired
    private IBillCodeApi billCodeApi;

    /**
     * 自己定义的单据编码规则(登录平台 -> 左侧菜单支撑中心 -> 新增单据编码规则)
     */
    private static final String billCodeRule = "CPH_DEMO_CODE";


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TrainDemoCphVO> saveOrUpdate(@RequestBody TrainDemoCphVO saveorUpdateVO) {
        // 零工单号配置
        CommonResponse<String> codeBatchByRuleCode = billCodeApi.getCodeBatchByRuleCode(billCodeRule, InvocationInfoProxy.getTenantid());
        if (StringUtils.isEmpty(saveorUpdateVO.getBillCode()) && codeBatchByRuleCode.isSuccess()) {
            saveorUpdateVO.setBillCode(codeBatchByRuleCode.getData());
        }

        TrainDemoCphEntity entity = BeanMapper.map(saveorUpdateVO, TrainDemoCphEntity.class);
    	service.saveOrUpdate(entity, false);
    	TrainDemoCphVO vo = BeanMapper.map(entity, TrainDemoCphVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<TrainDemoCphVO> queryDetail(Long id) {
    	TrainDemoCphEntity entity = service.selectById(id);
    	TrainDemoCphVO vo = BeanMapper.map(entity, TrainDemoCphVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TrainDemoCphVO> vos) {
        service.removeByIds(vos.stream().map(TrainDemoCphVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TrainDemoCphVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        param.setFuzzyFields(Arrays.asList("orgName", "billCode", "contractName", "supplierName", "employeeName"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        
        IPage<TrainDemoCphEntity> page = service.queryPage(param,false);
        IPage<TrainDemoCphVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), TrainDemoCphVO.class));
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 表格导出
     * @param param
     * @param response
     */
    @PostMapping("excelExport")
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        service.excelExport(param,response);
    }
}
