package com.ejianc.business.train.controller.cqw;

import java.io.Serializable;

import com.ejianc.foundation.support.api.IBillCodeApi;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.List;
import java.util.stream.Collectors;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.train.bean.cqw.TrainDemoCqwEntity;
import com.ejianc.business.train.service.cqw.ITrainDemoCqwService;
import com.ejianc.business.train.vo.cqw.TrainDemoCqwVO;

import javax.servlet.http.HttpServletResponse;

/**
 * 培训主表(曹庆伟)
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("trainDemoCqw")
public class TrainDemoCqwController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private ITrainDemoCqwService service;

    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String billCodeRule = "PX_CAO_CODE";
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TrainDemoCqwVO> saveOrUpdate(@RequestBody TrainDemoCqwVO saveorUpdateVO) {
        CommonResponse<String> codeBatchByRuleCode = billCodeApi.getCodeBatchByRuleCode(billCodeRule, InvocationInfoProxy.getTenantid());
        if (StringUtils.isEmpty(saveorUpdateVO.getBillCode()) && codeBatchByRuleCode.isSuccess()) {
            saveorUpdateVO.setBillCode(codeBatchByRuleCode.getData());
        }
    	TrainDemoCqwEntity entity = BeanMapper.map(saveorUpdateVO, TrainDemoCqwEntity.class);
    	service.saveOrUpdate(entity, false);
    	TrainDemoCqwVO vo = BeanMapper.map(entity, TrainDemoCqwVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<TrainDemoCqwVO> queryDetail(Long id) {
    	TrainDemoCqwEntity entity = service.selectById(id);
    	TrainDemoCqwVO vo = BeanMapper.map(entity, TrainDemoCqwVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TrainDemoCqwVO> vos) {
        service.removeByIds(vos.stream().map(TrainDemoCqwVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TrainDemoCqwVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        
        IPage<TrainDemoCqwEntity> page = service.queryPage(param,false);
        IPage<TrainDemoCqwVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), TrainDemoCqwVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 导出
     * @Param param: 参数
     * @Param response:
     * @Return void
     * @Author songlx
     * @Date 2021-03-12
     **/
    @PostMapping("excelExport")
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        service.excelExport(param,response);
    }

}
