package com.ejianc.business.train.service.impl.cqwimpl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.train.bean.TrainDemoEntity;
import com.ejianc.business.train.vo.TrainDemoVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.train.mapper.cqw.TrainDemoCqwMapper;
import com.ejianc.business.train.bean.cqw.TrainDemoCqwEntity;
import com.ejianc.business.train.service.cqw.ITrainDemoCqwService;

import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 培训主表(曹庆伟)
 * 
 * @author generator
 * 
 */
@Service("trainDemoCqwService")
public class TrainDemoCqwServiceImpl extends BaseServiceImpl<TrainDemoCqwMapper, TrainDemoCqwEntity> implements ITrainDemoCqwService{
    @Override
    public void excelExport(QueryParam param, HttpServletResponse response) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(10000);
        IPage<TrainDemoCqwEntity> pageData = queryPage(param, false);

        Map<String, Object> beans = new HashMap<String, Object>();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty(pageData.getRecords())) {
            List<TrainDemoVO> list = BeanMapper.mapList(pageData.getRecords(), TrainDemoVO.class);
            list.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            });
            beans.put("records", list);
            ExcelExport.getInstance().export("train-cqwDemo.xlsx", beans, response);
        }
    }
}
