package com.ejianc.business.train.vo;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.train.vo.TrainDemoContentVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 培训主表
 * 
 * @author generator
 * 
 */
public class TrainDemoVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private java.lang.Long contractId; // 合同ID
    private java.lang.String billCode; // 零工单号
    private java.lang.String contractName; // 合同名称
    private java.lang.Long contractType; // 分包类型
    private java.lang.Long jobType; // 用工类型
    private java.lang.Long projectId; // 项目
    private java.lang.String projectName; // 项目名称
    private java.lang.Long orgId; // 组织
    private java.lang.String orgName; // 组织名称
    private java.lang.Long employeeId; // 经办人
    private java.lang.String employeeName; // 经办人名称
    private java.lang.Long supplierId; // 分包供应商
    private java.lang.String supplierName; // 分包供应商名称
    /**
     * 开始日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date beginDate;

    /**
     * 结束日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate;
    private java.lang.Long partUsed; // 使用部位
    private java.math.BigDecimal jobMny; // 零工总金额
    private java.math.BigDecimal jobTaxMny; // 零工总金额（含税）
    private java.lang.String roundup; // 用工摘要
    private java.lang.String beforeUrls; // 用工前图片
    private java.lang.String afterUrls; // 用工后图片
    private java.lang.Integer billState; // 单据状态（审批必须字段）
    private Boolean settleFlag; // 结算标识
    private java.math.BigDecimal oddjobSettleTaxMny; // 零工结算金额（含税）

    private String billStateName;


    private List<TrainDemoContentVO> trainDemoContentList = new ArrayList<>(); // 培训子表实体


    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    @ReferSerialTransfer(referCode="sub-contract-register")
    public Long getContractId() {
        return contractId;
    }

    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getContractType() {
        return contractType;
    }

    @ReferDeserialTransfer
    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getJobType() {
        return jobType;
    }

    @ReferDeserialTransfer
    public void setJobType(Long jobType) {
        this.jobType = jobType;
    }
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Date getBeginDate() {
        return beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getPartUsed() {
        return partUsed;
    }

    @ReferDeserialTransfer
    public void setPartUsed(Long partUsed) {
        this.partUsed = partUsed;
    }
    public BigDecimal getJobMny() {
        return jobMny;
    }



    /**
     * 零工总金额
     */
    public void setJobMny(java.math.BigDecimal jobMny) {
        this.jobMny = jobMny;
    }
    /**
     * 零工总金额（含税）
     */
    public java.math.BigDecimal getJobTaxMny() {
        return jobTaxMny;
    }

    /**
     * 零工总金额（含税）
     */
    public void setJobTaxMny(java.math.BigDecimal jobTaxMny) {
        this.jobTaxMny = jobTaxMny;
    }
    /**
     * 用工摘要
     */
    public java.lang.String getRoundup() {
        return roundup;
    }

    /**
     * 用工摘要
     */
    public void setRoundup(java.lang.String roundup) {
        this.roundup = roundup;
    }
    /**
     * 用工前图片
     */
    public java.lang.String getBeforeUrls() {
        return beforeUrls;
    }

    /**
     * 用工前图片
     */
    public void setBeforeUrls(java.lang.String beforeUrls) {
        this.beforeUrls = beforeUrls;
    }
    /**
     * 用工后图片
     */
    public java.lang.String getAfterUrls() {
        return afterUrls;
    }

    /**
     * 用工后图片
     */
    public void setAfterUrls(java.lang.String afterUrls) {
        this.afterUrls = afterUrls;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }
    public Boolean getSettleFlag() {
        return settleFlag;
    }

    public void setSettleFlag(Boolean settleFlag) {
        this.settleFlag = settleFlag;
    }

    /**
     * 零工结算金额（含税）
     */
    public java.math.BigDecimal getOddjobSettleTaxMny() {
        return oddjobSettleTaxMny;
    }

    /**
     * 零工结算金额（含税）
     */
    public void setOddjobSettleTaxMny(java.math.BigDecimal oddjobSettleTaxMny) {
        this.oddjobSettleTaxMny = oddjobSettleTaxMny;
    }

    public List<TrainDemoContentVO> getTrainDemoContentList() {
        return trainDemoContentList;
    }

    public void setTrainDemoContentList(List<TrainDemoContentVO> trainDemoContentList) {
        this.trainDemoContentList = trainDemoContentList;
    }
}
