/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.capital.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.capital.bean.CapitalCollectionRegistrationEntity;
import com.ejianc.business.capital.service.ICapitalCollectionRegistrationService;
import com.ejianc.business.capital.vo.CapitalCollectionRegistrationSubVO;
import com.ejianc.business.capital.vo.CapitalCollectionRegistrationVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"capital"})
public class CapitalCollectionRegistrationController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;
    private static final String BILL_CODE = "capital_code";
    @Autowired
    private ICapitalCollectionRegistrationService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CapitalCollectionRegistrationVO> saveOrUpdate(@RequestBody CapitalCollectionRegistrationVO saveorUpdateVO) {
        CapitalCollectionRegistrationEntity entity = (CapitalCollectionRegistrationEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), CapitalCollectionRegistrationEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setApplyOrgName(this.sessionManager.getUserContext().getOrgName());
        entity.setCommitUserName(this.sessionManager.getUserContext().getUserName());
        entity.setCommitDate(new Date());
        entity.setCommitUserCode(this.sessionManager.getUserContext().getUserCode());
        String totalContributor = "";
        List<CapitalCollectionRegistrationSubVO> subList = saveorUpdateVO.getCapitalCollectionRegistrationSubList();
        for (CapitalCollectionRegistrationSubVO cr : subList) {
            if (!StringUtils.isBlank((CharSequence)totalContributor)) {
                totalContributor = totalContributor + "," + cr.getContributor();
                continue;
            }
            totalContributor = totalContributor + cr.getContributor();
        }
        entity.setTotalContributor(totalContributor);
        entity.setModifyUserName(this.sessionManager.getUserContext().getUserName());
        this.service.saveOrUpdate((Object)entity, false);
        CapitalCollectionRegistrationVO vo = (CapitalCollectionRegistrationVO)((Object)BeanMapper.map((Object)((Object)entity), CapitalCollectionRegistrationVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CapitalCollectionRegistrationVO> queryDetail(Long id) {
        CapitalCollectionRegistrationEntity entity = (CapitalCollectionRegistrationEntity)((Object)this.service.selectById(id));
        CapitalCollectionRegistrationVO vo = (CapitalCollectionRegistrationVO)((Object)BeanMapper.map((Object)((Object)entity), CapitalCollectionRegistrationVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CapitalCollectionRegistrationVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CapitalCollectionRegistrationVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("applyOrgName");
        fuzzyFields.add("totalContributor");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CapitalCollectionRegistrationVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getFuzzyFields().add("id");
        param.setPageIndex(1);
        param.setPageSize(10000);
        List list = this.service.queryList(param);
        ArrayList voList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            list.forEach(capitalList -> {
                CapitalCollectionRegistrationVO r = (CapitalCollectionRegistrationVO)((Object)((Object)BeanMapper.map((Object)capitalList, CapitalCollectionRegistrationVO.class)));
                r.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)r.getBillState()).getDescription());
                voList.add(r);
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", voList);
        ExcelExport.getInstance().export("capitalCollectionRegister-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refCapitalCollectionRegistrationData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CapitalCollectionRegistrationVO>> refCapitalCollectionRegistrationData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CapitalCollectionRegistrationVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"/downloadImportTemplate"})
    public void downloadImportTemplate(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"capitalCollectionRegister-import.xlsx", (String)"\u8d44\u672c\u91d1\u6536\u6b3e\u767b\u8bb0");
    }

    @PostMapping(value={"capitalExcelImport"})
    @ResponseBody
    public CommonResponse<JSONObject> capitalExcelImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        ArrayList<JSONObject> successList = new ArrayList<JSONObject>();
        ArrayList<JSONObject> errorList = new ArrayList<JSONObject>();
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u6570\u636e\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            Object parentEntity = null;
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                JSONObject capital = new JSONObject();
                capital.put("id", (Object)IdWorker.getId());
                capital.put("code", datas.get(0));
                capital.put("applyOrgName", datas.get(1));
                capital.put("registerOrgName", datas.get(2));
                capital.put("totalContributor", datas.get(3));
                capital.put("commitUserName", datas.get(4));
                capital.put("billStateName", datas.get(5));
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    capital.put("err", (Object)"\u5355\u636e\u7f16\u53f7\u4e3a\u7a7a\uff01");
                    errorList.add(capital);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    capital.put("err", (Object)"\u7533\u8bf7\u7ec4\u7ec7\u540d\u79f0\u540d\u79f0\u4e3a\u7a7a\uff01");
                    errorList.add(capital);
                    continue;
                }
                if (((String)datas.get(0)).length() > 50) {
                    capital.put("err", (Object)"\u5355\u636e\u7f16\u53f7\u4e3a\u7a7a\u957f\u5ea6\u9650\u5236\u4e3a50\u5b57\u4ee5\u5185\uff01");
                    errorList.add(capital);
                    continue;
                }
                if (((String)datas.get(1)).length() > 200) {
                    capital.put("err", (Object)"\u7533\u8bf7\u7ec4\u7ec7\u540d\u79f0\u540d\u79f0\u957f\u5ea6\u9650\u5236\u4e3a200\u5b57\u4ee5\u5185\uff01");
                    errorList.add(capital);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    capital.put("err", (Object)"\u767b\u8bb0\u7ec4\u7ec7\u540d\u79f0\u540d\u79f0\u4e3a\u7a7a\uff01");
                    errorList.add(capital);
                    continue;
                }
                if (((String)datas.get(2)).length() > 200) {
                    capital.put("err", (Object)"\u767b\u8bb0\u7ec4\u7ec7\u540d\u79f0\u957f\u5ea6\u9650\u5236\u4e3a50\u5b57\u4ee5\u5185\uff01");
                    errorList.add(capital);
                    continue;
                }
                if (((String)datas.get(3)).length() > 200) {
                    capital.put("err", (Object)"\u51fa\u8d44\u4eba\u540d\u79f0\u957f\u5ea6\u9650\u5236\u4e3a200\u5b57\u4ee5\u5185\uff01");
                    errorList.add(capital);
                    continue;
                }
                if (((String)datas.get(4)).length() > 50) {
                    capital.put("err", (Object)"\u767b\u8bb0\u4eba\u957f\u5ea6\u9650\u5236\u4e3a50\u5b57\u4ee5\u5185\uff01");
                    errorList.add(capital);
                    continue;
                }
                if (((String)datas.get(5)).length() > 50) {
                    capital.put("err", (Object)"\u5355\u636e\u72b6\u6001\u957f\u5ea6\u9650\u5236\u4e3a50\u5b57\u4ee5\u5185\uff01");
                    errorList.add(capital);
                    continue;
                }
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("code", new Parameter("eq", capital.get((Object)"code")));
                List list = this.service.queryList(queryParam, false);
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    capital.put("err", (Object)"\u5355\u636e\u7f16\u53f7\u91cd\u590d\uff01");
                    errorList.add(capital);
                    continue;
                }
                successList.add(capital);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @PostMapping(value={"/saveCapitalExcelImport"})
    @ResponseBody
    public CommonResponse<String> saveCapitalExcelImport(@RequestBody List<JSONObject> importData) {
        if (ListUtil.isEmpty(importData)) {
            return CommonResponse.error((String)"\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        List saveData = BeanMapper.mapList(importData, CapitalCollectionRegistrationEntity.class);
        this.service.saveOrUpdateBatch(saveData, saveData.size(), false);
        return CommonResponse.success((String)"\u5bfc\u5165\u6210\u529f\uff01");
    }
}

