/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.capital.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.capital.bean.MumuReceiptRegistrationEntity;
import com.ejianc.business.capital.service.IMumuReceiptRegistrationService;
import com.ejianc.business.capital.vo.MumuReceiptRegistrationVO;
import com.ejianc.business.capital.vo.MumuReceiptregistrationSubVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"mumuReceiptRegistration"})
public class MumuReceiptRegistrationController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;
    private static final String BILL_CODE = "LJL-DEMO-CODE";
    @Autowired
    private IMumuReceiptRegistrationService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MumuReceiptRegistrationVO> saveOrUpdate(@RequestBody MumuReceiptRegistrationVO saveorUpdateVO) {
        MumuReceiptRegistrationEntity entity = (MumuReceiptRegistrationEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), MumuReceiptRegistrationEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                String data = (String)billCode.getData();
                entity.setCode(data);
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        UserContext userContext = this.sessionManager.getUserContext();
        entity.setRegisterCapital(saveorUpdateVO.getRegisterCapital());
        entity.setApplyOrgName(userContext.getOrgName());
        entity.setRegistrantName(userContext.getUserName());
        BigDecimal totalAmount = new BigDecimal(0);
        ArrayList<String> list = new ArrayList<String>();
        for (MumuReceiptregistrationSubVO s : saveorUpdateVO.getMumuReceiptregistrationSubEntities()) {
            totalAmount = totalAmount.add(s.getApplyMoney());
            if (StringUtils.isBlank((CharSequence)s.getFinancingPartyName())) continue;
            list.add(s.getFinancingPartyName());
        }
        entity.setTotalActualPayment(totalAmount);
        entity.setInvestorName(String.join((CharSequence)",", list));
        this.service.saveOrUpdate((Object)entity, false);
        MumuReceiptRegistrationVO vo = (MumuReceiptRegistrationVO)((Object)BeanMapper.map((Object)((Object)entity), MumuReceiptRegistrationVO.class));
        vo.setTotalActualPayment(totalAmount);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MumuReceiptRegistrationVO> queryDetail(Long id) {
        MumuReceiptRegistrationEntity entity = (MumuReceiptRegistrationEntity)((Object)this.service.selectById(id));
        MumuReceiptRegistrationVO vo = (MumuReceiptRegistrationVO)((Object)BeanMapper.map((Object)((Object)entity), MumuReceiptRegistrationVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MumuReceiptRegistrationVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MumuReceiptRegistrationVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("applyOrgName");
        fuzzyFields.add("investorName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MumuReceiptRegistrationVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage pagedata = this.service.queryPage(param, false);
        if (CollectionUtils.isNotEmpty((Collection)pagedata.getRecords())) {
            List list = BeanMapper.mapList((Iterable)pagedata.getRecords(), MumuReceiptRegistrationVO.class);
            list.forEach(vo -> vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription()));
            HashMap<String, List> beans = new HashMap<String, List>(list.size());
            beans.put("records", list);
            ExcelExport.getInstance().export("CapitalReceiptRegistration-export.xlsx", beans, response);
        }
    }

    @RequestMapping(value={"/refMumuReceiptRegistrationData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MumuReceiptRegistrationVO>> refMumuReceiptRegistrationData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MumuReceiptRegistrationVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"saveImportTemplate"})
    @ResponseBody
    public CommonResponse<String> saveImportTemplate(@RequestBody List<JSONObject> importData) {
        if (ListUtil.isEmpty(importData)) {
            return CommonResponse.error((String)"\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        List saveData = BeanMapper.mapList(importData, MumuReceiptRegistrationEntity.class);
        this.service.saveOrUpdateBatch(saveData, saveData.size(), false);
        return CommonResponse.success((String)"\u5bfc\u5165\u6210\u529f\uff01");
    }

    @PostMapping(value={"/downImportTemplate"})
    public void downImportTemplate(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"CapitalReceiptRegistration-import.xlsx", (String)"\u8d44\u672c\u91d1\u5bfc\u5165\u6a21\u677f");
    }

    @PostMapping(value={"checkImportTemplate"})
    @ResponseBody
    public CommonResponse<JSONObject> checkImportTemplate(HttpServletRequest request) {
        ArrayList<JSONObject> successList = new ArrayList<JSONObject>();
        ArrayList<JSONObject> errorList = new ArrayList<JSONObject>();
        MultipartHttpServletRequest multipartHttpServletRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartHttpServletRequest.getFileMap();
        MultipartFile multipartFile = null;
        Object fileName = null;
        boolean isFailed = false;
        for (Map.Entry entity : fileMap.entrySet()) {
            multipartFile = (MultipartFile)entity.getValue();
            String originalFileName = multipartFile.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(multipartFile);
        if (result != null && result.size() > 0) {
            this.logger.debug(String.valueOf(result.size()));
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u6570\u636e\u8d85\u8fc710000\u6761 \u8bf7\u91cd\u65b0\u4e0a\u4f20");
            }
            for (List datas : result) {
                JSONObject capital = new JSONObject();
                capital.put("id", (Object)IdWorker.getId());
                capital.put("applyOrgName", datas.get(0));
                capital.put("registeredOrgName", datas.get(1));
                capital.put("investorName", datas.get(2));
                capital.put("registrantName", datas.get(3));
                capital.put("code", datas.get(4));
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    capital.put("err", (Object)"\u7533\u8bf7\u7ec4\u7ec7\u540d\u79f0\u4e3a\u7a7a\uff01");
                    errorList.add(capital);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    capital.put("err", (Object)"\u767b\u8bb0\u7ec4\u7ec7\u540d\u79f0\u4e3a\u7a7a\uff01");
                    errorList.add(capital);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    capital.put("err", (Object)"\u51fa\u8d44\u4eba\u540d\u79f0\u4e3a\u7a7a\uff01");
                    errorList.add(capital);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(3)))) {
                    capital.put("err", (Object)"\u767b\u8bb0\u4eba\u540d\u79f0\u4e3a\u7a7a\uff01");
                    errorList.add(capital);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(4)))) {
                    capital.put("err", (Object)"\u5355\u636e\u7f16\u53f7\u4e3a\u7a7a\uff01");
                    errorList.add(capital);
                    continue;
                }
                if (((String)datas.get(0)).length() > 100) {
                    capital.put("err", (Object)"\u7533\u8bf7\u7ec4\u7ec7\u540d\u79f0\u957f\u5ea6\u9650\u5236\u4e3a100\u5b57\u4ee5\u5185\uff01");
                    errorList.add(capital);
                    continue;
                }
                if (((String)datas.get(1)).length() > 100) {
                    capital.put("err", (Object)"\u767b\u8bb0\u7ec4\u7ec7\u540d\u79f0\u957f\u5ea6\u9650\u5236\u4e3a100\u5b57\u4ee5\u5185\uff01");
                    errorList.add(capital);
                    continue;
                }
                if (((String)datas.get(2)).length() > 100) {
                    capital.put("err", (Object)"\u51fa\u8d44\u4eba\u957f\u5ea6\u9650\u5236\u4e3a100\u5b57\u4ee5\u5185\uff01");
                    errorList.add(capital);
                    continue;
                }
                if (((String)datas.get(3)).length() > 100) {
                    capital.put("err", (Object)"\u767b\u8bb0\u4eba\u957f\u5ea6\u9650\u5236\u4e3a100\u5b57\u4ee5\u5185\uff01");
                    errorList.add(capital);
                    continue;
                }
                if (((String)datas.get(4)).length() > 64) {
                    capital.put("err", (Object)"\u5355\u636e\u7f16\u53f7\u957f\u5ea6\u9650\u5236\u4e3a64\u5b57\u4ee5\u5185\uff01");
                    errorList.add(capital);
                }
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("code", new Parameter("eq", capital.get((Object)"code")));
                List list = this.service.queryList(queryParam, false);
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    capital.put("err", (Object)"\u5355\u636e\u7f16\u53f7\u91cd\u590d\uff01");
                    errorList.add(capital);
                    continue;
                }
                capital.put("status", (Object)MumuReceiptRegistrationVO.STATUS_VALID);
                successList.add(capital);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }
}

