/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.study.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class ClazzUtil {
    public static List<Class<?>> getClasses(String packageName) throws IOException, ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String path = packageName.replace(".", "/");
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirList = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            String utfPath = URLDecoder.decode(resource.getPath(), "UTF-8");
            dirList.add(new File(utfPath));
        }
        ArrayList classList = new ArrayList();
        for (File dir : dirList) {
            classList.addAll(ClazzUtil.findClass(dir, packageName));
        }
        return classList;
    }

    private static List<Class<?>> findClass(File dir, String packageName) throws ClassNotFoundException {
        File[] files;
        ArrayList classList = new ArrayList();
        if (!dir.exists()) {
            System.err.println(dir.getName() + "\u4e0d\u5b58\u5728\uff01");
            return classList;
        }
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                List<Class<?>> fileList = ClazzUtil.findClass(file, packageName + "." + file.getName());
                classList.addAll(fileList);
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            int lastIndex = file.getName().lastIndexOf(".");
            Class<?> clazz = Class.forName(packageName + "." + file.getName().substring(0, lastIndex));
            classList.add(clazz);
        }
        return classList;
    }
}

