/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.train.controller.cph;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.train.bean.cph.TrainDemoCphEntity;
import com.ejianc.business.train.service.cph.ITrainDemoCphService;
import com.ejianc.business.train.vo.cph.TrainDemoCphVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"trainDemoCph"})
public class TrainDemoCphController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ITrainDemoCphService service;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String billCodeRule = "CPH_DEMO_CODE";

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TrainDemoCphVO> saveOrUpdate(@RequestBody TrainDemoCphVO saveorUpdateVO) {
        CommonResponse codeBatchByRuleCode = this.billCodeApi.getCodeBatchByRuleCode(billCodeRule, InvocationInfoProxy.getTenantid());
        if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getBillCode()) && codeBatchByRuleCode.isSuccess()) {
            saveorUpdateVO.setBillCode((String)codeBatchByRuleCode.getData());
        }
        TrainDemoCphEntity entity = (TrainDemoCphEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), TrainDemoCphEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        TrainDemoCphVO vo = (TrainDemoCphVO)((Object)BeanMapper.map((Object)((Object)entity), TrainDemoCphVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<TrainDemoCphVO> queryDetail(Long id) {
        TrainDemoCphEntity entity = (TrainDemoCphEntity)((Object)this.service.selectById(id));
        TrainDemoCphVO vo = (TrainDemoCphVO)((Object)BeanMapper.map((Object)((Object)entity), TrainDemoCphVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TrainDemoCphVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TrainDemoCphVO>> queryList(@RequestBody QueryParam param) {
        param.setFuzzyFields(Arrays.asList("orgName", "billCode", "contractName", "supplierName", "employeeName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TrainDemoCphVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"excelExport"})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        this.service.excelExport(param, response);
    }
}

