package com.ejianc.business.vehiclemanagement.task.api;

import com.ejianc.business.vehiclemanagement.task.hystrix.VehicleTypeHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * @authoer:禹鹏杰
 * @createDate:2022/8/22
 * @description:
 */
@FeignClient(name= "ejc-vehiclemanagement-web", url="${common.env.feign-client-url}", path="ejc-vehiclemanagement-web", fallback = VehicleTypeHystrix.class)
public interface IVehicleTypeApi {

    /**
     * 根据id修改车辆状态
     * @param
     * @return
     */
    @GetMapping(value = "/no_auth/api/base/VehicleTypeApi/updateVehicleStatus")
    @ResponseBody
    CommonResponse updateVehicleStatus(@RequestParam("vehicleId") Long vehicleId, @RequestParam("status") Integer status);



}
