package com.ejianc.business.vehiclemanagement.task.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 分配机组
 * 
 * @author generator
 * 
 */
public class VehicleInfoVO extends BaseVO {
    private static final long serialVersionUID = 1L;


    private String name; // 车牌号
    private String vehicleType; // 车辆类型
    private Long vehicleTypeId; // 车辆类型
    private Long defaultdriverId; // 默认司机id
    private String defaultdriverName; // 默认司机
    private Double payload; // 载重（载重量）
    private Long transportationId; // 运输公司id
    private String transportationName; // 运输公司名称
    private Long motorcadeId; // 所属车队id
    private String motorcadeName; // 所属车队编号
    private String factoryName; // 所属厂区名称
    private String vehicleClassification; // 车辆大类


    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVehicleType() {
        return vehicleType;
    }

    public void setVehicleType(String vehicleType) {
        this.vehicleType = vehicleType;
    }

    @ReferSerialTransfer(referCode="VehicletypeRef")
    public Long getVehicleTypeId() {
        return vehicleTypeId;
    }

    @ReferDeserialTransfer
    public void setVehicleTypeId(Long vehicleTypeId) {
        this.vehicleTypeId = vehicleTypeId;
    }

    @ReferSerialTransfer(referCode="DriverRef")
    public Long getDefaultdriverId() {
        return defaultdriverId;
    }

    @ReferDeserialTransfer
    public void setDefaultdriverId(Long defaultdriverId) {
        this.defaultdriverId = defaultdriverId;
    }

    public String getDefaultdriverName() {
        return defaultdriverName;
    }

    public void setDefaultdriverName(String defaultdriverName) {
        this.defaultdriverName = defaultdriverName;
    }

    public Double getPayload() {
        return payload;
    }

    public void setPayload(Double payload) {
        this.payload = payload;
    }

    public Long getTransportationId() {
        return transportationId;
    }

    public void setTransportationId(Long transportationId) {
        this.transportationId = transportationId;
    }

    public String getTransportationName() {
        return transportationName;
    }

    public void setTransportationName(String transportationName) {
        this.transportationName = transportationName;
    }

    @ReferSerialTransfer(referCode="MotorcadeRef")
    public Long getMotorcadeId() {
        return motorcadeId;
    }

    @ReferDeserialTransfer
    public void setMotorcadeId(Long motorcadeId) {
        this.motorcadeId = motorcadeId;
    }

    public String getMotorcadeName() {
        return motorcadeName;
    }

    public void setMotorcadeName(String motorcadeName) {
        this.motorcadeName = motorcadeName;
    }

    public String getFactoryName() {
        return factoryName;
    }

    public void setFactoryName(String factoryName) {
        this.factoryName = factoryName;
    }

    public String getVehicleClassification() {
        return vehicleClassification;
    }

    public void setVehicleClassification(String vehicleClassification) {
        this.vehicleClassification = vehicleClassification;
    }
}
