package com.ejianc.business.weigh.wagon.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.weigh.wagon.service.IWagonMaterialService;
import com.ejianc.business.weigh.wagon.vo.WagonMaterialVO;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/wagonMaterial/")
public class WagonMaterialApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IWagonMaterialService service;

    /**
     * 查询项目下材料自动称重设置，本上查询，查询最近的设置
     *
     * @param projectId  项目id
     * @param materialId 材料id
     * @return 查询结果，如果未设置，返回空对象
     */
    @ApiOperation("查询项目下材料自动称重设置，本上查询，查询最近的设置")
    @RequestMapping(value = "/queryMaterialAutomaticWeigh", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WagonMaterialVO> queryMaterialAutomaticWeigh(@RequestParam("projectId") Long projectId,
                                                                       @RequestParam("materialId") Long materialId) {
        logger.info("查询项目下材料自动称重设置，项目id：{}，材料id：{}", projectId, materialId);
        WagonMaterialVO vo = service.queryMaterialAutomaticWeigh(projectId, materialId);
        logger.info("查询项目下材料自动称重设置，查询结果：{}", JSONObject.toJSONString(vo));
        return CommonResponse.success("查询成功", vo);
    }

    /**
     * 查询项目下材料自动称重设置，本上查询，查询最近的设置
     *
     * @param projectId  项目id
     * @param materialIdList 材料id
     * @return 查询结果，如果未设置，返回空对象
     */
    @ApiOperation("查询项目下材料自动称重设置，本上查询，查询最近的设置-集合")
    @RequestMapping(value = "/queryMaterialAutomaticWeighList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<WagonMaterialVO>> queryMaterialAutomaticWeighList(@RequestParam("projectId") Long projectId,
                                                                       @RequestParam("materialIdList")  List<Long> materialIdList) {
        logger.info("查询项目下材料自动称重设置，项目id：{}，材料id：{}", projectId, materialIdList);
        List<WagonMaterialVO> voList = service.queryMaterialAutomaticWeighList(projectId, materialIdList);
        logger.info("查询项目下材料自动称重设置，查询结果：{}", JSONObject.toJSONString(voList));
        return CommonResponse.success("查询成功", voList);
    }
}
