package com.ejianc.business.xmgs.controller;

import java.io.Serializable;

import com.ejianc.business.xmgs.bean.WorkTimeDetailEntity;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.xmgs.bean.WorkTimeEntity;
import com.ejianc.business.xmgs.service.IWorkTimeService;
import com.ejianc.business.xmgs.vo.WorkTimeVO;

/**
 * 工时管理
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("workTime")
public class WorkTimeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IEmployeeApi employeeApi;

    private static final String BILL_CODE = "BILL_CODE_GSGL";//此处需要根据实际修改

    @Autowired
    private IWorkTimeService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WorkTimeVO> saveOrUpdate(@RequestBody WorkTimeVO saveOrUpdateVO) {
    	WorkTimeEntity entity = BeanMapper.map(saveOrUpdateVO, WorkTimeEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            Long orgId = InvocationInfoProxy.getOrgId();
            entity.setOrgId(orgId);
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        String projectName = new String();
        for (WorkTimeDetailEntity workTimeDetailEntity : entity.getWorkTimeDetailList()){
            projectName += workTimeDetailEntity.getProjectName()+"   ";
        }
        entity.setProjectName(projectName);
    	service.saveOrUpdate(entity, false);
    	WorkTimeVO vo = BeanMapper.map(entity, WorkTimeVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WorkTimeVO> queryDetail(Long id) {
    	WorkTimeEntity entity = service.selectById(id);
    	WorkTimeVO vo = BeanMapper.map(entity, WorkTimeVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WorkTimeVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (WorkTimeVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(WorkTimeVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WorkTimeVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("date");
        fuzzyFields.add("fillName");
        fuzzyFields.add("totalWorkTime");
        fuzzyFields.add("memo");
        fuzzyFields.add("projectName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Parameter isMyOrder = param.getParams().get("isMyOrder");
        if(null!=isMyOrder&&isMyOrder.getValue().toString().contains("0")&&isMyOrder.getValue().toString().contains("1")){
            param.getParams().remove("fillId");
        }else if(null!=isMyOrder&&isMyOrder.getValue().toString().contains("0")){
            param.getParams().put("fillId", new Parameter(QueryParam.EQ, Long.valueOf(InvocationInfoProxy.getEmployeeId())));
        }else if(null!=isMyOrder&&isMyOrder.getValue().toString().contains("1")){
            param.getParams().put("fillId", new Parameter(QueryParam.NE, Long.valueOf(InvocationInfoProxy.getEmployeeId())));
        }
        param.getParams().remove("isMyOrder");
        this.setOrgParam("orgId", param);
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<WorkTimeEntity> page = service.queryPage(param,false);
        IPage<WorkTimeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), WorkTimeVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    private void setOrgParam(String key, QueryParam param) {
        Long orgId = InvocationInfoProxy.getOrgId();
        if (null != orgId && orgId > 0) {
            param.getParams().put(key, new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            //移动端没有当前组织，按照当前登录人权限取组织
            CommonResponse<List<OrgVO>> childOrgResp = iOrgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
            if (!childOrgResp.isSuccess()) {
                throw new BusinessException("查询组织信息失败！");
            }
            List<Long> childIds = new ArrayList<>();
            childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put(key, new Parameter(QueryParam.IN, childIds));
            }
        }
    }
    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<WorkTimeEntity> list = service.queryList(param);
        List<WorkTimeVO> vos = new ArrayList<>();
        for(WorkTimeEntity entity : list){
            WorkTimeVO vo = BeanMapper.map(entity, WorkTimeVO.class);
            //变更状态 0未变更 1 已变更
            if(vo.getBillState()!=null){
                if(vo.getBillState()==0){
                    vo.setBillStateName("自由态");
                }
                if(vo.getBillState()==1){
                    vo.setBillStateName("已提交");
                }
                if(vo.getBillState()==2){
                    vo.setBillStateName("审批中");
                }
                if(vo.getBillState()==3){
                    vo.setBillStateName("已通过");
                }
                if(vo.getBillState()==4){
                    vo.setBillStateName("已驳回");
                }
                if(vo.getBillState()==5){
                    vo.setBillStateName("审批中");
                }
            }
            vos.add(vo);
        }
        //List<WorkTimeEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", vos);
        ExcelExport.getInstance().export("WorkTime-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refWorkTimeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<WorkTimeVO>> refWorkTimeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<WorkTimeEntity> page = service.queryPage(param,false);
        IPage<WorkTimeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), WorkTimeVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    //  获取当前登录人手机号
    @RequestMapping(value = "/queryPhone", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryPhone() {
        String mobilePhone = employeeApi.getById(sessionManager.getUserContext().getEmployeeId()).getData().getMobilePhone();
        return CommonResponse.success("查询列表数据成功！",mobilePhone);
    }
}
