/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.xmgs.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.xmgs.bean.WorkTimeDetailEntity;
import com.ejianc.business.xmgs.bean.WorkTimeEntity;
import com.ejianc.business.xmgs.service.IWorkTimeService;
import com.ejianc.business.xmgs.vo.WorkTimeVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"workTime"})
public class WorkTimeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IEmployeeApi employeeApi;
    private static final String BILL_CODE = "BILL_CODE_GSGL";
    @Autowired
    private IWorkTimeService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<WorkTimeVO> saveOrUpdate(@RequestBody WorkTimeVO saveOrUpdateVO) {
        WorkTimeEntity entity = (WorkTimeEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), WorkTimeEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            Long orgId = InvocationInfoProxy.getOrgId();
            entity.setOrgId(orgId);
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        String projectName = new String();
        for (WorkTimeDetailEntity workTimeDetailEntity : entity.getWorkTimeDetailList()) {
            if ("del".equals(workTimeDetailEntity.getRowState())) continue;
            projectName = projectName + workTimeDetailEntity.getProjectName() + "   ";
        }
        entity.setProjectName(projectName);
        this.service.saveOrUpdate((Object)entity, false);
        WorkTimeVO vo = (WorkTimeVO)((Object)BeanMapper.map((Object)((Object)entity), WorkTimeVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WorkTimeVO> queryDetail(Long id) {
        WorkTimeEntity entity = (WorkTimeEntity)((Object)this.service.selectById(id));
        WorkTimeVO vo = (WorkTimeVO)((Object)BeanMapper.map((Object)((Object)entity), WorkTimeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WorkTimeVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (WorkTimeVO workTimeVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<WorkTimeVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("date");
        fuzzyFields.add("fillName");
        fuzzyFields.add("totalWorkTime");
        fuzzyFields.add("memo");
        fuzzyFields.add("projectName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Parameter isMyOrder = (Parameter)param.getParams().get("isMyOrder");
        if (null != isMyOrder && isMyOrder.getValue().toString().contains("0") && isMyOrder.getValue().toString().contains("1")) {
            param.getParams().remove("fillId");
        } else if (null != isMyOrder && isMyOrder.getValue().toString().contains("0")) {
            param.getParams().put("fillId", new Parameter("eq", (Object)Long.valueOf(InvocationInfoProxy.getEmployeeId())));
        } else if (null != isMyOrder && isMyOrder.getValue().toString().contains("1")) {
            param.getParams().put("fillId", new Parameter("ne", (Object)Long.valueOf(InvocationInfoProxy.getEmployeeId())));
        }
        param.getParams().remove("isMyOrder");
        this.setOrgParam("orgId", param);
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WorkTimeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private void setOrgParam(String key, QueryParam param) {
        Long orgId = InvocationInfoProxy.getOrgId();
        if (null != orgId && orgId > 0L) {
            param.getParams().put(key, new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            CommonResponse childOrgResp = this.iOrgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
            if (!childOrgResp.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            ArrayList childIds = new ArrayList();
            childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put(key, new Parameter("in", childIds));
            }
        }
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        Parameter isMyOrder = (Parameter)param.getParams().get("isMyOrder");
        if (null != isMyOrder && isMyOrder.getValue().toString().contains("0") && isMyOrder.getValue().toString().contains("1")) {
            param.getParams().remove("fillId");
        } else if (null != isMyOrder && isMyOrder.getValue().toString().contains("0")) {
            param.getParams().put("fillId", new Parameter("eq", (Object)Long.valueOf(InvocationInfoProxy.getEmployeeId())));
        } else if (null != isMyOrder && isMyOrder.getValue().toString().contains("1")) {
            param.getParams().put("fillId", new Parameter("ne", (Object)Long.valueOf(InvocationInfoProxy.getEmployeeId())));
        }
        param.getParams().remove("isMyOrder");
        List list = this.service.queryList(param);
        ArrayList<WorkTimeVO> vos = new ArrayList<WorkTimeVO>();
        for (WorkTimeEntity entity : list) {
            WorkTimeVO vo = (WorkTimeVO)((Object)BeanMapper.map((Object)((Object)entity), WorkTimeVO.class));
            if (vo.getBillState() != null) {
                if (vo.getBillState() == 0) {
                    vo.setBillStateName("\u81ea\u7531\u6001");
                }
                if (vo.getBillState() == 1) {
                    vo.setBillStateName("\u5df2\u63d0\u4ea4");
                }
                if (vo.getBillState() == 2) {
                    vo.setBillStateName("\u5ba1\u6279\u4e2d");
                }
                if (vo.getBillState() == 3) {
                    vo.setBillStateName("\u5df2\u901a\u8fc7");
                }
                if (vo.getBillState() == 4) {
                    vo.setBillStateName("\u5df2\u9a73\u56de");
                }
                if (vo.getBillState() == 5) {
                    vo.setBillStateName("\u5ba1\u6279\u4e2d");
                }
            }
            vos.add(vo);
        }
        HashMap<String, ArrayList<WorkTimeVO>> beans = new HashMap<String, ArrayList<WorkTimeVO>>();
        beans.put("records", vos);
        ExcelExport.getInstance().export("WorkTime-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refWorkTimeData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<WorkTimeVO>> refWorkTimeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WorkTimeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryPhone"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> queryPhone() {
        String mobilePhone = ((EmployeeVO)this.employeeApi.getById(this.sessionManager.getUserContext().getEmployeeId()).getData()).getMobilePhone();
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)mobilePhone);
    }
}

