/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.xmgs.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.xmgs.bean.WorkTimeEntity;
import com.ejianc.business.xmgs.service.IWorkTimeService;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"warn"})
public class WorkTimeWarnController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IRoleApi roleApi;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IWorkTimeService workTimeService;
    private static final String WX_MSG_ID = "Do0q1JoHifdeXqX1-hty6DjsDY0ZNgD3GRVkFEx5jBI";
    private static final Long WARE_ROLE_ID = 597490353083945018L;
    @Value(value="${common.env.base-host}")
    private String baseHost;

    @RequestMapping(value={"/warnAll"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> warnAll(HttpServletRequest request) {
        ArrayList<Long> roleIdS = new ArrayList<Long>();
        String param = request.getParameter("param");
        JSONArray json = JSONArray.parseArray((String)param);
        this.logger.info("\u83b7\u53d6\u5230\u7684\u53c2\u6570JSON\u662f\uff1a" + param + "----");
        String roleId = null;
        if (json != null) {
            roleId = json.getJSONObject(0).getJSONArray("parameters").getJSONObject(0).getString("value");
        }
        this.logger.info("\u83b7\u53d6\u5230\u7684\u53c2\u6570\u662f\uff1a" + roleId + "----");
        if (StringUtils.isNotBlank((CharSequence)roleId)) {
            roleIdS.add(Long.valueOf(roleId));
        } else {
            roleIdS.add(WARE_ROLE_ID);
        }
        List roleUserRelationVO = (List)this.roleApi.getRoleUser(roleIdS, null).getData();
        if (roleUserRelationVO == null || roleUserRelationVO.size() <= 0) {
            this.logger.info("\u53d1\u9001\u6d88\u606f\u5b8c\u6210,\u5bf9\u5e94\u89d2\u8272\u4e0b\u65e0\u4eba\u5458");
            return CommonResponse.success((String)"\u53d1\u9001\u6d88\u606f\u5b8c\u6210,\u5bf9\u5e94\u89d2\u8272\u4e0b\u65e0\u4eba\u5458");
        }
        ArrayList<String> receivers = new ArrayList<String>();
        for (RoleUserRelationVO vo : roleUserRelationVO) {
            receivers.add(String.valueOf(vo.getUserId()));
        }
        String subject = "\u5c0f\u4f19\u4f34\u4eec\uff0c\u8f9b\u82e6\u4e86\u4e00\u5929\uff0c\u53ca\u65f6\u603b\u7ed3\u4e00\u4e0b\u5427^_^";
        String content = subject + "\u3002<a href=" + '\"' + this.getPcUrl() + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
        this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff01===========");
        PushMsgParameter parameter = new PushMsgParameter();
        ArrayList<String> channel = new ArrayList<String>();
        channel.add("sys");
        channel.add("weixin");
        JSONObject weixinParams = new JSONObject();
        weixinParams.put("template_id", (Object)WX_MSG_ID);
        JSONObject wxparams = new JSONObject();
        wxparams.put("first", (Object)subject);
        wxparams.put("keyword1", (Object)"\u5de5\u65f6\u586b\u62a5");
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        wxparams.put("keyword2", (Object)formatter.format(new Date()));
        wxparams.put("remark", (Object)"\u70b9\u51fb\u6211\uff0c\u5feb\u901f\u53bb\u586b\u62a5\u5de5\u65f6\uff01");
        weixinParams.put("data", (Object)wxparams);
        weixinParams.put("url", (Object)(this.getMbUrl() + "?openid={openid}"));
        parameter.setWeixinParams(weixinParams);
        parameter.setReceivers(receivers.toArray(new String[receivers.size()]));
        parameter.setChannel(channel.toArray(new String[channel.size()]));
        parameter.setMsgType("task");
        parameter.setSubject(subject);
        parameter.setContent(content);
        parameter.setPcUrl(this.getPcUrl());
        parameter.setMobileUrl(this.getMbUrl());
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        try {
            CommonResponse result = this.pushMessageApi.pushNoAuthMessage(parameter);
            if (result.isSuccess()) {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
            } else {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
        }
        return CommonResponse.success((String)"\u53d1\u9001\u6d88\u606f\u6210\u529f");
    }

    @RequestMapping(value={"/warnSomeUser"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> warnSomeUser(HttpServletRequest request) {
        String param = request.getParameter("param");
        JSONArray json = JSONArray.parseArray((String)param);
        this.logger.info("\u83b7\u53d6\u5230\u7684\u53c2\u6570JSON\u662f\uff1a" + param + "----");
        String userIdsParam = null;
        if (json != null) {
            userIdsParam = json.getJSONObject(0).getJSONArray("parameters").getJSONObject(0).getString("value");
        }
        this.logger.info("\u83b7\u53d6\u5230\u7684\u53c2\u6570\u662f\uff1a" + userIdsParam + "----");
        if (StringUtils.isBlank((CharSequence)userIdsParam)) {
            return CommonResponse.success((String)"\u672a\u914d\u7f6e\u63d0\u9192\u4eba\u5458ID\uff01");
        }
        Object[] userIdList = userIdsParam.split(",");
        List receivers = Lists.newArrayList((Object[])userIdList);
        List fillIds = receivers.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(WorkTimeEntity::getFillId, fillIds);
        queryWrapper.apply(" DATE_FORMAT( date, '%Y-%m-%d' ) = DATE_FORMAT( DATE_SUB( NOW(), INTERVAL 1 DAY ), '%Y-%m-%d' ) ", new Object[0]);
        List list = this.workTimeService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List fillReceivers = list.stream().map(s -> String.valueOf(s.getFillId())).collect(Collectors.toList());
            receivers.removeAll(fillReceivers);
            this.logger.info("\u6628\u65e5\u5de5\u65f6\u5df2\u586b\u62a5:{}", (Object)JSONObject.toJSONString(fillReceivers));
        }
        if (CollectionUtils.isEmpty((Collection)receivers)) {
            return CommonResponse.success((String)"\u6628\u65e5\u5de5\u65f6\u90fd\u5df2\u586b\u62a5\uff01");
        }
        String subject = "\u540c\u5b66\uff0c\u4f60\u6628\u5929\u7684\u5de5\u65f6\u6ca1\u6709\u586b\u54e6\uff0c\u5757\u53bb\u63d0\u586b\u5199\u4e00\u4e0b\u5427^_^";
        String content = subject + "\u3002<a href=" + '\"' + this.getPcUrl() + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
        this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff01===========");
        PushMsgParameter parameter = new PushMsgParameter();
        ArrayList<String> channel = new ArrayList<String>();
        channel.add("sys");
        channel.add("weixin");
        JSONObject weixinParams = new JSONObject();
        weixinParams.put("template_id", (Object)WX_MSG_ID);
        JSONObject wxparams = new JSONObject();
        wxparams.put("first", (Object)subject);
        wxparams.put("keyword1", (Object)"\u6628\u65e5\u5de5\u65f6\u6f0f\u586b\u63d0\u9192");
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        wxparams.put("keyword2", (Object)formatter.format(new Date()));
        wxparams.put("remark", (Object)"\u70b9\u51fb\u6211\uff0c\u5feb\u901f\u53bb\u586b\u62a5\u5de5\u65f6\uff01");
        weixinParams.put("data", (Object)wxparams);
        weixinParams.put("url", (Object)(this.getMbUrl() + "?openid={openid}"));
        parameter.setWeixinParams(weixinParams);
        parameter.setReceivers(receivers.toArray(new String[receivers.size()]));
        parameter.setChannel(channel.toArray(new String[channel.size()]));
        parameter.setMsgType("task");
        parameter.setSubject(subject);
        parameter.setContent(content);
        parameter.setPcUrl(this.getPcUrl());
        parameter.setMobileUrl(this.getMbUrl());
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        try {
            CommonResponse result = this.pushMessageApi.pushNoAuthMessage(parameter);
            if (result.isSuccess()) {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
            } else {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
        }
        return CommonResponse.success((String)"\u53d1\u9001\u6d88\u606f\u6210\u529f");
    }

    private String getPcUrl() {
        return this.baseHost + "ejc-xmgs-frontend/#/workTime";
    }

    private String getMbUrl() {
        return this.baseHost + "ejc-xmgs-mobile/#/workTime";
    }
}

