package com.ejianc.zatopbpm.service.bpmEvent.impl;

import cn.hutool.json.JSONUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.zatopbpm.bean.BpmInfoEntity;
import com.ejianc.zatopbpm.bean.ErrorCallbackEntity;
import com.ejianc.zatopbpm.service.IBpmInfoService;
import com.ejianc.zatopbpm.service.IErrorCallbackService;
import com.ejianc.zatopbpm.service.bpmEvent.IAbandonBpmService;
import com.ejianc.zatopbpm.utils.BillState;
import com.ejianc.zatopbpm.utils.ErrorTypeConfig;
import com.ejianc.zatopbpm.utils.InitUserContextUtil;
import com.ejianc.zatopbpm.utils.UpdateBillStateUtils;
import com.google.gson.Gson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 *
 * 
 * @author generator
 * 
 */
@Service("abandonBpmService")
public class AbandonBpmServiceImpl implements IAbandonBpmService {

    // 日志
    private final Logger logger = LoggerFactory.getLogger(getClass());

    private Gson gson = new Gson();
    @Autowired
    private IBpmInfoService bpmInfoService;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private UpdateBillStateUtils updateBillStateUtils;
    @Autowired
    private IErrorCallbackService errorCallbackService;
    @Autowired
    private InitUserContextUtil initUserContextUtil;

    @Override
    public void abandonBpm(Map<String, Object> params) {
        String billId = params.get("billId")!=null ? params.get("billId").toString() : null;
        String billTypeCode = params.get("billTypeCode")!=null ? params.get("billTypeCode").toString() : null;
        String userid = params.get("userid")!=null ? params.get("userid").toString() : null;
        String bpmId = params.get("bpmId")!=null ? params.get("bpmId").toString() : null;

        String authority = initUserContextUtil.initUserContext(userid);
        if(authority.contains("userCode")){
            RequestAttributes context = RequestContextHolder.getRequestAttributes();
            context.setAttribute("authority", authority, RequestAttributes.SCOPE_REQUEST);
            RequestContextHolder.setRequestAttributes(context);
        }else {
            ErrorCallbackEntity entity = new ErrorCallbackEntity(Long.parseLong(billId), billTypeCode, ErrorTypeConfig.ABANDON_INITUSERCONTEXT, userid, JSONUtil.toJsonStr(params), "初始化上下文信息失败-----"+authority);
            errorCallbackService.saveOrUpdate(entity, false);
            return;
        }

        //修改流程状态
        BpmInfoEntity infoEntity = bpmInfoService.selectByBpmId(bpmId);
        infoEntity.setType("abandon");
        bpmInfoService.saveOrUpdate(infoEntity,false);

        logger.info("------------------弃审事件开始---------------------------");
        CommonResponse<String> beforeAbstainingResponse = updateBillStateUtils.beforeAbstainingProcessor(
                Long.parseLong(billId), billTypeCode, BillState.UNCOMMITED_STATE);
        if (!beforeAbstainingResponse.isSuccess()) {
            logger.error("弃审前事件回调报错， 请检查对应服务是否正常！");
            logger.error(beforeAbstainingResponse.getMsg());
            String message = beforeAbstainingResponse.getMsg()!=null&&beforeAbstainingResponse.getMsg().length()>1000? (beforeAbstainingResponse.getMsg().substring(0,1000)):beforeAbstainingResponse.getMsg();
            ErrorCallbackEntity entity = new ErrorCallbackEntity(Long.parseLong(billId), billTypeCode, ErrorTypeConfig.BEFOREABSTAINING, userid, JSONUtil.toJsonStr(params), message);
            errorCallbackService.saveOrUpdate(entity, false);
        }

        logger.info("回写单据状态！===========" + "将单据id:" + billId + "的状态改为0（自由态）");
        CommonResponse<String> back = updateBillStateUtils.updateBillState(Long.parseLong(billId), billTypeCode, BillState.UNCOMMITED_STATE);
        if(!back.isSuccess()){
            logger.info("！！！！！！！！回写单据状态失败！！！！！！！！！" + "将单据id:" + billId + "的状态改为0（自由态）失败");
            ErrorCallbackEntity entity = new ErrorCallbackEntity(Long.parseLong(billId), billTypeCode, ErrorTypeConfig.ABANDON_UPDATEBILLSTATE, userid, JSONUtil.toJsonStr(params), "更新单据状态失败");
            errorCallbackService.saveOrUpdate(entity, false);
        }

        CommonResponse<String> afterAbstainingResponse = updateBillStateUtils.afterAbstainingProcessor(
                Long.parseLong(billId), billTypeCode, BillState.UNCOMMITED_STATE);
        if (!afterAbstainingResponse.isSuccess()) {
            logger.info("弃审后回调事件返回结果"+afterAbstainingResponse.getMsg().toString());
            logger.error(afterAbstainingResponse.getMsg());
            String message = afterAbstainingResponse.getMsg()!=null&&afterAbstainingResponse.getMsg().length()>1000? (afterAbstainingResponse.getMsg().substring(0,1000)):afterAbstainingResponse.getMsg();
            ErrorCallbackEntity entity = new ErrorCallbackEntity(Long.parseLong(billId), billTypeCode, ErrorTypeConfig.AFTERABSTAINING, userid, JSONUtil.toJsonStr(params), message);
            errorCallbackService.saveOrUpdate(entity, false);
        }
        logger.info("------------------弃审事件结束---------------------------");
    }
}
