package com.ejianc.zatopbpm.service.bpmEvent.impl;

import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.zatopbpm.bean.BpmInfoEntity;
import com.ejianc.zatopbpm.bean.ErrorCallbackEntity;
import com.ejianc.zatopbpm.service.IBpmInfoService;
import com.ejianc.zatopbpm.service.IErrorCallbackService;
import com.ejianc.zatopbpm.service.bpmEvent.IStartBpmService;
import com.ejianc.zatopbpm.utils.BillState;
import com.ejianc.zatopbpm.utils.ErrorTypeConfig;
import com.ejianc.zatopbpm.utils.InitUserContextUtil;
import com.ejianc.zatopbpm.utils.UpdateBillStateUtils;
import com.google.gson.Gson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

/**
 *
 * 
 * @author generator
 * 
 */
@Service("startBpmService")
public class StartBpmServiceImpl implements IStartBpmService {

    // 日志
    private final Logger logger = LoggerFactory.getLogger(getClass());

    private Gson gson = new Gson();

    @Autowired
    private IBpmInfoService bpmInfoService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private UpdateBillStateUtils updateBillStateUtils;
    @Autowired
    private IErrorCallbackService errorCallbackService;
    @Autowired
    private InitUserContextUtil initUserContextUtil;

    @Override
    public void startBpm(Map<String, Object> params) {
        String billId = params.get("billId")!=null ? params.get("billId").toString() : null;
        String billTypeCode = params.get("billTypeCode")!=null ? params.get("billTypeCode").toString() : null;
        String zatopUrl = params.get("zatopUrl")!=null ? params.get("zatopUrl").toString() : null;
        String bpmId = params.get("bpmId")!=null ? params.get("bpmId").toString() : null;
        String type = params.get("type")!=null ? params.get("type").toString() : null;
        String userid = params.get("userid")!=null ? params.get("userid").toString() : null;

        String authority = initUserContextUtil.initUserContext(userid);
        if(authority.contains("userCode")){
            RequestAttributes context = RequestContextHolder.getRequestAttributes();
            context.setAttribute("authority", authority, RequestAttributes.SCOPE_REQUEST);
            RequestContextHolder.setRequestAttributes(context);
        }else {
            ErrorCallbackEntity entity = new ErrorCallbackEntity(Long.parseLong(billId), billTypeCode, ErrorTypeConfig.SUBMIT_INITUSERCONTEXT, userid, JSONUtil.toJsonStr(params), "初始化上下文信息失败-----"+authority);
            errorCallbackService.saveOrUpdate(entity, false);
            return;
        }


        //根据流程id获取一下，若是存在，不新增，否则获取有单据id，无流程的单子，更新流程信息
        QueryWrapper<BpmInfoEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("dr", 0);
        wrapper.eq("bpm_id", bpmId);
        List<BpmInfoEntity> list = bpmInfoService.list(wrapper);
        if(list!=null && list.size()>0){
            BpmInfoEntity entity = list.get(0);
            entity.setZatopUrl(zatopUrl);
            entity.setType(type);
            entity.setBpmId(bpmId);
            entity.setUserid(userid);
            bpmInfoService.saveOrUpdate(entity, false);
        }else{
            QueryWrapper<BpmInfoEntity> wrapperBillId = new QueryWrapper<>();
            wrapperBillId.eq("dr", 0);
            wrapperBillId.eq("bpm_id", null);
            wrapperBillId.eq("bill_type_code", billTypeCode);
            wrapperBillId.eq("bill_id", billId);
            wrapperBillId.orderByDesc("create_time");
            List<BpmInfoEntity> data = bpmInfoService.list(wrapperBillId);
            if(data!=null && data.size()>0){
                BpmInfoEntity entity = data.get(0);
                entity.setZatopUrl(zatopUrl);
                entity.setType(type);
                entity.setBpmId(bpmId);
                entity.setUserid(userid);
                bpmInfoService.saveOrUpdate(entity, false);
            }
        }
        //执行提交事件
        logger.info("--------------提交回调事件开始-----------------");
        CommonResponse<String> brforeSubmitResponse = updateBillStateUtils.beforeSubmitProcessor(Long.parseLong(billId), billTypeCode, BillState.UNCOMMITED_STATE);
        if(!brforeSubmitResponse.isSuccess()) {
            logger.error("提交前回调前事件报错， 请检查对应服务是否正常！");
            logger.error(brforeSubmitResponse.getMsg());
            String message = brforeSubmitResponse.getMsg()!=null&&brforeSubmitResponse.getMsg().length()>1000? (brforeSubmitResponse.getMsg().substring(0,1000)):brforeSubmitResponse.getMsg();
            ErrorCallbackEntity entity = new ErrorCallbackEntity(Long.parseLong(billId), billTypeCode, ErrorTypeConfig.BRFORESUBMIT, userid, JSONUtil.toJsonStr(params), message);
            errorCallbackService.saveOrUpdate(entity, false);
        }
        //回写单据状态
        logger.info("回写单据状态！==========="+"将单据id:"+billId+"的状态改为5（有审批的提交态）");
        CommonResponse<String> back = updateBillStateUtils.updateBillState(Long.parseLong(billId), billTypeCode, BillState.APPROVING_UNEXAM_STATE);
        if(!back.isSuccess()){
            logger.info("！！！！！！！！回写单据状态失败！！！！！！！！！" + "将单据id:" + billId + "的状态改为5（有审批的提交态）失败");
            ErrorCallbackEntity entity = new ErrorCallbackEntity(Long.parseLong(billId), billTypeCode, ErrorTypeConfig.SUBMIT_UPDATEBILLSTATE, userid, JSONUtil.toJsonStr(params), "更新单据状态失败");
            errorCallbackService.saveOrUpdate(entity, false);
        }
        CommonResponse<String> afterSubmitResponse = updateBillStateUtils.afterSubmitProcessor(Long.parseLong(billId), billTypeCode, BillState.APPROVING_UNEXAM_STATE);
        if(!afterSubmitResponse.isSuccess()) {
            logger.error("提交后回调前事件报错， 请检查对应服务是否正常！");
            logger.error(afterSubmitResponse.getMsg());
            String message = afterSubmitResponse.getMsg()!=null&&afterSubmitResponse.getMsg().length()>1000? (afterSubmitResponse.getMsg().substring(0,1000)):afterSubmitResponse.getMsg();
            ErrorCallbackEntity entity = new ErrorCallbackEntity(Long.parseLong(billId), billTypeCode, ErrorTypeConfig.AFTERSUBMIT, userid, JSONUtil.toJsonStr(params), message);
            errorCallbackService.saveOrUpdate(entity, false);
        }
        logger.info("--------------提交回调事件结束-----------------");
    }
}
