package com.ejianc.zatopbpm.utils;

import ch.qos.logback.core.db.DBAppenderBase;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.metadata.api.IMdApi;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

@SuppressWarnings("unchecked")
@Component
public class InitUserContextUtil {

    // 日志
    private final Logger logger = LoggerFactory.getLogger(getClass());

    private Gson gson = new Gson();

    @Autowired
    private IUserApi userApi;

    public String initUserContext(String userSourceId) {
        StringBuilder authtoken = new StringBuilder();
        CommonResponse<JSONObject> userContextResponse = userApi.getUserContextBySourceId(userSourceId);
        if(userContextResponse.isSuccess()) {
            JSONObject userContext = userContextResponse.getData().getJSONObject("userContext");
            authtoken.append("userType=").append(userContext.get("userType"))
                    .append(";userCode=").append(userContext.get("userCode"))
                    .append(";orgId=").append(userContext.get("orgId"))
                    .append(";tenantid=").append(userContext.get("tenantid"))
                    .append(";token=").append(userContext.get("token"))
                    .append(";u_logints=").append(userContext.get("u_logints"))
                    .append(";u_usercode=").append(userContext.get("u_usercode"))
                    .append(";userId=").append(userContext.get("userId"));
        }else{
            authtoken.append(userContextResponse.getMsg());
        }

        return authtoken.toString();
    }

}
