/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.common.CommonZatopDataDealService;
import com.ejianc.business.consts.ZatopConstsUtil;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.zatopbpm.service.common.ICommonZatopBusinessService;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="ejc-material-web-useApplyZatop")
public class UseApplyZatopbpmServiceImpl
extends CommonZatopDataDealService
implements ICommonZatopBusinessService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public JSONObject dealBillData(Long billId, JSONObject billData) {
        billData.put("isExceed", (Object)ZatopConstsUtil.getYesOrNoName(billData.getString("isExceed")));
        billData.put("isAbove", (Object)ZatopConstsUtil.getYesOrNoName(billData.getString("isAbove")));
        this.logger.info("{}-billData:{}", (Object)this.getClass().getName(), (Object)JSON.toJSONString((Object)billData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        return billData;
    }

    @Override
    public JSONArray addFields(Long billId, JSONObject billData, JSONArray fields) {
        return this.addFieldsForBillData(billId, billData, fields);
    }

    @Override
    public JSONArray dealBillchldrenData(Long billId, String entityName, JSONArray childrenData) {
        if (entityName.contains("UseApplySubEntity") && childrenData != null && childrenData.size() > 0) {
            for (int i = 0; i < childrenData.size(); ++i) {
                JSONObject obj = childrenData.getJSONObject(i);
                BigDecimal orderNum = ComputeUtil.toBigDecimal((Object)obj.get((Object)"orderNum"));
                BigDecimal masterPlanNum = ComputeUtil.toBigDecimal((Object)obj.get((Object)"masterPlanNum"));
                obj.put("orderNumMasterPlanNum", (Object)(ComputeUtil.scaleTwo((BigDecimal)orderNum) + "/" + ComputeUtil.scaleTwo((BigDecimal)masterPlanNum)));
            }
        }
        return childrenData;
    }

    @Override
    public JSONArray dealBillChildrenData(Long billId, JSONArray lists) {
        return lists;
    }

    @Override
    public JSONArray dealBillAttachmentsData(Long billId, String billTypeCode, String sourceType, JSONArray attachments) {
        return attachments;
    }
}

