/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.zatopbpm.service.bpmEvent.impl;

import cn.hutool.json.JSONUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.zatopbpm.bean.BpmInfoEntity;
import com.ejianc.zatopbpm.bean.ErrorCallbackEntity;
import com.ejianc.zatopbpm.service.IBpmInfoService;
import com.ejianc.zatopbpm.service.IErrorCallbackService;
import com.ejianc.zatopbpm.service.bpmEvent.IAbandonBpmService;
import com.ejianc.zatopbpm.utils.BillState;
import com.ejianc.zatopbpm.utils.InitUserContextUtil;
import com.ejianc.zatopbpm.utils.UpdateBillStateUtils;
import com.google.gson.Gson;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="abandonBpmService")
public class AbandonBpmServiceImpl
implements IAbandonBpmService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Gson gson = new Gson();
    @Autowired
    private IBpmInfoService bpmInfoService;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private UpdateBillStateUtils updateBillStateUtils;
    @Autowired
    private IErrorCallbackService errorCallbackService;
    @Autowired
    private InitUserContextUtil initUserContextUtil;

    @Override
    public void abandonBpm(Map<String, Object> params) {
        CommonResponse<String> afterAbstainingResponse;
        ErrorCallbackEntity entity;
        String billId = params.get("billId") != null ? params.get("billId").toString() : null;
        String billTypeCode = params.get("billTypeCode") != null ? params.get("billTypeCode").toString() : null;
        String userid = params.get("userid") != null ? params.get("userid").toString() : null;
        String bpmId = params.get("bpmId") != null ? params.get("bpmId").toString() : null;
        String authority = this.initUserContextUtil.initUserContext(userid);
        if (!authority.contains("userCode")) {
            ErrorCallbackEntity entity2 = new ErrorCallbackEntity(Long.parseLong(billId), billTypeCode, "abandon-initUserContext", userid, JSONUtil.toJsonStr(params), "\u521d\u59cb\u5316\u4e0a\u4e0b\u6587\u4fe1\u606f\u5931\u8d25-----" + authority);
            this.errorCallbackService.saveOrUpdate((Object)entity2, false);
            return;
        }
        InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)authority);
        BpmInfoEntity infoEntity = this.bpmInfoService.selectByBpmId(bpmId);
        infoEntity.setType("abandon");
        this.bpmInfoService.saveOrUpdate((Object)infoEntity, false);
        this.logger.info("------------------\u5f03\u5ba1\u4e8b\u4ef6\u5f00\u59cb---------------------------");
        CommonResponse<String> beforeAbstainingResponse = this.updateBillStateUtils.beforeAbstainingProcessor(Long.parseLong(billId), billTypeCode, BillState.UNCOMMITED_STATE);
        if (!beforeAbstainingResponse.isSuccess()) {
            this.logger.error("\u5f03\u5ba1\u524d\u4e8b\u4ef6\u56de\u8c03\u62a5\u9519\uff0c \u8bf7\u68c0\u67e5\u5bf9\u5e94\u670d\u52a1\u662f\u5426\u6b63\u5e38\uff01");
            this.logger.error(beforeAbstainingResponse.getMsg());
            String message = beforeAbstainingResponse.getMsg() != null && beforeAbstainingResponse.getMsg().length() > 1000 ? beforeAbstainingResponse.getMsg().substring(0, 1000) : beforeAbstainingResponse.getMsg();
            entity = new ErrorCallbackEntity(Long.parseLong(billId), billTypeCode, "abandon-beforeAbstaining", userid, JSONUtil.toJsonStr(params), message);
            this.errorCallbackService.saveOrUpdate((Object)entity, false);
        }
        this.logger.info("\u56de\u5199\u5355\u636e\u72b6\u6001\uff01===========\u5c06\u5355\u636eid:" + billId + "\u7684\u72b6\u6001\u6539\u4e3a0\uff08\u81ea\u7531\u6001\uff09");
        CommonResponse<String> back = this.updateBillStateUtils.updateBillState(Long.parseLong(billId), billTypeCode, BillState.UNCOMMITED_STATE);
        if (!back.isSuccess()) {
            this.logger.info("\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\u56de\u5199\u5355\u636e\u72b6\u6001\u5931\u8d25\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\u5c06\u5355\u636eid:" + billId + "\u7684\u72b6\u6001\u6539\u4e3a0\uff08\u81ea\u7531\u6001\uff09\u5931\u8d25");
            entity = new ErrorCallbackEntity(Long.parseLong(billId), billTypeCode, "abandon-updateBillState", userid, JSONUtil.toJsonStr(params), "\u66f4\u65b0\u5355\u636e\u72b6\u6001\u5931\u8d25");
            this.errorCallbackService.saveOrUpdate((Object)entity, false);
        }
        if (!(afterAbstainingResponse = this.updateBillStateUtils.afterAbstainingProcessor(Long.parseLong(billId), billTypeCode, BillState.UNCOMMITED_STATE)).isSuccess()) {
            this.logger.info("\u5f03\u5ba1\u540e\u56de\u8c03\u4e8b\u4ef6\u8fd4\u56de\u7ed3\u679c" + afterAbstainingResponse.getMsg().toString());
            this.logger.error(afterAbstainingResponse.getMsg());
            String message = afterAbstainingResponse.getMsg() != null && afterAbstainingResponse.getMsg().length() > 1000 ? afterAbstainingResponse.getMsg().substring(0, 1000) : afterAbstainingResponse.getMsg();
            ErrorCallbackEntity entity3 = new ErrorCallbackEntity(Long.parseLong(billId), billTypeCode, "abandon-afterAbstaining", userid, JSONUtil.toJsonStr(params), message);
            this.errorCallbackService.saveOrUpdate((Object)entity3, false);
        }
        this.logger.info("------------------\u5f03\u5ba1\u4e8b\u4ef6\u7ed3\u675f---------------------------");
    }
}

