/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.common.CommonZatopDataDealService;
import com.ejianc.business.consts.ZatopConstsUtil;
import com.ejianc.zatopbpm.service.common.ICommonZatopBusinessService;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="ejc-finance-web-paySporadicZatop")
public class PaySporadicZatopbpmServiceImpl
extends CommonZatopDataDealService
implements ICommonZatopBusinessService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static Map<String, String> sporadicPaymentTypeMap = new HashMap<String, String>();
    private static Map<String, String> invoiceFlagMap = new HashMap<String, String>();

    @Override
    public JSONObject dealBillData(Long billId, JSONObject billData) {
        billData.put("sporadicPaymentType", (Object)sporadicPaymentTypeMap.get(billData.getString("sporadicPaymentType")));
        billData.put("dependOnProject", (Object)ZatopConstsUtil.getYesOrNoName(billData.getString("dependOnProject")));
        this.logger.info("PaySporadicZatopbpmServiceImpl-billData:{}", (Object)JSON.toJSONString((Object)billData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        return billData;
    }

    @Override
    public JSONArray addFields(Long billId, JSONObject billData, JSONArray fields) {
        JSONObject field = new JSONObject();
        field.put("id", (Object)"invoiceFlagName");
        field.put("name", (Object)"\u662f\u5426\u6709\u53d1\u7968");
        field.put("value", (Object)invoiceFlagMap.get(billData.getString("invoiceFlag")));
        fields.add((Object)field);
        return this.addFieldsForBillData(billId, billData, fields);
    }

    @Override
    public JSONArray dealBillchldrenData(Long billId, String entityName, JSONArray childrenData) {
        return childrenData;
    }

    @Override
    public JSONArray dealBillChildrenData(Long billId, JSONArray lists) {
        return lists;
    }

    @Override
    public JSONArray dealBillAttachmentsData(Long billId, String billTypeCode, String sourceType, JSONArray attachments) {
        return attachments;
    }

    static {
        sporadicPaymentTypeMap.put("1", "\u96f6\u661f\u6750\u6599");
        sporadicPaymentTypeMap.put("2", "\u96f6\u661f\u673a\u68b0");
        sporadicPaymentTypeMap.put("3", "\u5176\u4ed6");
        invoiceFlagMap.put("1", "\u6709");
        invoiceFlagMap.put("2", "\u6ca1\u6709");
        invoiceFlagMap.put("3", "\u4e0d\u786e\u5b9a");
    }
}

