/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.zatopbpm.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.support.api.IModuleApi;
import com.ejianc.foundation.support.vo.ModuleVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.zatopbpm.bean.BpmConfigEntity;
import com.ejianc.zatopbpm.bean.BpmOrgRelationEntity;
import com.ejianc.zatopbpm.service.IBpmConfigService;
import com.ejianc.zatopbpm.service.IBpmOrgRelationService;
import com.ejianc.zatopbpm.vo.BpmConfigVO;
import com.ejianc.zatopbpm.vo.BpmOrgRelationVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"bpmConfig"})
public class BpmConfigController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBpmConfigService service;
    @Autowired
    private IBpmOrgRelationService orgRelationService;
    @Autowired
    private IModuleApi moduleApi;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BpmConfigVO> queryDetail(Long id) {
        BpmConfigEntity entity = (BpmConfigEntity)((Object)this.service.selectById(id));
        BpmConfigVO vo = (BpmConfigVO)((Object)BeanMapper.map((Object)((Object)entity), BpmConfigVO.class));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"config_id", (Object)vo.getId());
        List<BpmOrgRelationEntity> relation = this.orgRelationService.querylist((QueryWrapper<BpmOrgRelationEntity>)queryWrapper);
        if (relation != null && relation.size() > 0) {
            vo.setRelationList(BeanMapper.mapList(relation, BpmOrgRelationVO.class));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BpmConfigVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        if (param.getParams().get("moduleId") != null) {
            ArrayList<Long> moduleIds = new ArrayList<Long>();
            CommonResponse moduleResponse = this.moduleApi.queryModuleListByPid(Long.valueOf(Long.parseLong(((Parameter)param.getParams().get("moduleId")).getValue().toString())));
            if (moduleResponse.isSuccess()) {
                List modules = (List)moduleResponse.getData();
                for (int i = 0; i < modules.size(); ++i) {
                    moduleIds.add(((ModuleVO)modules.get(i)).getId());
                }
            }
            ((Parameter)param.getParams().get("moduleId")).setType("in");
            ((Parameter)param.getParams().get("moduleId")).setValue(moduleIds);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BpmConfigVO.class));
        if (pageData.getRecords() != null && pageData.getRecords().size() > 0) {
            for (BpmConfigVO vo : pageData.getRecords()) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"dr", (Object)0);
                queryWrapper.eq((Object)"config_id", (Object)vo.getId());
                List<BpmOrgRelationEntity> relation = this.orgRelationService.querylist((QueryWrapper<BpmOrgRelationEntity>)queryWrapper);
                if (relation == null || relation.size() <= 0) continue;
                String useOrg = "";
                for (BpmOrgRelationEntity entity : relation) {
                    if (entity.getOrgId() == null) continue;
                    try {
                        JSONArray jArray = ReferObjectUtil.getReferEntityValue((String)entity.getOrgId().toString(), (String)"idm-org");
                        if (jArray == null || jArray.size() <= 0) continue;
                        JSONObject json = (JSONObject)jArray.get(0);
                        if (useOrg.length() > 0) {
                            if ("self".equals(entity.getRange())) {
                                useOrg = useOrg + "\u3001" + json.get((Object)"name").toString() + "(\u672c\u7ea7)";
                                continue;
                            }
                            useOrg = useOrg + "\u3001" + json.get((Object)"name").toString() + "(\u672c\u4e0b)";
                            continue;
                        }
                        if ("self".equals(entity.getRange())) {
                            useOrg = useOrg + json.get((Object)"name").toString() + "(\u672c\u7ea7)";
                            continue;
                        }
                        useOrg = useOrg + json.get((Object)"name").toString() + "(\u672c\u4e0b)";
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                vo.setUseOrg(useOrg);
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BpmConfigVO> save(@RequestBody BpmConfigVO saveData) {
        return this.service.saveData(saveData);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BpmConfigVO> vos) {
        return this.service.deleteVOs(vos);
    }
}

